/*
 * Decompiled with CFR 0.152.
 */
package com.vinlanx.explosionoverhaul;

import com.vinlanx.explosionoverhaul.Config;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ExplosionClusterHandler {
    public static float calculateClusteredPower(Level level, Vec3 explosionPos, float initialPower) {
        if (!((Boolean)Config.COMMON.enableExplosionClustering.get()).booleanValue()) {
            return initialPower;
        }
        double searchRadius = ExplosionClusterHandler.getSearchRadius(initialPower);
        AABB searchBox = new AABB(explosionPos.f_82479_ - searchRadius, explosionPos.f_82480_ - searchRadius, explosionPos.f_82481_ - searchRadius, explosionPos.f_82479_ + searchRadius, explosionPos.f_82480_ + searchRadius, explosionPos.f_82481_ + searchRadius);
        List tntEntities = level.m_45976_(PrimedTnt.class, searchBox);
        ArrayList<BlockPos> tntBlocks = new ArrayList<BlockPos>();
        BlockPos centerPos = BlockPos.m_274446_((Position)explosionPos);
        int radiusBlocks = (int)Math.ceil(searchRadius);
        for (int x = -radiusBlocks; x <= radiusBlocks; ++x) {
            for (int y = -radiusBlocks; y <= radiusBlocks; ++y) {
                for (int z = -radiusBlocks; z <= radiusBlocks; ++z) {
                    BlockPos pos = centerPos.m_7918_(x, y, z);
                    BlockState state = level.m_8055_(pos);
                    if (state.m_60734_() != Blocks.f_50077_) continue;
                    tntBlocks.add(pos);
                }
            }
        }
        if (tntEntities.isEmpty() && tntBlocks.isEmpty()) {
            return initialPower;
        }
        ArrayList<ExplosionSource> sources = new ArrayList<ExplosionSource>();
        sources.add(new ExplosionSource(explosionPos, initialPower));
        for (PrimedTnt tnt : tntEntities) {
            if (tnt.m_20182_().equals((Object)explosionPos)) continue;
            sources.add(new ExplosionSource(tnt.m_20182_(), 4.0f));
        }
        for (BlockPos pos : tntBlocks) {
            Vec3 blockPos = Vec3.m_82512_((Vec3i)pos);
            if (blockPos.equals((Object)explosionPos)) continue;
            sources.add(new ExplosionSource(blockPos, 4.0f));
        }
        ExplosionSource mainSource = sources.stream().max((a, b) -> Float.compare(a.power, b.power)).orElse((ExplosionSource)sources.get(0));
        float totalPower = mainSource.power;
        for (ExplosionSource source : sources) {
            if (source == mainSource) continue;
            float addition = ExplosionClusterHandler.getPowerAddition(source.power);
            totalPower += addition;
        }
        for (PrimedTnt tnt : tntEntities) {
            if (tnt.m_20182_().equals((Object)explosionPos)) continue;
            tnt.m_146870_();
        }
        for (BlockPos pos : tntBlocks) {
            Vec3 blockPos = Vec3.m_82512_((Vec3i)pos);
            if (blockPos.equals((Object)explosionPos)) continue;
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        }
        return totalPower;
    }

    private static double getSearchRadius(float power) {
        if (power <= 4.0f) {
            return 3.0;
        }
        if (power <= 10.0f) {
            return 5.0;
        }
        if (power <= 25.0f) {
            return 10.0;
        }
        if (power <= 35.0f) {
            return 14.0;
        }
        return 20.0;
    }

    private static float getPowerAddition(float power) {
        if (power <= 4.0f) {
            return 2.0f;
        }
        if (power <= 10.0f) {
            return 5.0f;
        }
        if (power <= 25.0f) {
            return 10.0f;
        }
        if (power <= 35.0f) {
            return 15.0f;
        }
        return 15.0f;
    }

    private static class ExplosionSource {
        Vec3 position;
        float power;

        ExplosionSource(Vec3 position, float power) {
            this.position = position;
            this.power = power;
        }
    }
}

