/*
 * Decompiled with CFR 0.152.
 */
package com.vinlanx.explosionoverhaul;

import com.mojang.logging.LogUtils;
import com.vinlanx.explosionoverhaul.AmbientExplosionManager;
import com.vinlanx.explosionoverhaul.BlockIndexManager;
import com.vinlanx.explosionoverhaul.ClientSoundHandler;
import com.vinlanx.explosionoverhaul.Config;
import com.vinlanx.explosionoverhaul.CustomGlowParticleOptions;
import com.vinlanx.explosionoverhaul.DripstoneEffects;
import com.vinlanx.explosionoverhaul.GlassBreakingEffects;
import com.vinlanx.explosionoverhaul.ModParticles;
import com.vinlanx.explosionoverhaul.ModSounds;
import com.vinlanx.explosionoverhaul.PacketHandler;
import com.vinlanx.explosionoverhaul.PlasmaParticleOptions;
import com.vinlanx.explosionoverhaul.RedstoneLampEffects;
import com.vinlanx.explosionoverhaul.ScanInfoHUD;
import com.vinlanx.explosionoverhaul.ScanKeyHandler;
import com.vinlanx.explosionoverhaul.ScanLoadInfoHUD;
import com.vinlanx.explosionoverhaul.ScanLoadPromptHUD;
import com.vinlanx.explosionoverhaul.ScanProgressHUD;
import com.vinlanx.explosionoverhaul.ScanPromptHUD;
import com.vinlanx.explosionoverhaul.ServerExplosionHandler;
import com.vinlanx.explosionoverhaul.client.ClientEffects;
import com.vinlanx.explosionoverhaul.client.CustomGlowParticleProvider;
import com.vinlanx.explosionoverhaul.client.LineSparkParticleProvider;
import com.vinlanx.explosionoverhaul.client.ModConfigScreen;
import com.vinlanx.explosionoverhaul.client.PlasmaParticle;
import com.vinlanx.explosionoverhaul.client.SmokeParticle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;

@Mod(value="explosionoverhaul")
public class ExplosionOverhaul {
    public static final String MODID = "explosionoverhaul";
    public static final Logger LOGGER = LogUtils.getLogger();
    private static final Set<String> EXPLOSION_BLACKLIST = Set.of("ancient_elements:block_of_raw_infernal_ore", "ancient_elements:celestium_ore", "ancient_elements:deepslate_frost_ore", "ancient_elements:deepslate_jungle_steel_ore", "ancient_elements:deepslate_lead_ore", "ancient_elements:deepslate_steel_ore", "ancient_elements:deepslate_tin_ore", "ancient_elements:deepslate_titanium_ore", "ancient_elements:ender_steel_ore", "ancient_elements:endrium_ore", "ancient_elements:frost_ore", "ancient_elements:infernal_ore", "ancient_elements:jungle_steel_ore", "ancient_elements:lead_ore", "ancient_elements:meteorite_ore", "ancient_elements:nether_steel_ore", "ancient_elements:palladium_ore", "ancient_elements:spectrillium_ore", "ancient_elements:steel_ore", "ancient_elements:tin_ore", "ancient_elements:titanium_ore", "ancient_elements:void_steel_ore");
    private static final List<DelayedSound> delayedSounds = Collections.synchronizedList(new ArrayList());
    private static final List<DelayedParticle> delayedParticles = Collections.synchronizedList(new ArrayList());

    @SubscribeEvent
    public static void onServerTick(TickEvent.LevelTickEvent event) {
        Level level = event.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (event.phase == TickEvent.Phase.END) {
                DripstoneEffects.onServerTick(serverLevel);
            }
        }
    }

    public static boolean isBlockBlacklisted(Block block) {
        ResourceLocation blockId = ForgeRegistries.BLOCKS.getKey((Object)block);
        if (blockId != null) {
            String blockName = blockId.toString();
            return EXPLOSION_BLACKLIST.contains(blockName);
        }
        return false;
    }

    public static boolean isBlockStateBlacklisted(BlockState state) {
        ResourceLocation blockId = ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_());
        if (blockId != null) {
            String blockName = blockId.toString();
            return EXPLOSION_BLACKLIST.contains(blockName);
        }
        return false;
    }

    public ExplosionOverhaul() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.COMMON_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.CLIENT_SPEC);
        ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((client, parent) -> ModConfigScreen.create(parent)));
        ModSounds.register(modEventBus);
        ModParticles.register(modEventBus);
        MinecraftForge.EVENT_BUS.register(ExplosionOverhaul.class);
        MinecraftForge.EVENT_BUS.register((Object)new ServerExplosionHandler());
        MinecraftForge.EVENT_BUS.register(BlockIndexManager.class);
        modEventBus.addListener(this::commonSetup);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            modEventBus.addListener(ClientSetup::registerParticleFactories);
            MinecraftForge.EVENT_BUS.register(ClientSetup.class);
            MinecraftForge.EVENT_BUS.register((Object)new ClientSoundHandler());
            MinecraftForge.EVENT_BUS.register(ScanProgressHUD.class);
            MinecraftForge.EVENT_BUS.register(ScanPromptHUD.class);
            MinecraftForge.EVENT_BUS.register(ScanInfoHUD.class);
            MinecraftForge.EVENT_BUS.register(ScanLoadPromptHUD.class);
            MinecraftForge.EVENT_BUS.register(ScanLoadInfoHUD.class);
            MinecraftForge.EVENT_BUS.register((Object)new ScanKeyHandler());
        });
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(PacketHandler::register);
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            delayedSounds.removeIf(delayedSound -> {
                --delayedSound.ticksRemaining;
                if (delayedSound.ticksRemaining <= 0L) {
                    delayedSound.play();
                    return true;
                }
                return false;
            });
            delayedParticles.removeIf(delayedParticle -> {
                --delayedParticle.ticksRemaining;
                if (delayedParticle.ticksRemaining <= 0L) {
                    delayedParticle.spawn();
                    if (delayedParticle.durationTicks > 1L) {
                        --delayedParticle.durationTicks;
                        delayedParticle.ticksRemaining = 1L;
                        return false;
                    }
                    return true;
                }
                return false;
            });
            RedstoneLampEffects.onServerTick();
            GlassBreakingEffects.onServerTick();
            AmbientExplosionManager.onServerTick(event.getServer().m_129783_());
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            AmbientExplosionManager.onPlayerLoggedIn((ServerPlayer)event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            AmbientExplosionManager.onPlayerLoggedOut((ServerPlayer)event.getEntity());
        }
    }

    public static void addDelayedSound(ServerPlayer player, SoundEvent sound, SoundSource source, float x, float y, float z, float volume, float pitch, long seed, long delayTicks) {
        if (player.f_8906_ == null) {
            return;
        }
        if (delayTicks <= 0L) {
            player.f_8906_.m_9829_((Packet)new ClientboundSoundPacket((Holder)ForgeRegistries.SOUND_EVENTS.getHolder((Object)sound).orElseThrow(), source, (double)x, (double)y, (double)z, volume, pitch, seed));
        } else {
            delayedSounds.add(new DelayedSound(player, sound, source, x, y, z, volume, pitch, seed, delayTicks));
        }
    }

    public static void addDelayedParticle(ServerLevel level, BlockParticleOption particleOption, double x, double y, double z, int count, double dx, double dy, double dz, double speed, long delayTicks, long durationTicks) {
        if (delayTicks <= 0L && durationTicks <= 1L) {
            level.m_8767_((ParticleOptions)particleOption, x, y, z, count, dx, dy, dz, speed);
        } else {
            delayedParticles.add(new DelayedParticle(level, particleOption, x, y, z, count, dx, dy, dz, speed, delayTicks, Math.max(1L, durationTicks)));
        }
    }

    public static class DelayedSound {
        public ServerPlayer player;
        public SoundEvent sound;
        public SoundSource source;
        public float x;
        public float y;
        public float z;
        public float volume;
        public float pitch;
        public long seed;
        public long ticksRemaining;

        public DelayedSound(ServerPlayer player, SoundEvent sound, SoundSource source, float x, float y, float z, float volume, float pitch, long seed, long ticksRemaining) {
            this.player = player;
            this.sound = sound;
            this.source = source;
            this.x = x;
            this.y = y;
            this.z = z;
            this.volume = volume;
            this.pitch = pitch;
            this.seed = seed;
            this.ticksRemaining = ticksRemaining;
        }

        public void play() {
            if (this.player.f_8906_ == null) {
                return;
            }
            this.player.f_8906_.m_9829_((Packet)new ClientboundSoundPacket((Holder)ForgeRegistries.SOUND_EVENTS.getHolder((Object)this.sound).orElseThrow(), this.source, (double)this.x, (double)this.y, (double)this.z, this.volume, this.pitch, this.seed));
        }
    }

    public static class DelayedParticle {
        public ServerLevel level;
        public BlockParticleOption particleOption;
        public double x;
        public double y;
        public double z;
        public int count;
        public double dx;
        public double dy;
        public double dz;
        public double speed;
        public long ticksRemaining;
        public long durationTicks;

        public DelayedParticle(ServerLevel level, BlockParticleOption particleOption, double x, double y, double z, int count, double dx, double dy, double dz, double speed, long ticksRemaining, long durationTicks) {
            this.level = level;
            this.particleOption = particleOption;
            this.x = x;
            this.y = y;
            this.z = z;
            this.count = count;
            this.dx = dx;
            this.dy = dy;
            this.dz = dz;
            this.speed = speed;
            this.ticksRemaining = ticksRemaining;
            this.durationTicks = durationTicks;
        }

        public void spawn() {
            int particlesPerSpawn = Math.max(1, this.count / (int)Math.max(1L, this.durationTicks));
            this.level.m_8767_((ParticleOptions)this.particleOption, this.x, this.y, this.z, particlesPerSpawn, this.dx, this.dy, this.dz, this.speed);
        }
    }

    public static class ClientSetup {
        private static boolean hasPreWarmed = false;

        @SubscribeEvent
        public static void registerParticleFactories(RegisterParticleProvidersEvent event) {
            event.registerSpriteSet((ParticleType)ModParticles.CUSTOM_GLOW.get(), CustomGlowParticleProvider::new);
            event.registerSpriteSet((ParticleType)ModParticles.PLASMA.get(), PlasmaParticle.Provider::new);
            event.registerSpriteSet((ParticleType)ModParticles.CUSTOM_SMOKE.get(), SmokeParticle.Provider::new);
            event.registerSpriteSet((ParticleType)ModParticles.LINE_SPARK.get(), LineSparkParticleProvider::new);
            LOGGER.info("Registered custom particle providers.");
        }

        @SubscribeEvent
        public static void onClientTick(TickEvent.ClientTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                ClientEffects.onClientTick();
                if (!hasPreWarmed && Minecraft.m_91087_().f_91073_ != null && Minecraft.m_91087_().f_91074_ != null) {
                    LOGGER.info("Pre-warming explosion particle render pipeline...");
                    ClientLevel level = Minecraft.m_91087_().f_91073_;
                    double x = Minecraft.m_91087_().f_91074_.m_20185_();
                    double y = -200.0;
                    double z = Minecraft.m_91087_().f_91074_.m_20189_();
                    level.m_7106_((ParticleOptions)new PlasmaParticleOptions(1.0f), x, y, z, 0.0, 0.0, 0.0);
                    LOGGER.info("Pre-warming 'glow' animation...");
                    level.m_7106_((ParticleOptions)new CustomGlowParticleOptions(0, 1.0f, 0.01f, 0), x, y, z, 0.0, 0.0, 0.0);
                    LOGGER.info("Pre-warming 'glow_2' animation...");
                    level.m_7106_((ParticleOptions)new CustomGlowParticleOptions(0, 1.0f, 0.01f, 1), x, y, z, 0.0, 0.0, 0.0);
                    LOGGER.info("Pre-warming 'sglow' animation...");
                    level.m_7106_((ParticleOptions)new CustomGlowParticleOptions(0, 1.0f, 0.01f, 2), x, y, z, 0.0, 0.0, 0.0);
                    hasPreWarmed = true;
                    LOGGER.info("Explosion particle pipeline pre-warmed successfully.");
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerLogout(ClientPlayerNetworkEvent.LoggingOut event) {
            LOGGER.info("Player logged out, resetting particle pre-warmer.");
            hasPreWarmed = false;
        }

        @SubscribeEvent
        public static void onRenderGuiOverlay(RenderGuiOverlayEvent.Post event) {
            if (event.getOverlay().id().m_135815_().equals("crosshair")) {
                ClientEffects.renderFlash(event);
            }
        }

        public static class TexturePreloader
        implements PreparableReloadListener {
            public CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier pPreparationBarrier, ResourceManager pResourceManager, ProfilerFiller pPreparationsProfiler, ProfilerFiller pReloadProfiler, Executor pBackgroundExecutor, Executor pGameExecutor) {
                CompletableFuture<List> prepareFuture = CompletableFuture.supplyAsync(() -> {
                    LOGGER.info("Scanning for all mod textures to preload...");
                    return pResourceManager.m_214159_("textures", path -> path.m_135827_().equals(ExplosionOverhaul.MODID) && path.m_135815_().endsWith(".png")).keySet().stream().toList();
                }, pBackgroundExecutor);
                return prepareFuture.thenCompose(locationsToLoad -> pPreparationBarrier.m_6769_(locationsToLoad).thenRunAsync(() -> {
                    if (locationsToLoad.isEmpty()) {
                        LOGGER.warn("Did not find any textures to preload for mod '{}'.", (Object)ExplosionOverhaul.MODID);
                        return;
                    }
                    LOGGER.info("Preloading {} textures from '{}' to GPU...", (Object)locationsToLoad.size(), (Object)ExplosionOverhaul.MODID);
                    TextureManager textureManager = Minecraft.m_91087_().m_91097_();
                    for (ResourceLocation location : locationsToLoad) {
                        textureManager.m_118506_(location);
                    }
                    LOGGER.info("Finished preloading all textures for the mod.");
                }, pGameExecutor));
            }
        }
    }

    public static class CaveEffects {
        private static final int PLAYER_EFFECT_RADIUS = 10;

        public static void spawnFallingBlocksAndDust(ServerLevel level, Vec3 explosionPos, ServerPlayer player, float power, long initialDelayTicks) {
            RandomSource random = level.m_213780_();
            long maxEffectOverallDurationTicks = (2 + random.m_188503_(5)) * 20;
            int totalEffectSpawns = 15 + (int)(power / 5.0f * 3.0f);
            totalEffectSpawns = Math.min(totalEffectSpawns, 60);
            for (int i = 0; i < totalEffectSpawns; ++i) {
                long individualDelay = initialDelayTicks + (long)random.m_188503_((int)maxEffectOverallDurationTicks / 2);
                long randomDurationTicks = 10 + random.m_188503_(40);
                CaveEffects.spawnEffectAtPlayer(level, player, individualDelay, random, power, randomDurationTicks);
            }
        }

        private static void spawnEffectAtPlayer(ServerLevel level, ServerPlayer player, long delayTicks, RandomSource random, float power, long durationTicks) {
            int xOffset = random.m_188503_(21) - 10;
            int zOffset = random.m_188503_(21) - 10;
            int ySearchStart = (int)player.m_20186_() + 3 + random.m_188503_(4);
            BlockPos playerBlockPos = player.m_20183_();
            BlockPos checkPosBase = new BlockPos(playerBlockPos.m_123341_() + xOffset, ySearchStart, playerBlockPos.m_123343_() + zOffset);
            BlockPos effectPos = null;
            for (int i = 0; i < 8; ++i) {
                BlockState aboveState;
                BlockState currentState;
                BlockPos currentCheck = checkPosBase.m_6625_(i);
                if (!level.m_46749_(currentCheck) || (double)currentCheck.m_123342_() <= player.m_20186_() - 1.0 || !(currentState = level.m_8055_(currentCheck)).m_280296_() || currentState.m_60795_() || !(aboveState = level.m_8055_(currentCheck.m_7494_())).m_60795_() && !level.m_8055_(currentCheck.m_7495_()).m_60795_()) continue;
                effectPos = currentCheck;
                break;
            }
            if (effectPos != null && effectPos.m_123342_() > level.m_141937_()) {
                boolean isSpecialBlock;
                BlockState blockState = level.m_8055_(effectPos);
                if (blockState.m_60795_()) {
                    return;
                }
                ResourceLocation registryName = ForgeRegistries.BLOCKS.getKey((Object)blockState.m_60734_());
                String name = registryName != null ? registryName.m_135815_() : "";
                boolean bl = isSpecialBlock = name.contains("bedrock") || name.contains("end_portal") || name.contains("end_portal_frame") || name.contains("command_block") || name.contains("barrier");
                if (isSpecialBlock) {
                    return;
                }
                int particleCount = 8 + (int)((double)(power / 10.0f) * 1.5);
                particleCount = Math.min(particleCount, 25);
                ExplosionOverhaul.addDelayedParticle(level, new BlockParticleOption(ParticleTypes.f_123814_, blockState), (double)effectPos.m_123341_() + 0.5, (double)effectPos.m_123342_() + 0.2, (double)effectPos.m_123343_() + 0.5, particleCount, 0.3, 0.3, 0.3, 0.02, delayTicks, durationTicks);
                if (random.m_188500_() < 0.3 + (double)power * 0.02) {
                    ExplosionOverhaul.addDelayedSound(player, (SoundEvent)ModSounds.DUST_SOUND.get(), SoundSource.BLOCKS, (float)effectPos.m_123341_() + 0.5f, (float)effectPos.m_123342_() + 0.5f, (float)effectPos.m_123343_() + 0.5f, 0.6f + random.m_188501_() * 0.4f, 0.85f + random.m_188501_() * 0.3f, player.m_217043_().m_188505_(), delayTicks + (long)random.m_188503_(10));
                }
                if (random.m_188500_() < 0.03 + (double)power * 0.005 && power > 10.0f) {
                    ExplosionOverhaul.addDelayedSound(player, (SoundEvent)ModSounds.FALLING_STONES_SOUND.get(), SoundSource.BLOCKS, (float)effectPos.m_123341_() + 0.5f, (float)effectPos.m_123342_() + 0.5f, (float)effectPos.m_123343_() + 0.5f, 0.8f + random.m_188501_() * 0.2f, 0.9f + random.m_188501_() * 0.2f, player.m_217043_().m_188505_(), delayTicks + (long)random.m_188503_(20));
                }
            }
        }
    }
}

