/*
 * Decompiled with CFR 0.152.
 */
package com.vinlanx.explosionoverhaul;

import com.vinlanx.explosionoverhaul.client.ClientEffects;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public class ExplosionVisualsPacket {
    private final Vec3 position;
    private final float power;

    public ExplosionVisualsPacket(Vec3 position, float power) {
        this.position = position;
        this.power = power;
    }

    public static void encode(ExplosionVisualsPacket msg, FriendlyByteBuf buf) {
        buf.writeDouble(msg.position.f_82479_);
        buf.writeDouble(msg.position.f_82480_);
        buf.writeDouble(msg.position.f_82481_);
        buf.writeFloat(msg.power);
    }

    public static ExplosionVisualsPacket decode(FriendlyByteBuf buf) {
        return new ExplosionVisualsPacket(new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble()), buf.readFloat());
    }

    public static void handle(ExplosionVisualsPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ClientEffects.triggerRealisticExplosion(msg.position, msg.power));
        ctx.get().setPacketHandled(true);
    }

    public Vec3 getPosition() {
        return this.position;
    }

    public float getPower() {
        return this.power;
    }
}

