/*
 * Decompiled with CFR 0.152.
 */
package com.vinlanx.explosionoverhaul;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.vinlanx.explosionoverhaul.ModParticles;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;

public class PlasmaParticleOptions
implements ParticleOptions {
    public static final Codec<PlasmaParticleOptions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("power").forGetter(PlasmaParticleOptions::getPower)).apply((Applicative)instance, PlasmaParticleOptions::new));
    public static final ParticleOptions.Deserializer<PlasmaParticleOptions> DESERIALIZER = new ParticleOptions.Deserializer<PlasmaParticleOptions>(){

        public PlasmaParticleOptions fromCommand(ParticleType<PlasmaParticleOptions> particleType, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float power = reader.readFloat();
            return new PlasmaParticleOptions(power);
        }

        public PlasmaParticleOptions fromNetwork(ParticleType<PlasmaParticleOptions> particleType, FriendlyByteBuf buffer) {
            return new PlasmaParticleOptions(buffer.readFloat());
        }
    };
    private final float power;

    public PlasmaParticleOptions(float power) {
        this.power = power;
    }

    public ParticleType<?> m_6012_() {
        return (ParticleType)ModParticles.PLASMA.get();
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.power);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %.2f", ModParticles.PLASMA.getId(), Float.valueOf(this.power));
    }

    public float getPower() {
        return this.power;
    }
}

