/*
 * Decompiled with CFR 0.152.
 */
package com.vinlanx.explosionoverhaul;

import com.vinlanx.explosionoverhaul.client.ClientEffects;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class PlayTrackedSoundPacket {
    private final Vec3 explosionPos;
    private final ResourceLocation soundId;
    private final float volume;
    private final float pitch;
    private final long delayTicks;
    private final boolean isPlayerInHouse;

    public PlayTrackedSoundPacket(Vec3 explosionPos, ResourceLocation soundId, float volume, float pitch, long delayTicks, boolean isPlayerInHouse) {
        this.explosionPos = explosionPos;
        this.soundId = soundId;
        this.volume = volume;
        this.pitch = pitch;
        this.delayTicks = delayTicks;
        this.isPlayerInHouse = isPlayerInHouse;
    }

    public static void encode(PlayTrackedSoundPacket msg, FriendlyByteBuf buf) {
        buf.writeDouble(msg.explosionPos.f_82479_);
        buf.writeDouble(msg.explosionPos.f_82480_);
        buf.writeDouble(msg.explosionPos.f_82481_);
        buf.m_130085_(msg.soundId);
        buf.writeFloat(msg.volume);
        buf.writeFloat(msg.pitch);
        buf.m_130103_(msg.delayTicks);
        buf.writeBoolean(msg.isPlayerInHouse);
    }

    public static PlayTrackedSoundPacket decode(FriendlyByteBuf buf) {
        return new PlayTrackedSoundPacket(new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble()), buf.m_130281_(), buf.readFloat(), buf.readFloat(), buf.m_130258_(), buf.readBoolean());
    }

    public static void handle(PlayTrackedSoundPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientEffects.addTrackedSound(msg)));
        ctx.get().setPacketHandled(true);
    }

    public Vec3 getExplosionPos() {
        return this.explosionPos;
    }

    public ResourceLocation getSoundId() {
        return this.soundId;
    }

    public float getVolume() {
        return this.volume;
    }

    public float getPitch() {
        return this.pitch;
    }

    public long getDelayTicks() {
        return this.delayTicks;
    }

    public boolean isPlayerInHouse() {
        return this.isPlayerInHouse;
    }
}

