/*
 * Decompiled with CFR 0.152.
 */
package com.vinlanx.explosionoverhaul;

import com.vinlanx.explosionoverhaul.BlockIndexManager;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ScanControlPacket {
    private final boolean startScan;

    public ScanControlPacket(boolean startScan) {
        this.startScan = startScan;
    }

    public static void encode(ScanControlPacket msg, FriendlyByteBuf buf) {
        buf.writeBoolean(msg.startScan);
    }

    public static ScanControlPacket decode(FriendlyByteBuf buf) {
        return new ScanControlPacket(buf.readBoolean());
    }

    public static void handle(ScanControlPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (msg.startScan) {
                BlockIndexManager.startManualScan();
            } else {
                BlockIndexManager.cancelManualScan();
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

