/*
 * Decompiled with CFR 0.152.
 */
package com.vinlanx.explosionoverhaul;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ScanInfoHUD {
    private static boolean isVisible = false;

    public static boolean isVisible() {
        return isVisible;
    }

    public static void setVisible(boolean visible) {
        isVisible = visible;
    }

    @SubscribeEvent
    public static void onRenderGuiOverlay(RenderGuiOverlayEvent.Post event) {
        if (!isVisible) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        GuiGraphics guiGraphics = event.getGuiGraphics();
        String[] infoLines = new String[]{"\u00a76\u00a7lChunk Scanning Information", "", "\u00a7eWhat is chunk scanning?", "\u00a77Chunk scanning analyzes your world to find", "\u00a77and index specific blocks for explosion effects:", "", "\u00a7a\u2022 \u00a77Redstone Lamps \u00a77- for lamp flickering effects", "\u00a7a\u2022 \u00a77Pointed Dripstone \u00a77- for dripstone collapse in caves", "\u00a7a\u2022 \u00a77Glass Blocks \u00a77- for realistic glass breaking", "", "\u00a7eWhy scan chunks?", "\u00a77This allows the mod to create more realistic", "\u00a77explosion effects by knowing where these", "\u00a77blocks are located in your world.", "", "\u00a7ePerformance:", "\u00a77Scanning happens in background and won't", "\u00a77affect your gameplay. You can adjust speed", "\u00a77in mod settings if needed.", "", "\u00a7cPress [3] again to close this info"};
        int maxWidth = 0;
        for (String line : infoLines) {
            int lineWidth = mc.f_91062_.m_92895_(line);
            if (lineWidth <= maxWidth) continue;
            maxWidth = lineWidth;
        }
        int windowWidth = maxWidth + 20;
        int windowHeight = infoLines.length * 12 + 20;
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        int x = (screenWidth - windowWidth) / 2;
        int y = (screenHeight - windowHeight) / 2;
        guiGraphics.m_280509_(x - 5, y - 5, x + windowWidth, y + windowHeight, -536870912);
        guiGraphics.m_280509_(x - 6, y - 6, x + windowWidth + 1, y - 5, -12303292);
        guiGraphics.m_280509_(x - 6, y + windowHeight, x + windowWidth + 1, y + windowHeight + 1, -12303292);
        guiGraphics.m_280509_(x - 6, y - 5, x - 5, y + windowHeight, -12303292);
        guiGraphics.m_280509_(x + windowWidth, y - 5, x + windowWidth + 1, y + windowHeight, -12303292);
        for (int i = 0; i < infoLines.length; ++i) {
            String line = infoLines[i];
            if (line.isEmpty()) continue;
            guiGraphics.m_280488_(mc.f_91062_, line, x + 10, y + 10 + i * 12, 0xFFFFFF);
        }
    }
}

