/*
 * Decompiled with CFR 0.152.
 */
package com.vinlanx.explosionoverhaul;

import com.vinlanx.explosionoverhaul.BlockIndexManager;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ScanLoadControlPacket {
    private final boolean loadExisting;

    public ScanLoadControlPacket(boolean loadExisting) {
        this.loadExisting = loadExisting;
    }

    public static void encode(ScanLoadControlPacket msg, FriendlyByteBuf buf) {
        buf.writeBoolean(msg.loadExisting);
    }

    public static ScanLoadControlPacket decode(FriendlyByteBuf buf) {
        return new ScanLoadControlPacket(buf.readBoolean());
    }

    public static void handle(ScanLoadControlPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (msg.loadExisting) {
                BlockIndexManager.loadExistingData();
            } else {
                BlockIndexManager.startNewScan();
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

