/*
 * Decompiled with CFR 0.152.
 */
package com.vinlanx.explosionoverhaul;

import com.vinlanx.explosionoverhaul.Config;
import com.vinlanx.explosionoverhaul.ScanInfoHUD;
import com.vinlanx.explosionoverhaul.ScanLoadInfoHUD;
import com.vinlanx.explosionoverhaul.ScanLoadPromptHUD;
import com.vinlanx.explosionoverhaul.ScanPromptHUD;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ScanProgressHUD {
    private static int totalChunks = 0;
    private static int scannedChunks = 0;
    private static boolean isComplete = false;
    private static boolean isVisible = false;
    private static long hideTime = 0L;
    private static final long HIDE_DELAY = 4000L;
    private static int lampsFound = 0;
    private static int dripstonesFound = 0;
    private static int glassBlocksFound = 0;
    private static long startTime = 0L;
    private static double chunksPerSecond = 0.0;

    public static void updateProgress(int total, int scanned, boolean complete) {
        ScanProgressHUD.updateProgress(total, scanned, complete, 0, 0, 0);
    }

    public static void updateProgress(int total, int scanned, boolean complete, int lamps, int dripstones, int glass) {
        long currentTime;
        long elapsedTime;
        if (!((Boolean)Config.COMMON.scan.enableBlockIndexing.get()).booleanValue()) {
            ScanProgressHUD.reset();
            return;
        }
        totalChunks = total;
        scannedChunks = scanned;
        boolean wasComplete = isComplete;
        isComplete = complete;
        lampsFound = lamps;
        dripstonesFound = dripstones;
        glassBlocksFound = glass;
        if (scannedChunks == 0 && totalChunks > 0 && !isComplete) {
            startTime = System.currentTimeMillis();
            chunksPerSecond = 0.0;
        }
        if (scannedChunks > 0 && !isComplete && startTime > 0L && (elapsedTime = (currentTime = System.currentTimeMillis()) - startTime) > 1000L) {
            chunksPerSecond = (double)scannedChunks / ((double)elapsedTime / 1000.0);
        }
        if (total > 0) {
            if (complete && !wasComplete) {
                hideTime = System.currentTimeMillis() + 4000L;
                isVisible = true;
            } else if (!complete) {
                isVisible = true;
                hideTime = 0L;
            }
        } else if (total == 0) {
            ScanProgressHUD.reset();
        }
    }

    public static void reset() {
        totalChunks = 0;
        scannedChunks = 0;
        isComplete = false;
        isVisible = false;
        hideTime = 0L;
        lampsFound = 0;
        dripstonesFound = 0;
        glassBlocksFound = 0;
        startTime = 0L;
        chunksPerSecond = 0.0;
    }

    private static String getEstimatedTimeRemaining() {
        if (isComplete) {
            return "Complete!";
        }
        if (totalChunks <= 0 || scannedChunks <= 0 || chunksPerSecond <= 0.1) {
            return "Calculating...";
        }
        int remainingChunks = totalChunks - scannedChunks;
        double secondsRemaining = (double)remainingChunks / chunksPerSecond;
        if (secondsRemaining < 0.0) {
            return "Calculating...";
        }
        int minutes = (int)(secondsRemaining / 60.0);
        int seconds = (int)(secondsRemaining % 60.0);
        return String.format("ETA: %02d:%02d", minutes, seconds);
    }

    @SubscribeEvent
    public static void onRenderGuiOverlay(RenderGuiOverlayEvent.Post event) {
        if (!((Boolean)Config.COMMON.scan.enableBlockIndexing.get()).booleanValue()) {
            return;
        }
        if (!((Boolean)Config.COMMON.scan.showScanProgressHUD.get()).booleanValue()) {
            return;
        }
        if (!isVisible) {
            return;
        }
        if (totalChunks <= 0) {
            return;
        }
        if (ScanPromptHUD.isVisible() || ScanInfoHUD.isVisible() || ScanLoadPromptHUD.isVisible() || ScanLoadInfoHUD.isVisible()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        if (!mc.f_91074_.m_20310_(2)) {
            return;
        }
        if (isComplete && System.currentTimeMillis() > hideTime) {
            isVisible = false;
            return;
        }
        GuiGraphics guiGraphics = event.getGuiGraphics();
        Font font = mc.f_91062_;
        float progress = totalChunks > 0 ? (float)scannedChunks / (float)totalChunks : 0.0f;
        int percentage = isComplete ? 100 : Math.round(progress * 100.0f);
        String statusText = isComplete ? "Scan Complete! (100%)" : String.format("Scanning Chunks: %d%%", percentage);
        String detailText = String.format("%d / %d chunks", scannedChunks, totalChunks);
        String blockCountText = String.format("Lamps: %d; Dripstones: %d; Glass: %d", lampsFound, dripstonesFound, glassBlocksFound);
        String timeText = ScanProgressHUD.getEstimatedTimeRemaining();
        int x = 10;
        int y = 10;
        int textColor = isComplete ? 65280 : 0xFFFFFF;
        boolean shadowColor = false;
        int maxWidth = Math.max(Math.max(Math.max(font.m_92895_(statusText), font.m_92895_(detailText)), font.m_92895_(blockCountText)), font.m_92895_(timeText));
        int bgWidth = Math.max(maxWidth, 100) + 10;
        int bgHeight = 64;
        guiGraphics.m_280509_(x - 5, y - 2, x + bgWidth, y + bgHeight, Integer.MIN_VALUE);
        guiGraphics.m_280488_(font, statusText, x, y, textColor);
        guiGraphics.m_280488_(font, detailText, x, y + 12, 0xAAAAAA);
        guiGraphics.m_280488_(font, blockCountText, x, y + 24, 0xCCCCCC);
        int timeTextColor = isComplete ? 65280 : 0xFFFF00;
        guiGraphics.m_280488_(font, timeText, x, y + 36, timeTextColor);
        int barWidth = 100;
        int barHeight = 4;
        int barX = x;
        int barY = y + 52;
        guiGraphics.m_280509_(barX, barY, barX + barWidth, barY + barHeight, -13421773);
        int progressWidth = isComplete ? barWidth : (int)((float)barWidth * progress);
        int barColor = isComplete ? -16711936 : -16733696;
        guiGraphics.m_280509_(barX, barY, barX + progressWidth, barY + barHeight, barColor);
    }
}

