/*
 * Decompiled with CFR 0.152.
 */
package com.vinlanx.explosionoverhaul;

import com.vinlanx.explosionoverhaul.ScanProgressHUD;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ScanProgressPacket {
    private final int totalChunks;
    private final int scannedChunks;
    private final boolean isComplete;
    private final int lampsFound;
    private final int dripstonesFound;
    private final int glassBlocksFound;

    public ScanProgressPacket(int totalChunks, int scannedChunks, boolean isComplete, int lampsFound, int dripstonesFound, int glassBlocksFound) {
        this.totalChunks = totalChunks;
        this.scannedChunks = scannedChunks;
        this.isComplete = isComplete;
        this.lampsFound = lampsFound;
        this.dripstonesFound = dripstonesFound;
        this.glassBlocksFound = glassBlocksFound;
    }

    public ScanProgressPacket(FriendlyByteBuf buffer) {
        this.totalChunks = buffer.readInt();
        this.scannedChunks = buffer.readInt();
        this.isComplete = buffer.readBoolean();
        this.lampsFound = buffer.readInt();
        this.dripstonesFound = buffer.readInt();
        this.glassBlocksFound = buffer.readInt();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.totalChunks);
        buffer.writeInt(this.scannedChunks);
        buffer.writeBoolean(this.isComplete);
        buffer.writeInt(this.lampsFound);
        buffer.writeInt(this.dripstonesFound);
        buffer.writeInt(this.glassBlocksFound);
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> ScanProgressHUD.updateProgress(this.totalChunks, this.scannedChunks, this.isComplete, this.lampsFound, this.dripstonesFound, this.glassBlocksFound));
        context.setPacketHandled(true);
    }

    public int getTotalChunks() {
        return this.totalChunks;
    }

    public int getScannedChunks() {
        return this.scannedChunks;
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public int getLampsFound() {
        return this.lampsFound;
    }

    public int getDripstonesFound() {
        return this.dripstonesFound;
    }

    public int getGlassBlocksFound() {
        return this.glassBlocksFound;
    }
}

