/*
 * Decompiled with CFR 0.152.
 */
package com.vinlanx.explosionoverhaul;

import com.vinlanx.explosionoverhaul.CameraShakePacket;
import com.vinlanx.explosionoverhaul.Config;
import com.vinlanx.explosionoverhaul.CraterDeformer;
import com.vinlanx.explosionoverhaul.DripstoneEffects;
import com.vinlanx.explosionoverhaul.ExplosionClusterHandler;
import com.vinlanx.explosionoverhaul.ExplosionOverhaul;
import com.vinlanx.explosionoverhaul.ExplosionVisualsPacket;
import com.vinlanx.explosionoverhaul.FlashEffectPacket;
import com.vinlanx.explosionoverhaul.GlassBreakingEffects;
import com.vinlanx.explosionoverhaul.ModSounds;
import com.vinlanx.explosionoverhaul.PacketHandler;
import com.vinlanx.explosionoverhaul.PlayTrackedSoundPacket;
import com.vinlanx.explosionoverhaul.RedstoneLampEffects;
import com.vinlanx.explosionoverhaul.SpawnDustCloudPacket;
import com.vinlanx.explosionoverhaul.SpawnLineSparksPacket;
import com.vinlanx.explosionoverhaul.SpawnMistCloudPacket;
import com.vinlanx.explosionoverhaul.SpawnShockwavePacket;
import com.vinlanx.explosionoverhaul.api.IExplosionPower;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

public class ServerExplosionHandler {
    private final Random random = new Random();
    private static final Set<String> EXPLOSION_BLACKLIST = Set.of("ancient_elements:block_of_raw_infernal_ore", "minecraft:dirt", "ancient_elements:celestium_ore", "ancient_elements:deepslate_frost_ore", "ancient_elements:deepslate_jungle_steel_ore", "ancient_elements:deepslate_lead_ore", "ancient_elements:deepslate_steel_ore", "ancient_elements:deepslate_tin_ore", "ancient_elements:deepslate_titanium_ore", "ancient_elements:ender_steel_ore", "ancient_elements:endrium_ore", "ancient_elements:frost_ore", "ancient_elements:infernal_ore", "ancient_elements:jungle_steel_ore", "ancient_elements:lead_ore", "ancient_elements:meteorite_ore", "ancient_elements:nether_steel_ore", "ancient_elements:palladium_ore", "ancient_elements:spectrillium_ore", "ancient_elements:steel_ore", "ancient_elements:tin_ore", "ancient_elements:titanium_ore", "ancient_elements:void_steel_ore");

    @SubscribeEvent
    public void onExplosion(ExplosionEvent.Detonate event) {
        float power;
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        Vec3 explosionPos = event.getExplosion().getPosition();
        Explosion explosion = event.getExplosion();
        if (explosion instanceof IExplosionPower) {
            IExplosionPower powerHolder = (IExplosionPower)explosion;
            power = powerHolder.getPower();
            power = ExplosionClusterHandler.calculateClusteredPower((Level)level2, explosionPos, power);
            if (!event.getLevel().m_5776_()) {
                // empty if block
            }
        } else {
            System.err.println("[explosionoverhaul] \u0423\u0412\u0410\u0413\u0410: Explosion \u043d\u0435 IExplosionPower \u2014 Mixin \u043d\u0435 \u0441\u043f\u0440\u0430\u0446\u044e\u0432\u0430\u0432. \u041e\u0431\u0440\u043e\u0431\u043a\u0443 \u0432\u0438\u0431\u0443\u0445\u0443 \u0441\u043a\u0430\u0441\u043e\u0432\u0430\u043d\u043e.");
            return;
        }
        if (((Boolean)Config.COMMON.enableCraterDestruction.get()).booleanValue()) {
            HashSet originalAffectedBlocks = new HashSet(event.getAffectedBlocks());
            event.getAffectedBlocks().clear();
            Iterator iterator = originalAffectedBlocks.iterator();
            while (iterator.hasNext()) {
                BlockPos pos = (BlockPos)iterator.next();
                BlockState state = level2.m_8055_(pos);
                Block block = state.m_60734_();
                if (ExplosionOverhaul.isBlockBlacklisted(block)) continue;
                event.getAffectedBlocks().add(pos);
            }
            Set<BlockPos> craterBlocks = CraterDeformer.getCraterBlocks(level2, explosionPos, power);
            for (BlockPos pos : craterBlocks) {
                if (event.getAffectedBlocks().contains(pos)) continue;
                BlockState state = level2.m_8055_(pos);
                Block block = state.m_60734_();
                if (state.m_60795_() || !(state.m_60800_((BlockGetter)level2, pos) >= 0.0f) || block.m_204297_().m_203656_(BlockTags.f_13070_) || block == Blocks.f_50722_ || ExplosionOverhaul.isBlockBlacklisted(block)) continue;
                event.getAffectedBlocks().add(pos);
            }
        } else {
            event.getAffectedBlocks().clear();
        }
        if (((Boolean)Config.COMMON.enableGlassBreaking.get()).booleanValue()) {
            GlassBreakingEffects.trigger(level2, explosionPos, power);
        }
        for (ServerPlayer player : level2.m_6907_()) {
            if (player.f_8906_ == null) continue;
            double distance = player.m_20182_().m_82554_(explosionPos);
            BlockPos playerBlockPos = player.m_20183_();
            boolean playerInCave = ServerExplosionHandler.isInNaturalCave(level2, playerBlockPos);
            boolean playerInHouse = ServerExplosionHandler.isInHouse(level2, playerBlockPos, player.m_146892_().f_82480_);
            boolean explosionIsInCaveLocation = ServerExplosionHandler.isInNaturalCave(level2, BlockPos.m_274446_((Position)explosionPos));
            boolean hasDirectLineOfSight = false;
            if (distance > 0.1 && distance <= 200.0) {
                Vec3 playerEyePos = player.m_146892_();
                hasDirectLineOfSight = ServerExplosionHandler.hasLineOfSight(level2, playerEyePos, explosionPos, (Entity)player);
            }
            int dripstoneThreshold = 0;
            if (distance >= 500.0 && distance < 1000.0) {
                dripstoneThreshold = 10;
            } else if (distance >= 1000.0 && distance < 5000.0) {
                dripstoneThreshold = 25;
            } else if (distance >= 5000.0) {
                dripstoneThreshold = 50;
            }
            if (dripstoneThreshold > 0 && power >= (float)dripstoneThreshold) {
                DripstoneEffects.handleDripstoneFall(level2, playerBlockPos, (int)Math.ceil(power), player.m_217043_());
            }
            List<SoundEvent> soundPool = null;
            int closeSoundDistanceThreshold = level2.m_46472_() == Level.f_46429_ ? 100 : (level2.m_46472_() == Level.f_46430_ ? 150 : 50);
            if (distance <= (double)closeSoundDistanceThreshold) {
                soundPool = power <= 3.0f ? List.of((SoundEvent)ModSounds.EXPLODE_CLOSE_POWER_1_1.get(), (SoundEvent)ModSounds.EXPLODE_CLOSE_POWER_1_2.get(), (SoundEvent)ModSounds.EXPLODE_CLOSE_POWER_1_3.get()) : (power <= 6.0f ? List.of((SoundEvent)ModSounds.EXPLODE_CLOSE_POWER_2_1.get(), (SoundEvent)ModSounds.EXPLODE_CLOSE_POWER_2_2.get(), (SoundEvent)ModSounds.EXPLODE_CLOSE_POWER_2_3.get()) : (power <= 14.0f ? List.of((SoundEvent)ModSounds.EXPLODE_CLOSE_POWER_3_1.get(), (SoundEvent)ModSounds.EXPLODE_CLOSE_POWER_3_2.get(), (SoundEvent)ModSounds.EXPLODE_CLOSE_POWER_3_3.get()) : (power <= 30.0f ? List.of((SoundEvent)ModSounds.EXPLODE_CLOSE_POWER_4_1.get(), (SoundEvent)ModSounds.EXPLODE_CLOSE_POWER_4_2.get(), (SoundEvent)ModSounds.EXPLODE_CLOSE_POWER_4_3.get()) : (power <= 60.0f ? List.of((SoundEvent)ModSounds.EXPLODE_CLOSE_POWER_5_1.get(), (SoundEvent)ModSounds.EXPLODE_CLOSE_POWER_5_2.get(), (SoundEvent)ModSounds.EXPLODE_CLOSE_POWER_5_3.get()) : (power <= 99.0f ? List.of((SoundEvent)ModSounds.EXPLODE_CLOSE_POWER_6_1.get(), (SoundEvent)ModSounds.EXPLODE_CLOSE_POWER_6_2.get(), (SoundEvent)ModSounds.EXPLODE_CLOSE_POWER_6_3.get()) : List.of((SoundEvent)ModSounds.EXPLODE_CLOSE_POWER_7_1.get(), (SoundEvent)ModSounds.EXPLODE_CLOSE_POWER_7_2.get(), (SoundEvent)ModSounds.EXPLODE_CLOSE_POWER_7_3.get()))))));
            } else {
                if (hasDirectLineOfSight) {
                    if (playerInHouse) {
                        if (distance <= 500.0) {
                            soundPool = ServerExplosionHandler.getSoundPoolForPower(power, (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_1_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_1_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_1_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_2_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_2_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_2_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_3_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_3_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_3_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_4_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_4_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_4_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_5_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_5_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_5_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_6_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_6_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_6_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_7_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_7_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_7_3.get());
                        } else if (distance <= 1000.0) {
                            soundPool = ServerExplosionHandler.getSoundPoolForPower(power, (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_1_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_1_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_1_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_2_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_2_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_2_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_3_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_3_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_3_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_4_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_4_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_4_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_5_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_5_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_5_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_6_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_6_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_6_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_7_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_7_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_7_3.get());
                        } else if (distance <= 5000.0) {
                            soundPool = ServerExplosionHandler.getSoundPoolForPower(power, (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_1_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_1_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_1_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_2_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_2_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_2_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_3_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_3_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_3_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_4_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_4_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_4_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_5_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_5_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_5_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_6_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_6_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_6_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_7_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_7_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_7_3.get());
                        }
                    } else if (distance <= 500.0) {
                        soundPool = ServerExplosionHandler.getSoundPoolForPower(power, (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_1_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_1_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_1_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_2_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_2_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_2_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_3_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_3_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_3_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_4_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_4_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_4_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_5_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_5_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_5_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_6_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_6_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_6_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_7_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_7_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_7_3.get());
                    } else if (distance <= 1000.0) {
                        soundPool = ServerExplosionHandler.getSoundPoolForPower(power, (SoundEvent)ModSounds.EXPLODE_FAR_POWER_1_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_1_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_1_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_2_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_2_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_2_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_3_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_3_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_3_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_4_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_4_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_4_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_5_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_5_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_5_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_6_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_6_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_6_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_7_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_7_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_7_3.get());
                    } else if (distance <= 5000.0) {
                        soundPool = ServerExplosionHandler.getSoundPoolForPower(power, (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_1_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_1_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_1_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_2_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_2_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_2_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_3_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_3_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_3_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_4_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_4_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_4_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_5_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_5_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_5_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_6_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_6_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_6_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_7_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_7_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_7_3.get());
                    }
                } else if (distance <= 500.0) {
                    soundPool = playerInHouse && explosionIsInCaveLocation ? ServerExplosionHandler.getSoundPoolForPower(power, (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_TO_HOUSE_POWER_1_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_TO_HOUSE_POWER_1_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_TO_HOUSE_POWER_1_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_TO_HOUSE_POWER_2_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_TO_HOUSE_POWER_2_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_TO_HOUSE_POWER_2_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_TO_HOUSE_POWER_3_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_TO_HOUSE_POWER_3_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_TO_HOUSE_POWER_3_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_TO_HOUSE_POWER_4_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_TO_HOUSE_POWER_4_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_TO_HOUSE_POWER_4_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_TO_HOUSE_POWER_5_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_TO_HOUSE_POWER_5_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_TO_HOUSE_POWER_5_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_TO_HOUSE_POWER_6_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_TO_HOUSE_POWER_6_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_TO_HOUSE_POWER_6_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_TO_HOUSE_POWER_7_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_TO_HOUSE_POWER_7_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_TO_HOUSE_POWER_7_3.get()) : (playerInHouse ? ServerExplosionHandler.getSoundPoolForPower(power, (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_1_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_1_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_1_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_2_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_2_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_2_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_3_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_3_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_3_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_4_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_4_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_4_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_5_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_5_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_5_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_6_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_6_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_6_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_7_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_7_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_7_3.get()) : (explosionIsInCaveLocation && !playerInCave ? ServerExplosionHandler.getSoundPoolForPower(power, (SoundEvent)ModSounds.EXPLODE_MEDIUM_UNDERGROUND_POWER_1_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_UNDERGROUND_POWER_1_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_UNDERGROUND_POWER_1_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_UNDERGROUND_POWER_2_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_UNDERGROUND_POWER_2_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_UNDERGROUND_POWER_2_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_UNDERGROUND_POWER_3_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_UNDERGROUND_POWER_3_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_UNDERGROUND_POWER_3_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_UNDERGROUND_POWER_4_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_UNDERGROUND_POWER_4_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_UNDERGROUND_POWER_4_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_UNDERGROUND_POWER_5_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_UNDERGROUND_POWER_5_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_UNDERGROUND_POWER_5_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_UNDERGROUND_POWER_6_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_UNDERGROUND_POWER_6_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_UNDERGROUND_POWER_6_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_UNDERGROUND_POWER_7_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_UNDERGROUND_POWER_7_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_UNDERGROUND_POWER_7_3.get()) : (playerInCave ? ServerExplosionHandler.getSoundPoolForPower(power, (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_POWER_1_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_POWER_1_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_POWER_1_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_POWER_2_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_POWER_2_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_POWER_2_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_POWER_3_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_POWER_3_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_POWER_3_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_POWER_4_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_POWER_4_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_POWER_4_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_POWER_5_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_POWER_5_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_POWER_5_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_POWER_6_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_POWER_6_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_POWER_6_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_POWER_7_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_POWER_7_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_POWER_7_3.get()) : ServerExplosionHandler.getSoundPoolForPower(power, (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_1_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_1_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_1_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_2_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_2_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_2_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_3_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_3_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_3_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_4_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_4_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_4_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_5_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_5_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_5_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_6_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_6_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_6_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_7_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_7_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_7_3.get()))));
                } else if (distance <= 1000.0) {
                    soundPool = playerInHouse && explosionIsInCaveLocation ? ServerExplosionHandler.getSoundPoolForPower(power, (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_TO_HOUSE_POWER_1_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_TO_HOUSE_POWER_1_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_TO_HOUSE_POWER_1_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_TO_HOUSE_POWER_2_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_TO_HOUSE_POWER_2_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_TO_HOUSE_POWER_2_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_TO_HOUSE_POWER_3_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_TO_HOUSE_POWER_3_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_TO_HOUSE_POWER_3_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_TO_HOUSE_POWER_4_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_TO_HOUSE_POWER_4_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_TO_HOUSE_POWER_4_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_TO_HOUSE_POWER_5_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_TO_HOUSE_POWER_5_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_TO_HOUSE_POWER_5_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_TO_HOUSE_POWER_6_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_TO_HOUSE_POWER_6_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_TO_HOUSE_POWER_6_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_TO_HOUSE_POWER_7_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_TO_HOUSE_POWER_7_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_TO_HOUSE_POWER_7_3.get()) : (playerInHouse ? ServerExplosionHandler.getSoundPoolForPower(power, (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_1_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_1_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_1_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_2_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_2_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_2_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_3_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_3_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_3_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_4_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_4_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_4_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_5_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_5_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_5_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_6_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_6_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_6_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_7_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_7_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_7_3.get()) : (explosionIsInCaveLocation && !playerInCave ? ServerExplosionHandler.getSoundPoolForPower(power, (SoundEvent)ModSounds.EXPLODE_FAR_UNDERGROUND_POWER_1_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_UNDERGROUND_POWER_1_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_UNDERGROUND_POWER_1_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_UNDERGROUND_POWER_2_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_UNDERGROUND_POWER_2_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_UNDERGROUND_POWER_2_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_UNDERGROUND_POWER_3_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_UNDERGROUND_POWER_3_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_UNDERGROUND_POWER_3_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_UNDERGROUND_POWER_4_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_UNDERGROUND_POWER_4_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_UNDERGROUND_POWER_4_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_UNDERGROUND_POWER_5_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_UNDERGROUND_POWER_5_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_UNDERGROUND_POWER_5_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_UNDERGROUND_POWER_6_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_UNDERGROUND_POWER_6_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_UNDERGROUND_POWER_6_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_UNDERGROUND_POWER_7_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_UNDERGROUND_POWER_7_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_UNDERGROUND_POWER_7_3.get()) : (playerInCave ? ServerExplosionHandler.getSoundPoolForPower(power, (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_POWER_1_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_POWER_1_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_POWER_1_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_POWER_2_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_POWER_2_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_POWER_2_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_POWER_3_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_POWER_3_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_POWER_3_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_POWER_4_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_POWER_4_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_POWER_4_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_POWER_5_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_POWER_5_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_POWER_5_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_POWER_6_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_POWER_6_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_POWER_6_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_POWER_7_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_POWER_7_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_POWER_7_3.get()) : ServerExplosionHandler.getSoundPoolForPower(power, (SoundEvent)ModSounds.EXPLODE_FAR_POWER_1_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_1_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_1_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_2_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_2_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_2_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_3_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_3_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_3_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_4_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_4_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_4_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_5_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_5_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_5_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_6_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_6_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_6_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_7_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_7_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_7_3.get()))));
                } else if (distance <= 5000.0) {
                    soundPool = playerInHouse && explosionIsInCaveLocation ? ServerExplosionHandler.getSoundPoolForPower(power, (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_TO_HOUSE_POWER_1_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_TO_HOUSE_POWER_1_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_TO_HOUSE_POWER_1_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_TO_HOUSE_POWER_2_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_TO_HOUSE_POWER_2_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_TO_HOUSE_POWER_2_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_TO_HOUSE_POWER_3_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_TO_HOUSE_POWER_3_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_TO_HOUSE_POWER_3_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_TO_HOUSE_POWER_4_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_TO_HOUSE_POWER_4_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_TO_HOUSE_POWER_4_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_TO_HOUSE_POWER_5_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_TO_HOUSE_POWER_5_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_TO_HOUSE_POWER_5_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_TO_HOUSE_POWER_6_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_TO_HOUSE_POWER_6_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_TO_HOUSE_POWER_6_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_TO_HOUSE_POWER_7_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_TO_HOUSE_POWER_7_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_TO_HOUSE_POWER_7_3.get()) : (playerInHouse ? ServerExplosionHandler.getSoundPoolForPower(power, (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_1_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_1_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_1_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_2_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_2_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_2_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_3_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_3_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_3_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_4_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_4_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_4_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_5_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_5_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_5_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_6_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_6_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_6_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_7_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_7_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_7_3.get()) : (explosionIsInCaveLocation && !playerInCave ? ServerExplosionHandler.getSoundPoolForPower(power, (SoundEvent)ModSounds.EXPLODE_SUPERFAR_UNDERGROUND_POWER_1_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_UNDERGROUND_POWER_1_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_UNDERGROUND_POWER_1_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_UNDERGROUND_POWER_2_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_UNDERGROUND_POWER_2_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_UNDERGROUND_POWER_2_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_UNDERGROUND_POWER_3_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_UNDERGROUND_POWER_3_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_UNDERGROUND_POWER_3_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_UNDERGROUND_POWER_4_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_UNDERGROUND_POWER_4_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_UNDERGROUND_POWER_4_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_UNDERGROUND_POWER_5_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_UNDERGROUND_POWER_5_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_UNDERGROUND_POWER_5_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_UNDERGROUND_POWER_6_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_UNDERGROUND_POWER_6_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_UNDERGROUND_POWER_6_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_UNDERGROUND_POWER_7_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_UNDERGROUND_POWER_7_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_UNDERGROUND_POWER_7_3.get()) : (playerInCave ? ServerExplosionHandler.getSoundPoolForPower(power, (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_POWER_1_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_POWER_1_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_POWER_1_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_POWER_2_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_POWER_2_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_POWER_2_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_POWER_3_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_POWER_3_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_POWER_3_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_POWER_4_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_POWER_4_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_POWER_4_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_POWER_5_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_POWER_5_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_POWER_5_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_POWER_6_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_POWER_6_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_POWER_6_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_POWER_7_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_POWER_7_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_POWER_7_3.get()) : ServerExplosionHandler.getSoundPoolForPower(power, (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_1_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_1_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_1_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_2_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_2_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_2_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_3_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_3_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_3_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_4_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_4_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_4_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_5_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_5_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_5_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_6_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_6_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_6_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_7_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_7_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_7_3.get()))));
                }
                if (!(soundPool != null || distance > 5000.0 && distance <= 6000.0 && power > 60.0f || !(distance > 5000.0))) continue;
            }
            double speedOfSound = 17.15;
            long delayTicksEffect = (long)(distance / speedOfSound);
            if (soundPool != null && !soundPool.isEmpty()) {
                boolean useAmbientSound;
                SoundEvent sound = soundPool.get(this.random.nextInt(soundPool.size()));
                float pitch = 0.95f + this.random.nextFloat() * 0.1f;
                float volume = Math.min(power * 10.0f, 90.0f);
                boolean bl = useAmbientSound = !hasDirectLineOfSight && (playerInCave || explosionIsInCaveLocation);
                if (distance <= (double)closeSoundDistanceThreshold) {
                    ExplosionOverhaul.addDelayedSound(player, sound, SoundSource.BLOCKS, (float)explosionPos.f_82479_, (float)explosionPos.f_82480_, (float)explosionPos.f_82481_, volume, pitch, player.m_217043_().m_188505_(), delayTicksEffect);
                } else if (useAmbientSound) {
                    ExplosionOverhaul.addDelayedSound(player, sound, SoundSource.AMBIENT, (float)player.m_20185_(), (float)player.m_20186_(), (float)player.m_20189_(), volume, pitch, player.m_217043_().m_188505_(), delayTicksEffect);
                } else {
                    ResourceLocation soundId = ForgeRegistries.SOUND_EVENTS.getKey((Object)sound);
                    if (soundId != null) {
                        PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new PlayTrackedSoundPacket(explosionPos, soundId, volume, pitch, delayTicksEffect, playerInHouse));
                    }
                }
            }
            float fireballPowerFraction = Mth.m_14036_((float)power, (float)1.0f, (float)100.0f) / 100.0f;
            float fireballRadius = Mth.m_14179_((float)fireballPowerFraction, (float)3.0f, (float)40.0f);
            float normalizedPowerSqrt = Mth.m_184655_((float)((float)Math.sqrt(power)), (float)((float)Math.sqrt(5.0)), (float)((float)Math.sqrt(100.0)));
            float shockwaveMultiplier = Mth.m_14179_((float)normalizedPowerSqrt, (float)2.0f, (float)8.0f);
            float maxShockwaveRadius = fireballRadius * shockwaveMultiplier * 3.0f;
            if (distance <= (double)(maxShockwaveRadius *= 4.0f)) {
                float sendIntensity;
                CameraShakeProfile closeProfile = this.determineCameraShakeProfile(power, 0.0, playerInCave, closeSoundDistanceThreshold, level2);
                float baseIntensity = closeProfile.intensity;
                int durationTicks = closeProfile.durationTicks;
                float basePush = closeProfile.pushIntensity;
                if (distance <= 10.0) {
                    sendIntensity = baseIntensity;
                } else {
                    float t = 1.0f - Mth.m_14036_((float)((float)(distance / (double)maxShockwaveRadius)), (float)0.0f, (float)1.0f);
                    float atten = t * t;
                    sendIntensity = baseIntensity * atten;
                }
                if (sendIntensity > 0.01f && durationTicks > 0) {
                    int delayTicks = (int)Math.max(0L, Math.round(distance / speedOfSound));
                    PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new CameraShakePacket(sendIntensity, durationTicks, basePush, delayTicks));
                }
            }
            float lampFlickerPowerThreshold = distance > 1000.0 && distance <= 5000.0 ? 31.0f : (distance > 500.0 && distance <= 1000.0 ? 20.0f : (distance > (double)closeSoundDistanceThreshold && distance <= 500.0 ? 10.0f : (distance <= (double)closeSoundDistanceThreshold ? 4.0f : Float.MAX_VALUE)));
            PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ExplosionVisualsPacket(explosionPos, power));
            PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new FlashEffectPacket(explosionPos, power));
            if (power >= lampFlickerPowerThreshold) {
                RedstoneLampEffects.triggerLampFlicker(level2, player, power, delayTicksEffect, distance);
                if (((Boolean)Config.COMMON.enableDripstoneFalling.get()).booleanValue()) {
                    DripstoneEffects.handleDripstoneFall(level2, player.m_20183_(), (int)power, level2.f_46441_);
                }
            }
            if (power >= 5.0f) {
                PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SpawnShockwavePacket(explosionPos, power));
            }
            if (power >= 5.0f) {
                PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SpawnDustCloudPacket(explosionPos, power));
            }
            if (power >= 5.0f) {
                PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SpawnMistCloudPacket(explosionPos, power));
            }
            if (!playerInCave) continue;
            ExplosionOverhaul.CaveEffects.spawnFallingBlocksAndDust(level2, explosionPos, player, power, delayTicksEffect);
        }
        if (power >= 2.0f) {
            SpawnLineSparksPacket packet = new SpawnLineSparksPacket(explosionPos, power);
            PacketDistributor.TargetPoint targetPoint = new PacketDistributor.TargetPoint(explosionPos.m_7096_(), explosionPos.m_7098_(), explosionPos.m_7094_(), 700.0, level2.m_46472_());
            PacketHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> targetPoint), (Object)packet);
        }
    }

    private CameraShakeProfile determineCameraShakeProfile(float power, double distance, boolean playerInCave, int actualCloseDistance, ServerLevel level) {
        float intensity = 0.0f;
        int baseDuration = 20;
        float pushIntensity = 0.0f;
        int baseMediumDistance = 500;
        int baseFarDistance = 1000;
        int baseSuperFarDistance = 5000;
        int mediumDistance = Math.round(2000.0f);
        int farDistance = Math.round(4000.0f);
        int superFarDistance = Math.round(20000.0f);
        int scaledCloseDistance = Math.round((float)actualCloseDistance * 4.0f);
        int powerCategory = power <= 3.0f ? 1 : (power <= 6.0f ? 2 : (power <= 14.0f ? 3 : (power <= 30.0f ? 4 : (power <= 60.0f ? 5 : (power <= 99.0f ? 6 : 7)))));
        int shakeLevel = 0;
        if (distance <= (double)scaledCloseDistance) {
            if (powerCategory == 1) {
                shakeLevel = 2;
                baseDuration = 15;
            } else if (powerCategory == 2) {
                shakeLevel = 3;
                baseDuration = 20;
            } else if (powerCategory == 3) {
                shakeLevel = 3;
                baseDuration = 25;
            } else if (powerCategory == 4) {
                shakeLevel = 4;
                baseDuration = 30;
            } else if (powerCategory == 5) {
                shakeLevel = 4;
                baseDuration = 35;
            } else if (powerCategory == 6) {
                shakeLevel = 5;
                baseDuration = 40;
            } else if (powerCategory >= 7) {
                shakeLevel = 5;
                baseDuration = 50;
            }
        } else if (distance <= (double)mediumDistance) {
            if (powerCategory == 1) {
                shakeLevel = 2;
                baseDuration = 10;
            } else if (powerCategory == 2) {
                shakeLevel = 2;
                baseDuration = 15;
            } else if (powerCategory == 3) {
                shakeLevel = 2;
                baseDuration = 20;
            } else if (powerCategory == 4) {
                shakeLevel = 3;
                baseDuration = 20;
            } else if (powerCategory == 5) {
                shakeLevel = 3;
                baseDuration = 25;
            } else if (powerCategory == 6) {
                shakeLevel = 4;
                baseDuration = 30;
            } else if (powerCategory >= 7) {
                shakeLevel = 4;
                baseDuration = 35;
            }
        } else if (distance <= (double)farDistance) {
            if (powerCategory == 4) {
                shakeLevel = 2;
                baseDuration = 10;
            } else if (powerCategory == 5) {
                shakeLevel = 2;
                baseDuration = 15;
            } else if (powerCategory == 6) {
                shakeLevel = 3;
                baseDuration = 20;
            } else if (powerCategory >= 7) {
                shakeLevel = 3;
                baseDuration = 25;
            }
        } else if (distance <= (double)superFarDistance) {
            if (powerCategory == 5) {
                shakeLevel = 1;
                baseDuration = 10;
            } else if (powerCategory == 6) {
                shakeLevel = 2;
                baseDuration = 15;
            } else if (powerCategory >= 7) {
                shakeLevel = 3;
                baseDuration = 20;
            }
        }
        switch (shakeLevel) {
            case 1: {
                intensity = 0.3f;
                break;
            }
            case 2: {
                intensity = 0.9f;
                break;
            }
            case 3: {
                intensity = 2.0f;
                break;
            }
            case 4: {
                intensity = 3.25f;
                break;
            }
            case 5: {
                intensity = 4.5f;
                break;
            }
            default: {
                intensity = 0.0f;
                baseDuration = 0;
            }
        }
        if (playerInCave && intensity > 0.0f) {
            if (shakeLevel >= 2) {
                float basePush = 0.06f + (float)shakeLevel * 0.03f;
                pushIntensity = Math.min(basePush * (power / 6.0f), 0.45f);
                pushIntensity = Math.max(0.06f, pushIntensity);
            }
            if (distance > 10.0) {
                float attenMax = superFarDistance;
                if (attenMax <= 0.0f) {
                    attenMax = 1.0f;
                }
                float atten = 1.0f - Mth.m_14036_((float)((float)distance / attenMax), (float)0.0f, (float)1.0f);
                intensity *= atten;
                pushIntensity *= atten;
            }
        }
        if (intensity > 0.01f && baseDuration < 5) {
            baseDuration = 5;
        }
        if (intensity < 0.01f) {
            intensity = 0.0f;
            baseDuration = 0;
            pushIntensity = 0.0f;
        }
        return new CameraShakeProfile(intensity, baseDuration, pushIntensity);
    }

    public static List<SoundEvent> getSoundPoolForPower(float power, SoundEvent ... sounds) {
        if (sounds.length != 21) {
            ExplosionOverhaul.LOGGER.error("Expected 21 sounds for power-based selection, but got " + sounds.length + ". Returning fallback.");
            return sounds.length >= 3 ? List.of(sounds[0], sounds[1], sounds[2]) : List.of();
        }
        if (power <= 3.0f) {
            return List.of(sounds[0], sounds[1], sounds[2]);
        }
        if (power <= 6.0f) {
            return List.of(sounds[3], sounds[4], sounds[5]);
        }
        if (power <= 14.0f) {
            return List.of(sounds[6], sounds[7], sounds[8]);
        }
        if (power <= 30.0f) {
            return List.of(sounds[9], sounds[10], sounds[11]);
        }
        if (power <= 60.0f) {
            return List.of(sounds[12], sounds[13], sounds[14]);
        }
        if (power <= 99.0f) {
            return List.of(sounds[15], sounds[16], sounds[17]);
        }
        return List.of(sounds[18], sounds[19], sounds[20]);
    }

    public static boolean isInNaturalCave(ServerLevel level, BlockPos origin) {
        boolean isBelowY60;
        boolean isBedrockLevel;
        if (level.m_46472_() == Level.f_46430_) {
            return false;
        }
        boolean bl = isBedrockLevel = origin.m_123342_() < level.m_141937_() + 5;
        if (isBedrockLevel && !level.m_45527_(origin)) {
            return true;
        }
        boolean bl2 = isBelowY60 = origin.m_123342_() < 60;
        if (isBelowY60 && !level.m_45527_(origin)) {
            return true;
        }
        int stoneCount = 0;
        int solidCount = 0;
        boolean skySeenInVicinity = false;
        int radius = 4;
        int checkedBlocks = 0;
        List<Block> caveStoneBlocks = List.of(Blocks.f_50069_, Blocks.f_50652_, Blocks.f_50079_, Blocks.f_152550_, Blocks.f_152551_, Blocks.f_50334_, Blocks.f_50228_, Blocks.f_50122_, Blocks.f_152496_, Blocks.f_50134_, Blocks.f_50730_, Blocks.f_50137_, Blocks.f_50135_, Blocks.f_50136_);
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    BlockPos checkPos;
                    if (Math.abs(dx) == radius && Math.abs(dy) == radius && Math.abs(dz) == radius || Math.abs(dx) == radius && Math.abs(dy) == radius || Math.abs(dx) == radius && Math.abs(dz) == radius || Math.abs(dy) == radius && Math.abs(dz) == radius || !level.m_46749_(checkPos = origin.m_7918_(dx, dy, dz))) continue;
                    ++checkedBlocks;
                    BlockState state = level.m_8055_(checkPos);
                    if (state.m_280296_()) {
                        ++solidCount;
                        if (!caveStoneBlocks.contains(state.m_60734_())) continue;
                        ++stoneCount;
                        continue;
                    }
                    if (skySeenInVicinity || dy < 0 || !level.m_45527_(checkPos.m_7494_())) continue;
                    skySeenInVicinity = true;
                }
            }
        }
        if (checkedBlocks == 0) {
            return false;
        }
        if (!skySeenInVicinity) {
            double solidRatioInChecked;
            double stoneRatioInChecked = checkedBlocks > 0 ? (double)stoneCount / (double)checkedBlocks : 0.0;
            double d = solidRatioInChecked = checkedBlocks > 0 ? (double)solidCount / (double)checkedBlocks : 0.0;
            if (stoneRatioInChecked > 0.25) {
                return true;
            }
            if (solidRatioInChecked > 0.4) {
                return true;
            }
        }
        return false;
    }

    public static boolean isInHouse(ServerLevel level, BlockPos origin, double playerEyeY) {
        if (level.m_46472_() == Level.f_46430_) {
            return false;
        }
        if (level.m_45527_(origin)) {
            return false;
        }
        if (origin.m_123342_() < level.m_5736_() - 10 && level.m_46472_() == Level.f_46428_) {
            return false;
        }
        int artificialBlockCount = 0;
        int functionalBlockCount = 0;
        boolean hasSolidRoofDirectlyAbove = false;
        int radius = 2;
        int checkedBlocks = 0;
        List<String> artificialKeywords = Arrays.asList("planks", "log", "wood", "brick", "stone_brick", "glass", "wool", "terracotta", "concrete", "door", "fence", "stairs", "slab", "wall", "iron_block", "gold_block", "diamond_block", "emerald_block", "quartz_block", "purpur_block");
        List<Block> specificArtificialBlocks = Arrays.asList(Blocks.f_50652_, Blocks.f_50079_);
        List<Block> functionalBlocks = Arrays.asList(Blocks.f_50091_, Blocks.f_50094_, Blocks.f_50620_, Blocks.f_50619_, Blocks.f_50087_, Blocks.f_50325_, Blocks.f_50265_, Blocks.f_50618_, Blocks.f_50322_, Blocks.f_50323_, Blocks.f_50324_, Blocks.f_50624_, Blocks.f_50621_, Blocks.f_50617_, Blocks.f_50625_, Blocks.f_50623_, Blocks.f_50679_, Blocks.f_50680_, Blocks.f_50131_, Blocks.f_50255_);
        BlockPos headPos = BlockPos.m_274561_((double)origin.m_123341_(), (double)playerEyeY, (double)origin.m_123343_());
        if (level.m_8055_(headPos.m_6630_(1)).m_280296_() && level.m_8055_(headPos.m_6630_(2)).m_280296_()) {
            hasSolidRoofDirectlyAbove = true;
        }
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    BlockPos checkPos = origin.m_7918_(dx, dy, dz);
                    if (!level.m_46749_(checkPos)) continue;
                    ++checkedBlocks;
                    BlockState state = level.m_8055_(checkPos);
                    Block block = state.m_60734_();
                    ResourceLocation registryName = ForgeRegistries.BLOCKS.getKey((Object)block);
                    String name = registryName != null ? registryName.m_135815_() : "";
                    boolean isKeywordArtificial = artificialKeywords.stream().anyMatch(name::contains);
                    if (state.m_280296_() && (isKeywordArtificial || specificArtificialBlocks.contains(block))) {
                        ++artificialBlockCount;
                    }
                    if (!state.m_204336_(BlockTags.f_13038_) && !functionalBlocks.contains(block)) continue;
                    ++functionalBlockCount;
                }
            }
        }
        if (checkedBlocks == 0) {
            return false;
        }
        double artificialRatio = (double)artificialBlockCount / (double)checkedBlocks;
        if (hasSolidRoofDirectlyAbove && (artificialBlockCount > 3 || functionalBlockCount > 0)) {
            return true;
        }
        if (artificialBlockCount > 7 && (functionalBlockCount > 0 || artificialRatio > 0.35)) {
            return true;
        }
        return artificialRatio > 0.2 && artificialBlockCount > 5;
    }

    public static boolean hasLineOfSight(ServerLevel level, Vec3 startPos, Vec3 endPos, Entity entityContext) {
        if (startPos.equals((Object)endPos)) {
            return true;
        }
        ClipContext clipContext = new ClipContext(startPos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entityContext);
        BlockHitResult hitResult = level.m_45547_(clipContext);
        return hitResult.m_6662_() == HitResult.Type.MISS;
    }

    public static List<SoundEvent> getSoundPool(Level level, float power, double distance, boolean playerInHouse, boolean explosionIsInCaveLocation) {
        int closeSoundDistanceThreshold = level.m_46472_() == Level.f_46429_ ? 100 : (level.m_46472_() == Level.f_46430_ ? 150 : 50);
        if (distance <= (double)closeSoundDistanceThreshold) {
            if (power <= 3.0f) {
                return List.of((SoundEvent)ModSounds.EXPLODE_CLOSE_POWER_1_1.get(), (SoundEvent)ModSounds.EXPLODE_CLOSE_POWER_1_2.get(), (SoundEvent)ModSounds.EXPLODE_CLOSE_POWER_1_3.get());
            }
            if (power <= 6.0f) {
                return List.of((SoundEvent)ModSounds.EXPLODE_CLOSE_POWER_2_1.get(), (SoundEvent)ModSounds.EXPLODE_CLOSE_POWER_2_2.get(), (SoundEvent)ModSounds.EXPLODE_CLOSE_POWER_2_3.get());
            }
            if (power <= 14.0f) {
                return List.of((SoundEvent)ModSounds.EXPLODE_CLOSE_POWER_3_1.get(), (SoundEvent)ModSounds.EXPLODE_CLOSE_POWER_3_2.get(), (SoundEvent)ModSounds.EXPLODE_CLOSE_POWER_3_3.get());
            }
            if (power <= 30.0f) {
                return List.of((SoundEvent)ModSounds.EXPLODE_CLOSE_POWER_4_1.get(), (SoundEvent)ModSounds.EXPLODE_CLOSE_POWER_4_2.get(), (SoundEvent)ModSounds.EXPLODE_CLOSE_POWER_4_3.get());
            }
            if (power <= 60.0f) {
                return List.of((SoundEvent)ModSounds.EXPLODE_CLOSE_POWER_5_1.get(), (SoundEvent)ModSounds.EXPLODE_CLOSE_POWER_5_2.get(), (SoundEvent)ModSounds.EXPLODE_CLOSE_POWER_5_3.get());
            }
            if (power <= 99.0f) {
                return List.of((SoundEvent)ModSounds.EXPLODE_CLOSE_POWER_6_1.get(), (SoundEvent)ModSounds.EXPLODE_CLOSE_POWER_6_2.get(), (SoundEvent)ModSounds.EXPLODE_CLOSE_POWER_6_3.get());
            }
            return List.of((SoundEvent)ModSounds.EXPLODE_CLOSE_POWER_7_1.get(), (SoundEvent)ModSounds.EXPLODE_CLOSE_POWER_7_2.get(), (SoundEvent)ModSounds.EXPLODE_CLOSE_POWER_7_3.get());
        }
        if (distance <= 500.0) {
            if (playerInHouse && explosionIsInCaveLocation) {
                return ServerExplosionHandler.getSoundPoolForPower(power, (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_TO_HOUSE_POWER_1_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_TO_HOUSE_POWER_1_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_TO_HOUSE_POWER_1_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_TO_HOUSE_POWER_2_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_TO_HOUSE_POWER_2_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_TO_HOUSE_POWER_2_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_TO_HOUSE_POWER_3_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_TO_HOUSE_POWER_3_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_TO_HOUSE_POWER_3_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_TO_HOUSE_POWER_4_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_TO_HOUSE_POWER_4_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_TO_HOUSE_POWER_4_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_TO_HOUSE_POWER_5_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_TO_HOUSE_POWER_5_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_TO_HOUSE_POWER_5_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_TO_HOUSE_POWER_6_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_TO_HOUSE_POWER_6_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_TO_HOUSE_POWER_6_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_TO_HOUSE_POWER_7_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_TO_HOUSE_POWER_7_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_TO_HOUSE_POWER_7_3.get());
            }
            if (playerInHouse) {
                return ServerExplosionHandler.getSoundPoolForPower(power, (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_1_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_1_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_1_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_2_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_2_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_2_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_3_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_3_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_3_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_4_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_4_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_4_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_5_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_5_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_5_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_6_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_6_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_6_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_7_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_7_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_TO_HOUSE_POWER_7_3.get());
            }
            if (explosionIsInCaveLocation) {
                return ServerExplosionHandler.getSoundPoolForPower(power, (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_POWER_1_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_POWER_1_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_POWER_1_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_POWER_2_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_POWER_2_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_POWER_2_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_POWER_3_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_POWER_3_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_POWER_3_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_POWER_4_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_POWER_4_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_POWER_4_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_POWER_5_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_POWER_5_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_POWER_5_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_POWER_6_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_POWER_6_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_POWER_6_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_POWER_7_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_POWER_7_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_CAVE_POWER_7_3.get());
            }
            return ServerExplosionHandler.getSoundPoolForPower(power, (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_1_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_1_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_1_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_2_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_2_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_2_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_3_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_3_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_3_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_4_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_4_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_4_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_5_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_5_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_5_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_6_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_6_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_6_3.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_7_1.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_7_2.get(), (SoundEvent)ModSounds.EXPLODE_MEDIUM_POWER_7_3.get());
        }
        if (distance <= 1000.0) {
            if (playerInHouse && explosionIsInCaveLocation) {
                return ServerExplosionHandler.getSoundPoolForPower(power, (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_TO_HOUSE_POWER_1_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_TO_HOUSE_POWER_1_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_TO_HOUSE_POWER_1_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_TO_HOUSE_POWER_2_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_TO_HOUSE_POWER_2_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_TO_HOUSE_POWER_2_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_TO_HOUSE_POWER_3_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_TO_HOUSE_POWER_3_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_TO_HOUSE_POWER_3_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_TO_HOUSE_POWER_4_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_TO_HOUSE_POWER_4_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_TO_HOUSE_POWER_4_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_TO_HOUSE_POWER_5_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_TO_HOUSE_POWER_5_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_TO_HOUSE_POWER_5_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_TO_HOUSE_POWER_6_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_TO_HOUSE_POWER_6_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_TO_HOUSE_POWER_6_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_TO_HOUSE_POWER_7_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_TO_HOUSE_POWER_7_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_TO_HOUSE_POWER_7_3.get());
            }
            if (playerInHouse) {
                return ServerExplosionHandler.getSoundPoolForPower(power, (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_1_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_1_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_1_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_2_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_2_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_2_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_3_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_3_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_3_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_4_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_4_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_4_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_5_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_5_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_5_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_6_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_6_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_6_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_7_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_7_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_TO_HOUSE_POWER_7_3.get());
            }
            if (explosionIsInCaveLocation) {
                return ServerExplosionHandler.getSoundPoolForPower(power, (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_POWER_1_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_POWER_1_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_POWER_1_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_POWER_2_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_POWER_2_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_POWER_2_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_POWER_3_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_POWER_3_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_POWER_3_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_POWER_4_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_POWER_4_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_POWER_4_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_POWER_5_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_POWER_5_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_POWER_5_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_POWER_6_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_POWER_6_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_POWER_6_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_POWER_7_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_POWER_7_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_CAVE_POWER_7_3.get());
            }
            return ServerExplosionHandler.getSoundPoolForPower(power, (SoundEvent)ModSounds.EXPLODE_FAR_POWER_1_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_1_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_1_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_2_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_2_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_2_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_3_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_3_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_3_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_4_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_4_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_4_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_5_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_5_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_5_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_6_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_6_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_6_3.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_7_1.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_7_2.get(), (SoundEvent)ModSounds.EXPLODE_FAR_POWER_7_3.get());
        }
        if (distance <= 5001.0) {
            if (playerInHouse && explosionIsInCaveLocation) {
                return ServerExplosionHandler.getSoundPoolForPower(power, (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_TO_HOUSE_POWER_1_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_TO_HOUSE_POWER_1_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_TO_HOUSE_POWER_1_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_TO_HOUSE_POWER_2_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_TO_HOUSE_POWER_2_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_TO_HOUSE_POWER_2_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_TO_HOUSE_POWER_3_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_TO_HOUSE_POWER_3_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_TO_HOUSE_POWER_3_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_TO_HOUSE_POWER_4_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_TO_HOUSE_POWER_4_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_TO_HOUSE_POWER_4_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_TO_HOUSE_POWER_5_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_TO_HOUSE_POWER_5_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_TO_HOUSE_POWER_5_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_TO_HOUSE_POWER_6_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_TO_HOUSE_POWER_6_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_TO_HOUSE_POWER_6_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_TO_HOUSE_POWER_7_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_TO_HOUSE_POWER_7_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_TO_HOUSE_POWER_7_3.get());
            }
            if (playerInHouse) {
                return ServerExplosionHandler.getSoundPoolForPower(power, (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_1_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_1_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_1_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_2_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_2_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_2_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_3_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_3_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_3_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_4_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_4_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_4_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_5_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_5_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_5_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_6_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_6_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_6_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_7_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_7_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_TO_HOUSE_POWER_7_3.get());
            }
            if (explosionIsInCaveLocation) {
                return ServerExplosionHandler.getSoundPoolForPower(power, (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_POWER_1_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_POWER_1_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_POWER_1_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_POWER_2_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_POWER_2_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_POWER_2_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_POWER_3_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_POWER_3_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_POWER_3_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_POWER_4_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_POWER_4_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_POWER_4_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_POWER_5_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_POWER_5_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_POWER_5_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_POWER_6_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_POWER_6_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_POWER_6_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_POWER_7_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_POWER_7_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_CAVE_POWER_7_3.get());
            }
            return ServerExplosionHandler.getSoundPoolForPower(power, (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_1_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_1_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_1_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_2_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_2_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_2_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_3_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_3_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_3_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_4_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_4_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_4_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_5_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_5_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_5_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_6_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_6_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_6_3.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_7_1.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_7_2.get(), (SoundEvent)ModSounds.EXPLODE_SUPERFAR_POWER_7_3.get());
        }
        return null;
    }

    public record CameraShakeProfile(float intensity, int durationTicks, float pushIntensity) {
    }
}

