/*
 * Decompiled with CFR 0.152.
 */
package com.vinlanx.explosionoverhaul;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.vinlanx.explosionoverhaul.ModParticles;
import java.util.Locale;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;

public class SmokeParticleOptions
implements ParticleOptions {
    public static final Codec<SmokeParticleOptions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("scale").forGetter(SmokeParticleOptions::getScale), (App)Codec.INT.fieldOf("lifetime").forGetter(SmokeParticleOptions::getLifetime), (App)Codec.FLOAT.fieldOf("r").forGetter(SmokeParticleOptions::getRed), (App)Codec.FLOAT.fieldOf("g").forGetter(SmokeParticleOptions::getGreen), (App)Codec.FLOAT.fieldOf("b").forGetter(SmokeParticleOptions::getBlue), (App)Codec.FLOAT.fieldOf("a").forGetter(SmokeParticleOptions::getAlpha), (App)Codec.BOOL.fieldOf("isHeavy").forGetter(SmokeParticleOptions::isHeavy)).apply((Applicative)instance, (scale, lifetime, r, g, b, a, isHeavy) -> new SmokeParticleOptions(scale.floatValue(), (int)lifetime, r.floatValue(), g.floatValue(), b.floatValue(), a.floatValue(), (boolean)isHeavy, null)));
    public static final ParticleOptions.Deserializer<SmokeParticleOptions> DESERIALIZER = new ParticleOptions.Deserializer<SmokeParticleOptions>(){

        public SmokeParticleOptions fromCommand(ParticleType<SmokeParticleOptions> particleType, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float scale = reader.readFloat();
            reader.expect(' ');
            int lifetime = reader.readInt();
            reader.expect(' ');
            float r = reader.readFloat();
            reader.expect(' ');
            float g = reader.readFloat();
            reader.expect(' ');
            float b = reader.readFloat();
            reader.expect(' ');
            float a = reader.readFloat();
            reader.expect(' ');
            boolean isHeavy = reader.readBoolean();
            return new SmokeParticleOptions(scale, lifetime, r, g, b, a, isHeavy, null);
        }

        public SmokeParticleOptions fromNetwork(ParticleType<SmokeParticleOptions> particleType, FriendlyByteBuf buffer) {
            return new SmokeParticleOptions(buffer.readFloat(), buffer.readInt(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readBoolean(), null);
        }
    };
    private final float scale;
    private final int lifetime;
    private final float r;
    private final float g;
    private final float b;
    private final float a;
    private final boolean isHeavy;
    private final SpriteSet sprites;

    public SmokeParticleOptions(float scale, int lifetime, float r, float g, float b, float a, boolean isHeavy, SpriteSet sprites) {
        this.scale = scale;
        this.lifetime = lifetime;
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        this.isHeavy = isHeavy;
        this.sprites = sprites;
    }

    public SmokeParticleOptions(float scale, int lifetime, float r, float g, float b, float a, SpriteSet sprites) {
        this(scale, lifetime, r, g, b, a, false, sprites);
    }

    public ParticleType<?> m_6012_() {
        return (ParticleType)ModParticles.CUSTOM_SMOKE.get();
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.scale);
        buffer.writeInt(this.lifetime);
        buffer.writeFloat(this.r);
        buffer.writeFloat(this.g);
        buffer.writeFloat(this.b);
        buffer.writeFloat(this.a);
        buffer.writeBoolean(this.isHeavy);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %.2f %d %.2f %.2f %.2f %.2f %b", ModParticles.CUSTOM_SMOKE.getId(), Float.valueOf(this.scale), this.lifetime, Float.valueOf(this.r), Float.valueOf(this.g), Float.valueOf(this.b), Float.valueOf(this.a), this.isHeavy);
    }

    public float getScale() {
        return this.scale;
    }

    public int getLifetime() {
        return this.lifetime;
    }

    public float getRed() {
        return this.r;
    }

    public float getGreen() {
        return this.g;
    }

    public float getBlue() {
        return this.b;
    }

    public float getAlpha() {
        return this.a;
    }

    public boolean isHeavy() {
        return this.isHeavy;
    }

    public SpriteSet getSprites() {
        return this.sprites;
    }
}

