/*
 * Decompiled with CFR 0.152.
 */
package com.vinlanx.explosionoverhaul;

import com.vinlanx.explosionoverhaul.client.ClientEffects;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class SpawnAmbientCaveDustPacket {
    private final float power;

    public SpawnAmbientCaveDustPacket(float power) {
        this.power = power;
    }

    public static void encode(SpawnAmbientCaveDustPacket msg, FriendlyByteBuf buf) {
        buf.writeFloat(msg.power);
    }

    public static SpawnAmbientCaveDustPacket decode(FriendlyByteBuf buf) {
        return new SpawnAmbientCaveDustPacket(buf.readFloat());
    }

    public static void handle(SpawnAmbientCaveDustPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientEffects.triggerAmbientCaveDust(msg.power)));
        ctx.get().setPacketHandled(true);
    }
}

