/*
 * Decompiled with CFR 0.152.
 */
package com.vinlanx.explosionoverhaul;

import com.vinlanx.explosionoverhaul.CustomGlowParticleOptions;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class SpawnCustomGlowPacket {
    private final Vec3 pos;
    private final Vec3 motion;
    private final int zone;
    private final float power;
    private final float scale;

    public SpawnCustomGlowPacket(Vec3 pos, Vec3 motion, int zone, float power, float scale) {
        this.pos = pos;
        this.motion = motion;
        this.zone = zone;
        this.power = power;
        this.scale = scale;
    }

    public static void encode(SpawnCustomGlowPacket msg, FriendlyByteBuf buf) {
        buf.writeDouble(msg.pos.f_82479_);
        buf.writeDouble(msg.pos.f_82480_);
        buf.writeDouble(msg.pos.f_82481_);
        buf.writeDouble(msg.motion.f_82479_);
        buf.writeDouble(msg.motion.f_82480_);
        buf.writeDouble(msg.motion.f_82481_);
        buf.writeInt(msg.zone);
        buf.writeFloat(msg.power);
        buf.writeFloat(msg.scale);
    }

    public static SpawnCustomGlowPacket decode(FriendlyByteBuf buf) {
        return new SpawnCustomGlowPacket(new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble()), new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble()), buf.readInt(), buf.readFloat(), buf.readFloat());
    }

    public static void handle(SpawnCustomGlowPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientPacketHandler.handlePacket(msg)));
        ctx.get().setPacketHandled(true);
    }

    public static class ClientPacketHandler {
        public static void handlePacket(SpawnCustomGlowPacket msg) {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level != null) {
                CustomGlowParticleOptions options = new CustomGlowParticleOptions(msg.zone, msg.power, msg.scale);
                level.m_7106_((ParticleOptions)options, msg.pos.f_82479_, msg.pos.f_82480_, msg.pos.f_82481_, msg.motion.f_82479_, msg.motion.f_82480_, msg.motion.f_82481_);
            }
        }
    }
}

