/*
 * Decompiled with CFR 0.152.
 */
package com.vinlanx.explosionoverhaul;

import com.vinlanx.explosionoverhaul.client.ClientEffects;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class SpawnDustCloudPacket {
    private final Vec3 position;
    private final float power;

    public SpawnDustCloudPacket(Vec3 position, float power) {
        this.position = position;
        this.power = power;
    }

    public static void encode(SpawnDustCloudPacket msg, FriendlyByteBuf buf) {
        buf.writeDouble(msg.position.f_82479_);
        buf.writeDouble(msg.position.f_82480_);
        buf.writeDouble(msg.position.f_82481_);
        buf.writeFloat(msg.power);
    }

    public static SpawnDustCloudPacket decode(FriendlyByteBuf buf) {
        return new SpawnDustCloudPacket(new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble()), buf.readFloat());
    }

    public static void handle(SpawnDustCloudPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientEffects.triggerDustCloud(msg.position, msg.power)));
        ctx.get().setPacketHandled(true);
    }
}

