/*
 * Decompiled with CFR 0.152.
 */
package com.vinlanx.explosionoverhaul.client;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.vinlanx.explosionoverhaul.Config;
import com.vinlanx.explosionoverhaul.CustomGlowParticleOptions;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class CustomGlowParticle
extends TextureSheetParticle {
    private final SpriteSet spriteSet;
    private final float power;
    private final float initialQuadSize;
    private final int animationDuration;
    private final int animationType;
    private static final int GLOW_FRAME_COUNT = 239;
    private static final int SGLOW_FRAME_COUNT = 224;
    private static final int FRAMES_PER_SHEET = 64;
    private static final int FRAMES_PER_ROW = 8;
    private static final int GLOW_BASE_SHEET_START = 0;
    private static final int GLOW2_BASE_SHEET_START = 4;
    private static final int SGLOW_BASE_SHEET_START = 8;
    private static final int GLOW_EMISSIVE_SHEET_START = 12;
    private static final int GLOW2_EMISSIVE_SHEET_START = 16;
    private static final int SGLOW_EMISSIVE_SHEET_START = 20;
    private static final int TOTAL_SHEETS_PER_QUALITY = 24;
    private static final int TOTAL_SHEETS = 48;
    private int baseFrameOnSheet;
    private int emissiveSheetIndex;
    private int emissiveFrameOnSheet;

    public CustomGlowParticle(ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed, CustomGlowParticleOptions options, SpriteSet spriteSet) {
        super(pLevel, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed);
        int fadeOutDurationTicks;
        this.f_172258_ = 0.98f;
        this.f_107226_ = 0.0f;
        this.f_107215_ = pXSpeed;
        this.f_107216_ = pYSpeed;
        this.f_107217_ = pZSpeed;
        this.power = options.getPower();
        this.initialQuadSize = options.getScale();
        this.animationType = options.getAnimationType();
        this.f_107663_ = this.initialQuadSize;
        this.spriteSet = spriteSet;
        this.m_108337_(spriteSet.m_5819_(0, 47));
        if (this.power <= 1.0f) {
            this.animationDuration = 40;
            fadeOutDurationTicks = 40;
        } else if (this.power <= 10.0f) {
            this.animationDuration = this.interpolate(this.power, 1.0f, 40.0f, 10.0f, 100.0f);
            fadeOutDurationTicks = this.interpolate(this.power, 1.0f, 40.0f, 10.0f, 60.0f);
        } else if (this.power <= 60.0f) {
            this.animationDuration = this.interpolate(this.power, 10.0f, 100.0f, 60.0f, 140.0f);
            fadeOutDurationTicks = this.interpolate(this.power, 10.0f, 60.0f, 60.0f, 80.0f);
        } else if (this.power <= 100.0f) {
            this.animationDuration = this.interpolate(this.power, 60.0f, 140.0f, 100.0f, 200.0f);
            fadeOutDurationTicks = this.interpolate(this.power, 60.0f, 80.0f, 100.0f, 120.0f);
        } else {
            this.animationDuration = 200;
            fadeOutDurationTicks = 120;
        }
        this.f_107225_ = this.animationDuration + fadeOutDurationTicks;
    }

    public void m_5989_() {
        int frameIndex;
        int emissiveSheetStart;
        int baseSheetStart;
        int frameCountForAnim;
        int qualityOffset;
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
            return;
        }
        int n = qualityOffset = Config.CLIENT.glowTextureQuality.get() == Config.Client.GlowTextureQuality.QUALITY_64 ? 24 : 0;
        if (this.animationType == 2) {
            frameCountForAnim = 224;
            baseSheetStart = 8 + qualityOffset;
            emissiveSheetStart = 20 + qualityOffset;
        } else if (this.animationType == 1) {
            frameCountForAnim = 239;
            baseSheetStart = 4 + qualityOffset;
            emissiveSheetStart = 16 + qualityOffset;
        } else {
            frameCountForAnim = 239;
            baseSheetStart = 0 + qualityOffset;
            emissiveSheetStart = 12 + qualityOffset;
        }
        if (this.f_107224_ < this.animationDuration) {
            float animProgress = (float)this.f_107224_ / (float)this.animationDuration;
            float easedProgress = 1.0f - (float)Math.pow(1.0f - animProgress, 3.0);
            frameIndex = (int)(easedProgress * (float)(frameCountForAnim - 1));
            this.f_107230_ = 1.0f;
        } else {
            frameIndex = frameCountForAnim - 1;
            int fadeDuration = this.f_107225_ - this.animationDuration;
            int ageInFade = this.f_107224_ - this.animationDuration;
            this.f_107230_ = 1.0f - (float)ageInFade / (float)fadeDuration;
        }
        frameIndex = Mth.m_14045_((int)frameIndex, (int)0, (int)(frameCountForAnim - 1));
        int baseSheetIndex = baseSheetStart + frameIndex / 64;
        this.baseFrameOnSheet = frameIndex % 64;
        this.emissiveSheetIndex = emissiveSheetStart + frameIndex / 64;
        this.emissiveFrameOnSheet = frameIndex % 64;
        this.m_108337_(this.spriteSet.m_5819_(baseSheetIndex, 47));
        this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
        this.f_107215_ *= (double)this.f_172258_;
        this.f_107216_ *= (double)this.f_172258_;
        this.f_107217_ *= (double)this.f_172258_;
    }

    public void m_5744_(VertexConsumer pBuffer, Camera pRenderInfo, float pPartialTicks) {
        Vector3f[] avector3f;
        Vec3 vec3 = pRenderInfo.m_90583_();
        float f = (float)(Mth.m_14139_((double)pPartialTicks, (double)this.f_107209_, (double)this.f_107212_) - vec3.m_7096_());
        float f1 = (float)(Mth.m_14139_((double)pPartialTicks, (double)this.f_107210_, (double)this.f_107213_) - vec3.m_7098_());
        float f2 = (float)(Mth.m_14139_((double)pPartialTicks, (double)this.f_107211_, (double)this.f_107214_) - vec3.m_7094_());
        Quaternionf quaternion = new Quaternionf((Quaternionfc)pRenderInfo.m_253121_());
        if (this.f_107231_ != 0.0f) {
            float f3 = Mth.m_14179_((float)pPartialTicks, (float)this.f_107204_, (float)this.f_107231_);
            quaternion.rotateZ(f3);
        }
        if (this.animationType == 2) {
            float aspectRatio = 0.5629139f;
            avector3f = new Vector3f[]{new Vector3f(-0.5629139f, -1.0f, 0.0f), new Vector3f(-0.5629139f, 1.0f, 0.0f), new Vector3f(0.5629139f, 1.0f, 0.0f), new Vector3f(0.5629139f, -1.0f, 0.0f)};
        } else {
            avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        }
        float f4 = this.m_5902_(pPartialTicks);
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.rotate((Quaternionfc)quaternion);
            vector3f.mul(f4);
            vector3f.add(f, f1, f2);
        }
        int worldLight = this.m_6355_(pPartialTicks);
        this.renderFrame(pBuffer, avector3f, this.f_108321_, this.baseFrameOnSheet, this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_, worldLight);
        TextureAtlasSprite emissiveSprite = this.spriteSet.m_5819_(this.emissiveSheetIndex, 47);
        int fullBright = 240;
        this.renderFrame(pBuffer, avector3f, emissiveSprite, this.emissiveFrameOnSheet, this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_, fullBright);
    }

    private void renderFrame(VertexConsumer buffer, Vector3f[] vertices, TextureAtlasSprite sheetSprite, int frame, float r, float g, float b, float a, int light) {
        float totalU = sheetSprite.m_118410_() - sheetSprite.m_118409_();
        float totalV = sheetSprite.m_118412_() - sheetSprite.m_118411_();
        float frameUWidth = totalU / 8.0f;
        float frameVHeight = totalV / 8.0f;
        int col = frame % 8;
        int row = frame / 8;
        float u0 = sheetSprite.m_118409_() + (float)col * frameUWidth;
        float v0 = sheetSprite.m_118411_() + (float)row * frameVHeight;
        float u1 = u0 + frameUWidth;
        float v1 = v0 + frameVHeight;
        buffer.m_5483_((double)vertices[0].x(), (double)vertices[0].y(), (double)vertices[0].z()).m_7421_(u1, v1).m_85950_(r, g, b, a).m_85969_(light).m_5752_();
        buffer.m_5483_((double)vertices[1].x(), (double)vertices[1].y(), (double)vertices[1].z()).m_7421_(u1, v0).m_85950_(r, g, b, a).m_85969_(light).m_5752_();
        buffer.m_5483_((double)vertices[2].x(), (double)vertices[2].y(), (double)vertices[2].z()).m_7421_(u0, v0).m_85950_(r, g, b, a).m_85969_(light).m_5752_();
        buffer.m_5483_((double)vertices[3].x(), (double)vertices[3].y(), (double)vertices[3].z()).m_7421_(u0, v1).m_85950_(r, g, b, a).m_85969_(light).m_5752_();
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    private int interpolate(float power, float p1, float v1, float p2, float v2) {
        if (p2 == p1) {
            return (int)v1;
        }
        float fraction = (power - p1) / (p2 - p1);
        return (int)(v1 + fraction * (v2 - v1));
    }
}

