/*
 * Decompiled with CFR 0.152.
 */
package com.vinlanx.explosionoverhaul.client;

import com.vinlanx.explosionoverhaul.Config;
import com.vinlanx.explosionoverhaul.SmokeParticleOptions;
import java.awt.Color;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class GroundDustEffect {
    private final ClientLevel level;
    private final Vec3 initialPosition;
    private final float power;
    private final Random random = new Random();
    private int age = 0;
    private final int maxAge;
    private final float maxRadius;
    private final float particleBaseSize;
    private final int particlesPerTick;
    private Color currentDustColor = new Color(128, 128, 128);
    private boolean finished = false;
    private final int raycastFrequency;

    public GroundDustEffect(Vec3 position, float power) {
        this.level = Minecraft.m_91087_().f_91073_;
        this.initialPosition = position;
        this.power = power;
        double qualityMultiplier = (Double)Config.CLIENT.groundDustQuality.get();
        this.raycastFrequency = (Integer)Config.CLIENT.groundDustRaycastFrequency.get();
        float powerFraction = Mth.m_14036_((float)(power / 100.0f), (float)0.0f, (float)1.0f);
        int calculatedParticles = (int)((double)Mth.m_14179_((float)powerFraction, (float)40.0f, (float)200.0f) * qualityMultiplier);
        int calculatedMaxAge = (int)((double)Mth.m_14179_((float)powerFraction, (float)30.0f, (float)70.0f) * qualityMultiplier);
        if (qualityMultiplier > 0.0) {
            if (calculatedParticles == 0) {
                calculatedParticles = 1;
            }
            if (calculatedMaxAge == 0) {
                calculatedMaxAge = 1;
            }
        }
        this.particlesPerTick = calculatedParticles;
        this.maxAge = calculatedMaxAge;
        this.maxRadius = power * this.calculateRadiusMultiplier(power);
        this.particleBaseSize = Mth.m_14179_((float)powerFraction, (float)1.0f, (float)12.0f);
    }

    private float calculateRadiusMultiplier(float power) {
        if (power <= 5.0f) {
            return 2.0f;
        }
        if (power <= 40.0f) {
            return Mth.m_14179_((float)((power - 5.0f) / 35.0f), (float)2.0f, (float)4.0f);
        }
        if (power <= 80.0f) {
            return Mth.m_14179_((float)((power - 40.0f) / 40.0f), (float)4.0f, (float)5.0f);
        }
        if (power <= 100.0f) {
            return Mth.m_14179_((float)((power - 80.0f) / 20.0f), (float)5.0f, (float)7.0f);
        }
        return 7.0f;
    }

    private Color getDustColorForState(BlockState state) {
        if (state.m_204336_(BlockTags.f_13035_) || state.m_284242_((BlockGetter)this.level, BlockPos.f_121853_) == MapColor.f_283808_) {
            return null;
        }
        if (state.m_60713_(Blocks.f_50440_)) {
            return new Color(Blocks.f_50493_.m_49966_().m_284242_((BlockGetter)this.level, (BlockPos)BlockPos.f_121853_).f_283871_);
        }
        if (state.m_60713_(Blocks.f_50125_) || state.m_60713_(Blocks.f_50127_)) {
            return new Color(Blocks.f_50127_.m_49966_().m_284242_((BlockGetter)this.level, (BlockPos)BlockPos.f_121853_).f_283871_);
        }
        return new Color(state.m_284242_((BlockGetter)this.level, (BlockPos)BlockPos.f_121853_).f_283871_);
    }

    public void tick() {
        BlockPos blockPos;
        BlockState blockState;
        Color newColor;
        double checkZ;
        double checkAngle;
        double checkX;
        BlockHitResult hitResult;
        if (this.finished || this.level == null) {
            return;
        }
        ++this.age;
        if (this.age > this.maxAge) {
            this.finished = true;
            return;
        }
        float progress = (float)this.age / (float)this.maxAge;
        float easedProgress = 1.0f - (float)Math.pow(1.0f - progress, 3.0);
        float currentRadius = this.maxRadius * easedProgress;
        if (this.age % 10 == 0 && (hitResult = this.level.m_45547_(new ClipContext(new Vec3(checkX = this.initialPosition.f_82479_ + Math.cos(checkAngle = this.random.nextDouble() * 2.0 * Math.PI) * (double)currentRadius, this.initialPosition.f_82480_ + 15.0, checkZ = this.initialPosition.f_82481_ + Math.sin(checkAngle) * (double)currentRadius), new Vec3(checkX, this.initialPosition.f_82480_ - 15.0, checkZ), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null))).m_6662_() == HitResult.Type.BLOCK && (newColor = this.getDustColorForState(blockState = this.level.m_8055_(blockPos = hitResult.m_82425_()))) != null) {
            this.currentDustColor = newColor;
        }
        double cachedY = this.initialPosition.f_82480_;
        for (int i = 0; i < this.particlesPerTick; ++i) {
            float scale;
            float a;
            float r;
            float g;
            float b;
            double angle = (double)i / (double)this.particlesPerTick * 2.0 * Math.PI + (this.random.nextDouble() - 0.5) * 0.1;
            double radiusFrac = this.random.nextDouble();
            double spawnRadius = (double)currentRadius * (0.6 + radiusFrac * 0.4);
            double spawnX = this.initialPosition.f_82479_ + Math.cos(angle) * spawnRadius;
            double spawnZ = this.initialPosition.f_82481_ + Math.sin(angle) * spawnRadius;
            if (i % this.raycastFrequency == 0) {
                BlockHitResult hitResult2 = this.level.m_45547_(new ClipContext(new Vec3(spawnX, this.initialPosition.f_82480_ + 15.0, spawnZ), new Vec3(spawnX, this.initialPosition.f_82480_ - 15.0, spawnZ), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null));
                if (hitResult2.m_6662_() != HitResult.Type.BLOCK) continue;
                cachedY = hitResult2.m_82450_().f_82480_;
            }
            double spawnY = cachedY;
            Vec3 direction = new Vec3(spawnX - this.initialPosition.f_82479_, 0.0, spawnZ - this.initialPosition.f_82481_).m_82541_();
            double motionStrength = Mth.m_14179_((float)(1.0f - progress), (float)0.05f, (float)0.45f);
            double motionX = direction.f_82479_ * motionStrength + (this.random.nextDouble() - 0.5) * 0.05;
            double motionZ = direction.f_82481_ * motionStrength + (this.random.nextDouble() - 0.5) * 0.05;
            double motionY = (this.random.nextDouble() - 0.5) * 0.02;
            int lifetime = 100 + this.random.nextInt(60);
            if (radiusFrac <= 0.2) {
                b = 0.2f;
                g = 0.2f;
                r = 0.2f;
                a = 0.9f;
                scale = this.particleBaseSize * 0.5f;
            } else if (radiusFrac <= 0.65) {
                b = 0.4f;
                g = 0.4f;
                r = 0.4f;
                a = 0.6f;
                scale = this.particleBaseSize * 0.75f;
            } else {
                r = (float)this.currentDustColor.getRed() / 255.0f;
                g = (float)this.currentDustColor.getGreen() / 255.0f;
                b = (float)this.currentDustColor.getBlue() / 255.0f;
                a = 0.35f;
                scale = this.particleBaseSize;
            }
            SmokeParticleOptions options = new SmokeParticleOptions(scale * (0.8f + this.random.nextFloat() * 0.4f), lifetime, r, g, b, a, false, null);
            this.level.m_6493_((ParticleOptions)options, true, spawnX, spawnY + 0.2, spawnZ, motionX, motionY, motionZ);
        }
    }

    public boolean isFinished() {
        return this.finished;
    }
}

