/*
 * Decompiled with CFR 0.152.
 */
package com.vinlanx.explosionoverhaul.client;

import com.vinlanx.explosionoverhaul.Config;
import com.vinlanx.explosionoverhaul.SmokeParticleOptions;
import java.awt.Color;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class GroundMistEffect {
    private final ClientLevel level;
    private final Vec3 initialPosition;
    private final float power;
    private final Random random = new Random();
    private int age = 0;
    private final int maxAge;
    private final float maxRadius;
    private final float particleBaseSize;
    private final int particlesPerTick;
    private Color currentMistColor = new Color(255, 255, 255);
    private boolean finished = false;
    private final int raycastFrequency;

    public GroundMistEffect(Vec3 position, float power) {
        this.level = Minecraft.m_91087_().f_91073_;
        this.initialPosition = position;
        this.power = power;
        double qualityMultiplier = (Double)Config.CLIENT.groundMistQuality.get();
        this.raycastFrequency = (Integer)Config.CLIENT.groundMistRaycastFrequency.get();
        float powerFraction = Mth.m_14036_((float)(power / 100.0f), (float)0.0f, (float)1.0f);
        int calculatedParticles = (int)((double)Mth.m_14179_((float)powerFraction, (float)40.0f, (float)200.0f) * qualityMultiplier * 1.5);
        int calculatedMaxAge = (int)((double)Mth.m_14179_((float)powerFraction, (float)30.0f, (float)70.0f) * qualityMultiplier / 3.0);
        if (qualityMultiplier > 0.0) {
            if (calculatedParticles == 0) {
                calculatedParticles = 1;
            }
            if (calculatedMaxAge == 0) {
                calculatedMaxAge = 1;
            }
        }
        this.particlesPerTick = calculatedParticles;
        this.maxAge = calculatedMaxAge;
        this.maxRadius = power * this.calculateRadiusMultiplier(power) * 3.0f;
        this.particleBaseSize = Mth.m_14179_((float)powerFraction, (float)1.0f, (float)12.0f);
    }

    private float calculateRadiusMultiplier(float power) {
        if (power <= 5.0f) {
            return 2.0f;
        }
        if (power <= 40.0f) {
            return Mth.m_14179_((float)((power - 5.0f) / 35.0f), (float)2.0f, (float)4.0f);
        }
        if (power <= 80.0f) {
            return Mth.m_14179_((float)((power - 40.0f) / 40.0f), (float)4.0f, (float)5.0f);
        }
        if (power <= 100.0f) {
            return Mth.m_14179_((float)((power - 80.0f) / 20.0f), (float)5.0f, (float)7.0f);
        }
        return 7.0f;
    }

    public void tick() {
        double checkZ;
        double checkAngle;
        double checkX;
        BlockHitResult hitResult;
        if (this.finished || this.level == null) {
            return;
        }
        ++this.age;
        if (this.age > this.maxAge) {
            this.finished = true;
            return;
        }
        float progress = (float)this.age / (float)this.maxAge;
        float easedProgress = 1.0f - (float)Math.pow(1.0f - progress, 3.0);
        float currentRadius = this.maxRadius * easedProgress;
        if (this.age % 10 == 0 && (hitResult = this.level.m_45547_(new ClipContext(new Vec3(checkX = this.initialPosition.f_82479_ + Math.cos(checkAngle = this.random.nextDouble() * 2.0 * Math.PI) * (double)currentRadius, this.initialPosition.f_82480_ + 15.0, checkZ = this.initialPosition.f_82481_ + Math.sin(checkAngle) * (double)currentRadius), new Vec3(checkX, this.initialPosition.f_82480_ - 15.0, checkZ), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null))).m_6662_() == HitResult.Type.BLOCK) {
            BlockPos blockPos = hitResult.m_82425_();
            BlockState blockState = this.level.m_8055_(blockPos);
        }
        double cachedY = this.initialPosition.f_82480_;
        for (int i = 0; i < this.particlesPerTick; ++i) {
            float scale;
            float a;
            float r;
            float g;
            float b;
            double angle = (double)i / (double)this.particlesPerTick * 2.0 * Math.PI + (this.random.nextDouble() - 0.5) * 0.1;
            double radiusFrac = this.random.nextDouble();
            double spawnRadius = (double)currentRadius * (0.6 + radiusFrac * 0.4);
            double spawnX = this.initialPosition.f_82479_ + Math.cos(angle) * spawnRadius;
            double spawnZ = this.initialPosition.f_82481_ + Math.sin(angle) * spawnRadius;
            if (i % this.raycastFrequency == 0) {
                BlockHitResult hitResult2 = this.level.m_45547_(new ClipContext(new Vec3(spawnX, this.initialPosition.f_82480_ + 15.0, spawnZ), new Vec3(spawnX, this.initialPosition.f_82480_ - 15.0, spawnZ), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null));
                if (hitResult2.m_6662_() != HitResult.Type.BLOCK) continue;
                cachedY = hitResult2.m_82450_().f_82480_;
            }
            double spawnY = cachedY;
            Vec3 direction = new Vec3(spawnX - this.initialPosition.f_82479_, 0.0, spawnZ - this.initialPosition.f_82481_).m_82541_();
            double motionStrength = Mth.m_14179_((float)(1.0f - progress), (float)0.02f, (float)0.15f);
            double motionX = direction.f_82479_ * motionStrength + (this.random.nextDouble() - 0.5) * 0.02;
            double motionZ = direction.f_82481_ * motionStrength + (this.random.nextDouble() - 0.5) * 0.02;
            double motionY = -0.01 - this.random.nextDouble() * 0.02;
            int lifetime = 100 + this.random.nextInt(60);
            if (radiusFrac <= 0.2) {
                b = 0.8f;
                g = 0.8f;
                r = 0.8f;
                a = 0.3f;
                scale = this.particleBaseSize * 0.1667f;
            } else if (radiusFrac <= 0.65) {
                b = 0.9f;
                g = 0.9f;
                r = 0.9f;
                a = 0.2f;
                scale = this.particleBaseSize * 0.25f;
            } else {
                r = (float)this.currentMistColor.getRed() / 255.0f;
                g = (float)this.currentMistColor.getGreen() / 255.0f;
                b = (float)this.currentMistColor.getBlue() / 255.0f;
                a = 0.15f;
                scale = this.particleBaseSize * 0.333f;
            }
            SmokeParticleOptions options = new SmokeParticleOptions(scale * (0.8f + this.random.nextFloat() * 0.4f), lifetime, r, g, b, a, false, null);
            this.level.m_6493_((ParticleOptions)options, true, spawnX, spawnY + 0.05, spawnZ, motionX, motionY, motionZ);
        }
    }

    public boolean isFinished() {
        return this.finished;
    }
}

