/*
 * Decompiled with CFR 0.152.
 */
package com.vinlanx.explosionoverhaul.client;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class LineSparkParticle
extends TextureSheetParticle {
    private final SpriteSet spriteSet;
    private float length;
    private float width;
    private final float initialLength;
    private static final Vec3 UP = new Vec3(0.0, 1.0, 0.0);

    public LineSparkParticle(ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed, SpriteSet pSpriteSet) {
        super(pLevel, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed);
        float baseSize;
        this.f_107215_ = pXSpeed;
        this.f_107216_ = pYSpeed;
        this.f_107217_ = pZSpeed;
        this.spriteSet = pSpriteSet;
        this.f_172258_ = 0.97f;
        this.f_107226_ = 0.4f;
        this.f_107225_ = 250 + this.f_107223_.m_188503_(150);
        this.initialLength = baseSize = (this.f_107223_.m_188501_() * 0.4f + 0.5f) * 1.2f;
        this.length = 0.1f;
        this.width = baseSize * 0.125f;
        this.m_108337_(this.spriteSet.m_5819_(0, 1));
    }

    public void m_5989_() {
        float stretchFactor;
        super.m_5989_();
        float lifeProgress = (float)this.f_107224_ / (float)this.f_107225_;
        if (lifeProgress < 0.2f) {
            t = lifeProgress / 0.2f;
            stretchFactor = 1.0f - (1.0f - t) * (1.0f - t);
        } else if (lifeProgress < 0.7f) {
            stretchFactor = 1.0f;
        } else {
            t = (lifeProgress - 0.7f) / 0.3f;
            stretchFactor = 1.0f - t * t;
        }
        stretchFactor = Mth.m_14036_((float)stretchFactor, (float)0.0f, (float)1.0f);
        float distanceScale = 1.0f;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null) {
            double distSqr = mc.f_91074_.m_20275_(this.f_107212_, this.f_107213_, this.f_107214_);
            double dist = Math.sqrt(distSqr);
            if (dist > 171.0) {
                distanceScale = 2.5f;
            } else if (dist > 141.0) {
                distanceScale = 2.2f;
            } else if (dist > 101.0) {
                distanceScale = 2.0f;
            } else if (dist > 71.0) {
                distanceScale = 1.7f;
            } else if (dist > 50.0) {
                distanceScale = 1.5f;
            }
        }
        this.length = this.initialLength * stretchFactor * distanceScale;
        this.width = this.initialLength * 0.125f * distanceScale;
        if (this.length < 0.01f) {
            this.length = 0.01f;
        }
        this.f_107230_ = Mth.m_14089_((float)((float)this.f_107224_ / (float)this.f_107225_ * (float)Math.PI / 2.0f));
        if (this.f_107218_) {
            this.m_107274_();
        }
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public void m_5744_(VertexConsumer buffer, Camera camera, float partialTicks) {
        Vec3 camPos = camera.m_90583_();
        float x = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - camPos.m_7096_());
        float y = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - camPos.m_7098_());
        float z = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - camPos.m_7094_());
        Vec3 velocity = new Vec3(this.f_107215_, this.f_107216_, this.f_107217_).m_82541_();
        if (velocity.m_82556_() < 1.0E-4) {
            return;
        }
        Vec3 viewVector = new Vec3((double)x, (double)y, (double)z).m_82541_();
        Vec3 rightVector = velocity.m_82537_(viewVector).m_82541_();
        if (rightVector.m_82556_() < 1.0E-4 && (rightVector = velocity.m_82537_(UP).m_82541_()).m_82556_() < 1.0E-4) {
            rightVector = velocity.m_82537_(new Vec3(1.0, 0.0, 0.0)).m_82541_();
        }
        Vec3 upVector = rightVector.m_82537_(velocity).m_82541_();
        Vector3f[] vertices = new Vector3f[]{new Vector3f(x, y, z).add((Vector3fc)upVector.m_82490_((double)(-this.length / 2.0f)).m_82549_(rightVector.m_82490_((double)(this.width / 2.0f))).m_252839_()), new Vector3f(x, y, z).add((Vector3fc)upVector.m_82490_((double)(this.length / 2.0f)).m_82549_(rightVector.m_82490_((double)(this.width / 2.0f))).m_252839_()), new Vector3f(x, y, z).add((Vector3fc)upVector.m_82490_((double)(this.length / 2.0f)).m_82549_(rightVector.m_82490_((double)(-this.width / 2.0f))).m_252839_()), new Vector3f(x, y, z).add((Vector3fc)upVector.m_82490_((double)(-this.length / 2.0f)).m_82549_(rightVector.m_82490_((double)(-this.width / 2.0f))).m_252839_())};
        int worldLight = this.m_6355_(partialTicks);
        this.renderQuad(buffer, vertices, this.f_108321_, this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_, worldLight);
        TextureAtlasSprite emissiveSprite = this.spriteSet.m_5819_(1, 1);
        int fullBright = 240;
        this.renderQuad(buffer, vertices, emissiveSprite, 1.0f, 1.0f, 1.0f, this.f_107230_, fullBright);
    }

    private void renderQuad(VertexConsumer buffer, Vector3f[] vertices, TextureAtlasSprite sprite, float r, float g, float b, float a, int light) {
        float u0 = sprite.m_118409_();
        float u1 = sprite.m_118410_();
        float v0 = sprite.m_118411_();
        float v1 = sprite.m_118412_();
        buffer.m_5483_((double)vertices[0].x(), (double)vertices[0].y(), (double)vertices[0].z()).m_7421_(u1, v1).m_85950_(r, g, b, a).m_85969_(light).m_5752_();
        buffer.m_5483_((double)vertices[1].x(), (double)vertices[1].y(), (double)vertices[1].z()).m_7421_(u1, v0).m_85950_(r, g, b, a).m_85969_(light).m_5752_();
        buffer.m_5483_((double)vertices[2].x(), (double)vertices[2].y(), (double)vertices[2].z()).m_7421_(u0, v0).m_85950_(r, g, b, a).m_85969_(light).m_5752_();
        buffer.m_5483_((double)vertices[3].x(), (double)vertices[3].y(), (double)vertices[3].z()).m_7421_(u0, v1).m_85950_(r, g, b, a).m_85969_(light).m_5752_();
    }
}

