/*
 * Decompiled with CFR 0.152.
 */
package com.vinlanx.explosionoverhaul.client;

import com.vinlanx.explosionoverhaul.Config;
import com.vinlanx.explosionoverhaul.CraterDeformer;
import java.util.ArrayList;
import java.util.Optional;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.common.ForgeConfigSpec;

public class ModConfigScreen {
    public static Screen create(Screen parent) {
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((Component)Component.m_237115_((String)"title.explosionoverhaul.config"));
        ConfigCategory serverCategory = builder.getOrCreateCategory((Component)Component.m_237115_((String)"category.explosionoverhaul.server"));
        builder.setSavingRunnable(() -> {
            Config.CLIENT_SPEC.save();
            Config.COMMON_SPEC.save();
        });
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        serverCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.m_237115_((String)"option.explosionoverhaul.enableFallingBlocks"), ((Boolean)Config.COMMON.enableFallingBlocks.get()).booleanValue()).setDefaultValue(true).setTooltip(new Component[]{Component.m_237115_((String)"tooltip.explosionoverhaul.enableFallingBlocks")}).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.BooleanValue)Config.COMMON.enableFallingBlocks).set(arg_0)).build());
        serverCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.m_237115_((String)"option.explosionoverhaul.enableExplosionClustering"), ((Boolean)Config.COMMON.enableExplosionClustering.get()).booleanValue()).setDefaultValue(true).setTooltip(new Component[]{Component.m_237115_((String)"tooltip.explosionoverhaul.enableExplosionClustering")}).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.BooleanValue)Config.COMMON.enableExplosionClustering).set(arg_0)).build());
        serverCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.m_237115_((String)"option.explosionoverhaul.enableCraterDestruction"), ((Boolean)Config.COMMON.enableCraterDestruction.get()).booleanValue()).setDefaultValue(true).setTooltip(new Component[]{Component.m_237115_((String)"tooltip.explosionoverhaul.enableCraterDestruction")}).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.BooleanValue)Config.COMMON.enableCraterDestruction).set(arg_0)).build());
        serverCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.m_237115_((String)"option.explosionoverhaul.enableGlassBreaking"), ((Boolean)Config.COMMON.enableGlassBreaking.get()).booleanValue()).setDefaultValue(true).setTooltip(new Component[]{Component.m_237115_((String)"tooltip.explosionoverhaul.enableGlassBreaking")}).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.BooleanValue)Config.COMMON.enableGlassBreaking).set(arg_0)).build());
        serverCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.m_237115_((String)"option.explosionoverhaul.enableDripstoneFalling"), ((Boolean)Config.COMMON.enableDripstoneFalling.get()).booleanValue()).setDefaultValue(true).setTooltip(new Component[]{Component.m_237115_((String)"tooltip.explosionoverhaul.enableDripstoneFalling")}).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.BooleanValue)Config.COMMON.enableDripstoneFalling).set(arg_0)).build());
        serverCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.m_237115_((String)"option.explosionoverhaul.enableLampFlicker"), ((Boolean)Config.COMMON.enableLampFlicker.get()).booleanValue()).setDefaultValue(true).setTooltip(new Component[]{Component.m_237115_((String)"tooltip.explosionoverhaul.enableLampFlicker")}).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.BooleanValue)Config.COMMON.enableLampFlicker).set(arg_0)).build());
        serverCategory.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((Component)Component.m_237113_((String)" ")).build());
        serverCategory.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((Component)Component.m_237115_((String)"option.explosionoverhaul.craterSettingsHeader")).build());
        serverCategory.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((Component)Component.m_237115_((String)"option.explosionoverhaul.craterSizeMultiplier"), (int)((Double)Config.COMMON.craterSizeMultiplier.get() * 100.0), 10, 5000).setDefaultValue(100).setTextGetter(value -> {
            double val = (double)value.intValue() / 100.0;
            Object text = String.format("%.2fx", val);
            if (val > 10.0) {
                text = (String)text + " \u00a7c(EXTREME!)";
            }
            return Component.m_237113_((String)text);
        }).setTooltipSupplier(value -> Optional.of(ModConfigScreen.generateCraterTable((double)value.intValue() / 100.0))).setSaveConsumer(newValue -> Config.COMMON.craterSizeMultiplier.set((Object)((double)newValue.intValue() / 100.0))).build());
        serverCategory.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((Component)Component.m_237115_((String)"option.explosionoverhaul.craterCoreRatio"), (int)((Double)Config.COMMON.craterCoreRatio.get() * 100.0), 10, 95).setDefaultValue(70).setTextGetter(value -> Component.m_237113_((String)(value + "%"))).setTooltip(new Component[]{Component.m_237115_((String)"tooltip.explosionoverhaul.craterCoreRatio")}).setSaveConsumer(newValue -> Config.COMMON.craterCoreRatio.set((Object)((double)newValue.intValue() / 100.0))).build());
        serverCategory.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((Component)Component.m_237113_((String)" ")).build());
        serverCategory.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((Component)Component.m_237115_((String)"option.explosionoverhaul.glassBreakingSettings")).build());
        serverCategory.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((Component)Component.m_237115_((String)"option.explosionoverhaul.glassBreakingIntervalTicks"), ((Integer)Config.COMMON.glassBreakingIntervalTicks.get()).intValue(), 1, 20).setDefaultValue(1).setTooltip(new Component[]{Component.m_237115_((String)"tooltip.explosionoverhaul.glassBreakingIntervalTicks")}).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.IntValue)Config.COMMON.glassBreakingIntervalTicks).set(arg_0)).build());
        serverCategory.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((Component)Component.m_237115_((String)"option.explosionoverhaul.glassBlocksPerCycle"), ((Integer)Config.COMMON.glassBlocksPerCycle.get()).intValue(), 10, 500).setDefaultValue(70).setTooltip(new Component[]{Component.m_237115_((String)"tooltip.explosionoverhaul.glassBlocksPerCycle")}).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.IntValue)Config.COMMON.glassBlocksPerCycle).set(arg_0)).build());
        serverCategory.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((Component)Component.m_237113_((String)" ")).build());
        serverCategory.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((Component)Component.m_237115_((String)"option.explosionoverhaul.lampFlickerSettings")).build());
        serverCategory.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((Component)Component.m_237115_((String)"option.explosionoverhaul.lampFlickerSearchRadius"), ((Integer)Config.COMMON.lampFlickerSearchRadius.get()).intValue(), 1, 100).setDefaultValue(50).setTooltip(new Component[]{Component.m_237115_((String)"tooltip.explosionoverhaul.lampFlickerSearchRadius")}).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.IntValue)Config.COMMON.lampFlickerSearchRadius).set(arg_0)).build());
        serverCategory.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((Component)Component.m_237115_((String)"option.explosionoverhaul.dripstoneFallingSettings")).build());
        serverCategory.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((Component)Component.m_237115_((String)"option.explosionoverhaul.dripstoneFallingSearchRadius"), ((Integer)Config.COMMON.dripstoneFallingSearchRadius.get()).intValue(), 1, 100).setDefaultValue(50).setTooltip(new Component[]{Component.m_237115_((String)"tooltip.explosionoverhaul.dripstoneFallingSearchRadius")}).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.IntValue)Config.COMMON.dripstoneFallingSearchRadius).set(arg_0)).build());
        ConfigCategory ambientCategory = builder.getOrCreateCategory((Component)Component.m_237115_((String)"category.explosionoverhaul.ambient"));
        Config.Common.Ambient ambientConfig = Config.COMMON.ambient;
        ambientCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.m_237115_((String)"option.explosionoverhaul.enableAmbientExplosions"), ((Boolean)ambientConfig.enableAmbientExplosions.get()).booleanValue()).setDefaultValue(false).setTooltip(new Component[]{Component.m_237115_((String)"tooltip.explosionoverhaul.enableAmbientExplosions")}).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.BooleanValue)ambientConfig.enableAmbientExplosions).set(arg_0)).build());
        ambientCategory.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((Component)Component.m_237115_((String)"option.explosionoverhaul.minTimeBetweenExplosions"), (Integer)ambientConfig.minTimeBetweenExplosions.get() / 20, 5, 3600).setDefaultValue(60).setTextGetter(value -> Component.m_237113_((String)(value + " s"))).setTooltip(new Component[]{Component.m_237115_((String)"tooltip.explosionoverhaul.minTimeBetweenExplosions")}).setSaveConsumer(newValue -> ambientConfig.minTimeBetweenExplosions.set((Object)(newValue * 20))).build());
        ambientCategory.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((Component)Component.m_237115_((String)"option.explosionoverhaul.maxTimeBetweenExplosions"), (Integer)ambientConfig.maxTimeBetweenExplosions.get() / 20, 10, 3600).setDefaultValue(300).setTextGetter(value -> Component.m_237113_((String)(value + " s"))).setTooltip(new Component[]{Component.m_237115_((String)"tooltip.explosionoverhaul.maxTimeBetweenExplosions")}).setSaveConsumer(newValue -> ambientConfig.maxTimeBetweenExplosions.set((Object)(newValue * 20))).build());
        ambientCategory.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((Component)Component.m_237115_((String)"option.explosionoverhaul.minExplosionDistance"), ((Integer)ambientConfig.minExplosionDistance.get()).intValue(), 100, 10000).setDefaultValue(501).setTextGetter(value -> Component.m_237113_((String)(value + " blocks"))).setTooltip(new Component[]{Component.m_237115_((String)"tooltip.explosionoverhaul.minExplosionDistance")}).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.IntValue)ambientConfig.minExplosionDistance).set(arg_0)).build());
        ambientCategory.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((Component)Component.m_237115_((String)"option.explosionoverhaul.maxExplosionDistance"), ((Integer)ambientConfig.maxExplosionDistance.get()).intValue(), 200, 10000).setDefaultValue(5001).setTextGetter(value -> Component.m_237113_((String)(value + " blocks"))).setTooltip(new Component[]{Component.m_237115_((String)"tooltip.explosionoverhaul.maxExplosionDistance")}).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.IntValue)ambientConfig.maxExplosionDistance).set(arg_0)).build());
        ambientCategory.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((Component)Component.m_237115_((String)"option.explosionoverhaul.maxAmbientExplosionPower"), (int)((Double)ambientConfig.maxAmbientExplosionPower.get() * 10.0), 400, 2000).setDefaultValue(800).setTextGetter(value -> Component.m_237113_((String)String.format("%.1f", (double)value.intValue() / 10.0))).setTooltip(new Component[]{Component.m_237115_((String)"tooltip.explosionoverhaul.maxAmbientExplosionPower")}).setSaveConsumer(newValue -> ambientConfig.maxAmbientExplosionPower.set((Object)((double)newValue.intValue() / 10.0))).build());
        Config.Common.Ambient.Scenarios scenariosConfig = ambientConfig.scenarios;
        ambientCategory.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((Component)Component.m_237113_((String)" ")).build());
        ambientCategory.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((Component)Component.m_237115_((String)"option.explosionoverhaul.scenariosHeader")).setTooltip(new Component[]{Component.m_237115_((String)"tooltip.explosionoverhaul.scenariosHeader")}).build());
        ambientCategory.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((Component)Component.m_237115_((String)"option.explosionoverhaul.singleExplosionWeight"), ((Integer)scenariosConfig.singleExplosionWeight.get()).intValue(), 0, 100).setTextGetter(v -> Component.m_237113_((String)(v + "%"))).setDefaultValue(70).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.IntValue)scenariosConfig.singleExplosionWeight).set(arg_0)).build());
        ambientCategory.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((Component)Component.m_237115_((String)"option.explosionoverhaul.chainReactionWeight"), ((Integer)scenariosConfig.chainReactionWeight.get()).intValue(), 0, 100).setTextGetter(v -> Component.m_237113_((String)(v + "%"))).setDefaultValue(15).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.IntValue)scenariosConfig.chainReactionWeight).set(arg_0)).build());
        ambientCategory.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((Component)Component.m_237115_((String)"option.explosionoverhaul.shellingWeight"), ((Integer)scenariosConfig.shellingWeight.get()).intValue(), 0, 100).setTextGetter(v -> Component.m_237113_((String)(v + "%"))).setDefaultValue(15).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.IntValue)scenariosConfig.shellingWeight).set(arg_0)).build());
        ambientCategory.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((Component)Component.m_237115_((String)"option.explosionoverhaul.chainReactionSettingsHeader")).build());
        ambientCategory.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((Component)Component.m_237115_((String)"option.explosionoverhaul.minChainReactionShots"), ((Integer)scenariosConfig.minChainReactionShots.get()).intValue(), 2, 20).setDefaultValue(3).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.IntValue)scenariosConfig.minChainReactionShots).set(arg_0)).build());
        ambientCategory.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((Component)Component.m_237115_((String)"option.explosionoverhaul.maxChainReactionShots"), ((Integer)scenariosConfig.maxChainReactionShots.get()).intValue(), 2, 20).setDefaultValue(7).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.IntValue)scenariosConfig.maxChainReactionShots).set(arg_0)).build());
        ambientCategory.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((Component)Component.m_237115_((String)"option.explosionoverhaul.minTimeBetweenChainShots"), ((Integer)scenariosConfig.minTimeBetweenChainShots.get()).intValue(), 5, 200).setTextGetter(v -> Component.m_237113_((String)String.format("%.2fs", (double)v.intValue() / 20.0))).setDefaultValue(10).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.IntValue)scenariosConfig.minTimeBetweenChainShots).set(arg_0)).build());
        ambientCategory.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((Component)Component.m_237115_((String)"option.explosionoverhaul.maxTimeBetweenChainShots"), ((Integer)scenariosConfig.maxTimeBetweenChainShots.get()).intValue(), 10, 400).setTextGetter(v -> Component.m_237113_((String)String.format("%.2fs", (double)v.intValue() / 20.0))).setDefaultValue(40).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.IntValue)scenariosConfig.maxTimeBetweenChainShots).set(arg_0)).build());
        ambientCategory.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((Component)Component.m_237115_((String)"option.explosionoverhaul.shellingSettingsHeader")).build());
        ambientCategory.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((Component)Component.m_237115_((String)"option.explosionoverhaul.minShellingDelay"), ((Integer)scenariosConfig.minShellingDelay.get()).intValue(), 20, 400).setTextGetter(v -> Component.m_237113_((String)String.format("%.2fs", (double)v.intValue() / 20.0))).setDefaultValue(40).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.IntValue)scenariosConfig.minShellingDelay).set(arg_0)).build());
        ambientCategory.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((Component)Component.m_237115_((String)"option.explosionoverhaul.maxShellingDelay"), ((Integer)scenariosConfig.maxShellingDelay.get()).intValue(), 20, 400).setTextGetter(v -> Component.m_237113_((String)String.format("%.2fs", (double)v.intValue() / 20.0))).setDefaultValue(140).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.IntValue)scenariosConfig.maxShellingDelay).set(arg_0)).build());
        ambientCategory.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((Component)Component.m_237113_((String)" ")).build());
        ambientCategory.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((Component)Component.m_237115_((String)"option.explosionoverhaul.powerTiersHeader")).setTooltip(new Component[]{Component.m_237115_((String)"tooltip.explosionoverhaul.powerTiersHeader")}).build());
        ambientCategory.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((Component)Component.m_237115_((String)"option.explosionoverhaul.tier1_weight"), ((Integer)ambientConfig.powerTiers.tier1_weight.get()).intValue(), 0, 100).setTextGetter(v -> Component.m_237113_((String)(v + "%"))).setDefaultValue(50).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.IntValue)ambientConfig.powerTiers.tier1_weight).set(arg_0)).build());
        ambientCategory.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((Component)Component.m_237115_((String)"option.explosionoverhaul.tier2_weight"), ((Integer)ambientConfig.powerTiers.tier2_weight.get()).intValue(), 0, 100).setTextGetter(v -> Component.m_237113_((String)(v + "%"))).setDefaultValue(25).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.IntValue)ambientConfig.powerTiers.tier2_weight).set(arg_0)).build());
        ambientCategory.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((Component)Component.m_237115_((String)"option.explosionoverhaul.tier3_weight"), ((Integer)ambientConfig.powerTiers.tier3_weight.get()).intValue(), 0, 100).setTextGetter(v -> Component.m_237113_((String)(v + "%"))).setDefaultValue(15).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.IntValue)ambientConfig.powerTiers.tier3_weight).set(arg_0)).build());
        ambientCategory.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((Component)Component.m_237115_((String)"option.explosionoverhaul.tier4_weight"), ((Integer)ambientConfig.powerTiers.tier4_weight.get()).intValue(), 0, 100).setTextGetter(v -> Component.m_237113_((String)(v + "%"))).setDefaultValue(8).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.IntValue)ambientConfig.powerTiers.tier4_weight).set(arg_0)).build());
        ambientCategory.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((Component)Component.m_237115_((String)"option.explosionoverhaul.tier5_weight"), ((Integer)ambientConfig.powerTiers.tier5_weight.get()).intValue(), 0, 100).setTextGetter(v -> Component.m_237113_((String)(v + "%"))).setDefaultValue(2).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.IntValue)ambientConfig.powerTiers.tier5_weight).set(arg_0)).build());
        ambientCategory.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((Component)Component.m_237113_((String)" ")).build());
        ambientCategory.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((Component)Component.m_237115_((String)"option.explosionoverhaul.soundTypesHeader")).build());
        ambientCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.m_237115_((String)"option.explosionoverhaul.enableSurfaceSounds"), ((Boolean)ambientConfig.soundTypes.enableSurfaceSounds.get()).booleanValue()).setTooltip(new Component[]{Component.m_237115_((String)"tooltip.explosionoverhaul.enableSurfaceSounds")}).setDefaultValue(true).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.BooleanValue)ambientConfig.soundTypes.enableSurfaceSounds).set(arg_0)).build());
        ambientCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.m_237115_((String)"option.explosionoverhaul.enableCaveSounds"), ((Boolean)ambientConfig.soundTypes.enableCaveSounds.get()).booleanValue()).setTooltip(new Component[]{Component.m_237115_((String)"tooltip.explosionoverhaul.enableCaveSounds")}).setDefaultValue(true).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.BooleanValue)ambientConfig.soundTypes.enableCaveSounds).set(arg_0)).build());
        ambientCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.m_237115_((String)"option.explosionoverhaul.enableAmbientCaveDust"), ((Boolean)ambientConfig.soundTypes.enableAmbientCaveDust.get()).booleanValue()).setTooltip(new Component[]{Component.m_237115_((String)"tooltip.explosionoverhaul.enableAmbientCaveDust")}).setDefaultValue(true).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.BooleanValue)ambientConfig.soundTypes.enableAmbientCaveDust).set(arg_0)).build());
        ConfigCategory renderCategory = builder.getOrCreateCategory((Component)Component.m_237115_((String)"category.explosionoverhaul.render"));
        renderCategory.addEntry((AbstractConfigListEntry)entryBuilder.startEnumSelector((Component)Component.m_237115_((String)"option.explosionoverhaul.glowTextureQuality"), Config.Client.GlowTextureQuality.class, (Enum)((Config.Client.GlowTextureQuality)((Object)Config.CLIENT.glowTextureQuality.get()))).setDefaultValue((Enum)Config.Client.GlowTextureQuality.QUALITY_256).setTooltip(new Component[]{Component.m_237115_((String)"tooltip.explosionoverhaul.glowTextureQuality")}).setSaveConsumer(arg_0 -> Config.CLIENT.glowTextureQuality.set(arg_0)).setEnumNameProvider(value -> Component.m_237113_((String)(value == Config.Client.GlowTextureQuality.QUALITY_64 ? "64x" : "256x"))).build());
        renderCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.m_237115_((String)"option.explosionoverhaul.enableExplosionParticles"), ((Boolean)Config.CLIENT.enableExplosionParticles.get()).booleanValue()).setDefaultValue(true).setTooltip(new Component[]{Component.m_237115_((String)"tooltip.explosionoverhaul.enableExplosionParticles")}).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.BooleanValue)Config.CLIENT.enableExplosionParticles).set(arg_0)).build());
        renderCategory.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((Component)Component.m_237113_((String)" ")).build());
        renderCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.m_237115_((String)"option.explosionoverhaul.enablePlasmaParticles"), ((Boolean)Config.CLIENT.enablePlasmaParticles.get()).booleanValue()).setDefaultValue(true).setTooltip(new Component[]{Component.m_237115_((String)"tooltip.explosionoverhaul.enablePlasmaParticles")}).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.BooleanValue)Config.CLIENT.enablePlasmaParticles).set(arg_0)).build());
        renderCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.m_237115_((String)"option.explosionoverhaul.enablePlasmaSmokeTrail"), ((Boolean)Config.CLIENT.enablePlasmaSmokeTrail.get()).booleanValue()).setDefaultValue(true).setTooltip(new Component[]{Component.m_237115_((String)"tooltip.explosionoverhaul.enablePlasmaSmokeTrail")}).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.BooleanValue)Config.CLIENT.enablePlasmaSmokeTrail).set(arg_0)).build());
        renderCategory.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((Component)Component.m_237115_((String)"option.explosionoverhaul.plasmaSmokeFrequency"), (int)((Double)Config.CLIENT.plasmaSmokeFrequency.get() * 100.0), 0, 100).setDefaultValue(25).setTextGetter(value -> Component.m_237113_((String)(value + "%"))).setTooltip(new Component[]{Component.m_237115_((String)"tooltip.explosionoverhaul.plasmaSmokeFrequency")}).setSaveConsumer(newValue -> Config.CLIENT.plasmaSmokeFrequency.set((Object)((double)newValue.intValue() / 100.0))).build());
        renderCategory.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((Component)Component.m_237115_((String)"option.explosionoverhaul.plasmaSmokeCount"), ((Integer)Config.CLIENT.plasmaSmokeCount.get()).intValue(), 0, 5).setDefaultValue(1).setTextGetter(value -> Component.m_237113_((String)String.valueOf(value))).setTooltip(new Component[]{Component.m_237115_((String)"tooltip.explosionoverhaul.plasmaSmokeCount")}).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.IntValue)Config.CLIENT.plasmaSmokeCount).set(arg_0)).build());
        renderCategory.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((Component)Component.m_237113_((String)" ")).build());
        renderCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.m_237115_((String)"option.explosionoverhaul.enableFlashEffect"), ((Boolean)Config.CLIENT.enableFlashEffect.get()).booleanValue()).setDefaultValue(true).setTooltip(new Component[]{Component.m_237115_((String)"tooltip.explosionoverhaul.enableFlashEffect")}).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.BooleanValue)Config.CLIENT.enableFlashEffect).set(arg_0)).build());
        renderCategory.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((Component)Component.m_237115_((String)"option.explosionoverhaul.flashMaxOpacity"), (int)((Double)Config.CLIENT.flashMaxOpacity.get() * 100.0), 0, 100).setDefaultValue(50).setTextGetter(value -> Component.m_237113_((String)(value + "%"))).setTooltip(new Component[]{Component.m_237115_((String)"tooltip.explosionoverhaul.flashMaxOpacity")}).setSaveConsumer(newValue -> Config.CLIENT.flashMaxOpacity.set((Object)((double)newValue.intValue() / 100.0))).build());
        renderCategory.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((Component)Component.m_237113_((String)" ")).build());
        renderCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.m_237115_((String)"option.explosionoverhaul.enableLineSparks"), ((Boolean)Config.CLIENT.enableLineSparks.get()).booleanValue()).setDefaultValue(true).setTooltip(new Component[]{Component.m_237115_((String)"tooltip.explosionoverhaul.enableLineSparks")}).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.BooleanValue)Config.CLIENT.enableLineSparks).set(arg_0)).build());
        renderCategory.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((Component)Component.m_237115_((String)"option.explosionoverhaul.lineSparkAmountMultiplier"), (int)((Double)Config.CLIENT.lineSparkAmountMultiplier.get() * 100.0), 0, 500).setDefaultValue(100).setTextGetter(value -> Component.m_237113_((String)String.format("%d%%", value))).setTooltip(new Component[]{Component.m_237115_((String)"tooltip.explosionoverhaul.lineSparkAmountMultiplier")}).setSaveConsumer(newValue -> Config.CLIENT.lineSparkAmountMultiplier.set((Object)((double)newValue.intValue() / 100.0))).build());
        renderCategory.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((Component)Component.m_237113_((String)" ")).build());
        renderCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.m_237115_((String)"option.explosionoverhaul.enableGroundDustEffect"), ((Boolean)Config.CLIENT.enableGroundDustEffect.get()).booleanValue()).setDefaultValue(true).setTooltip(new Component[]{Component.m_237115_((String)"tooltip.explosionoverhaul.enableGroundDustEffect")}).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.BooleanValue)Config.CLIENT.enableGroundDustEffect).set(arg_0)).build());
        renderCategory.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((Component)Component.m_237115_((String)"option.explosionoverhaul.groundDustQuality"), (int)((Double)Config.CLIENT.groundDustQuality.get() * 100.0), 0, 100).setDefaultValue(100).setTextGetter(value -> Component.m_237113_((String)(value + "%"))).setTooltip(new Component[]{Component.m_237115_((String)"tooltip.explosionoverhaul.groundDustQuality")}).setSaveConsumer(newValue -> Config.CLIENT.groundDustQuality.set((Object)((double)newValue.intValue() / 100.0))).build());
        renderCategory.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((Component)Component.m_237115_((String)"option.explosionoverhaul.groundDustRaycastFrequency"), ((Integer)Config.CLIENT.groundDustRaycastFrequency.get()).intValue(), 1, 20).setDefaultValue(10).setTooltip(new Component[]{Component.m_237115_((String)"tooltip.explosionoverhaul.groundDustRaycastFrequency")}).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.IntValue)Config.CLIENT.groundDustRaycastFrequency).set(arg_0)).build());
        renderCategory.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((Component)Component.m_237113_((String)" ")).build());
        renderCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.m_237115_((String)"option.explosionoverhaul.enableGroundMistEffect"), ((Boolean)Config.CLIENT.enableGroundMistEffect.get()).booleanValue()).setDefaultValue(true).setTooltip(new Component[]{Component.m_237115_((String)"tooltip.explosionoverhaul.enableGroundMistEffect")}).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.BooleanValue)Config.CLIENT.enableGroundMistEffect).set(arg_0)).build());
        renderCategory.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((Component)Component.m_237115_((String)"option.explosionoverhaul.groundMistQuality"), (int)((Double)Config.CLIENT.groundMistQuality.get() * 100.0), 0, 100).setDefaultValue(100).setTextGetter(value -> Component.m_237113_((String)(value + "%"))).setTooltip(new Component[]{Component.m_237115_((String)"tooltip.explosionoverhaul.groundMistQuality")}).setSaveConsumer(newValue -> Config.CLIENT.groundMistQuality.set((Object)((double)newValue.intValue() / 100.0))).build());
        renderCategory.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((Component)Component.m_237115_((String)"option.explosionoverhaul.groundMistRaycastFrequency"), ((Integer)Config.CLIENT.groundMistRaycastFrequency.get()).intValue(), 1, 20).setDefaultValue(10).setTooltip(new Component[]{Component.m_237115_((String)"tooltip.explosionoverhaul.groundMistRaycastFrequency")}).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.IntValue)Config.CLIENT.groundMistRaycastFrequency).set(arg_0)).build());
        renderCategory.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((Component)Component.m_237113_((String)" ")).build());
        ConfigCategory cameraCategory = builder.getOrCreateCategory((Component)Component.m_237115_((String)"category.explosionoverhaul.camera"));
        cameraCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.m_237115_((String)"option.explosionoverhaul.enableCameraShake"), ((Boolean)Config.CLIENT.enableCameraShake.get()).booleanValue()).setDefaultValue(true).setTooltip(new Component[]{Component.m_237115_((String)"tooltip.explosionoverhaul.enableCameraShake")}).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.BooleanValue)Config.CLIENT.enableCameraShake).set(arg_0)).build());
        cameraCategory.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((Component)Component.m_237115_((String)"option.explosionoverhaul.cameraShakeAmplifier"), (int)((Double)Config.CLIENT.cameraShakeAmplifier.get() * 10.0), 0, 100).setDefaultValue(10).setTextGetter(value -> Component.m_237113_((String)String.format("%.1fx", (double)value.intValue() / 10.0))).setTooltip(new Component[]{Component.m_237115_((String)"tooltip.explosionoverhaul.cameraShakeAmplifier")}).setSaveConsumer(newValue -> Config.CLIENT.cameraShakeAmplifier.set((Object)((double)newValue.intValue() / 10.0))).build());
        cameraCategory.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((Component)Component.m_237115_((String)"option.explosionoverhaul.cameraServerHeader")).build());
        cameraCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.m_237115_((String)"option.explosionoverhaul.enablePlayerShake"), ((Boolean)Config.COMMON.enablePlayerShake.get()).booleanValue()).setDefaultValue(true).setTooltip(new Component[]{Component.m_237115_((String)"tooltip.explosionoverhaul.enablePlayerShake")}).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.BooleanValue)Config.COMMON.enablePlayerShake).set(arg_0)).build());
        cameraCategory.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((Component)Component.m_237115_((String)"option.explosionoverhaul.playerShakeAmplifier"), (int)((Double)Config.COMMON.playerShakeAmplifier.get() * 10.0), 0, 100).setDefaultValue(10).setTextGetter(value -> Component.m_237113_((String)String.format("%.1fx", (double)value.intValue() / 10.0))).setTooltip(new Component[]{Component.m_237115_((String)"option.explosionoverhaul.playerShakeAmplifier")}).setSaveConsumer(newValue -> Config.COMMON.playerShakeAmplifier.set((Object)((double)newValue.intValue() / 10.0))).build());
        ConfigCategory scanCategory = builder.getOrCreateCategory((Component)Component.m_237115_((String)"category.explosionoverhaul.scan"));
        scanCategory.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((Component)Component.m_237115_((String)"option.explosionoverhaul.scanSettingsHeader")).build());
        scanCategory.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((Component)Component.m_237115_((String)"option.explosionoverhaul.chunksToScanPerTick"), ((Integer)Config.COMMON.scan.chunksToScanPerTick.get()).intValue(), 1, 5000).setDefaultValue(50).setTooltip(new Component[]{Component.m_237115_((String)"tooltip.explosionoverhaul.chunksToScanPerTick")}).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.IntValue)Config.COMMON.scan.chunksToScanPerTick).set(arg_0)).build());
        scanCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.m_237115_((String)"option.explosionoverhaul.enableBlockIndexing"), ((Boolean)Config.COMMON.scan.enableBlockIndexing.get()).booleanValue()).setDefaultValue(true).setTooltip(new Component[]{Component.m_237115_((String)"tooltip.explosionoverhaul.enableBlockIndexing")}).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.BooleanValue)Config.COMMON.scan.enableBlockIndexing).set(arg_0)).build());
        scanCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.m_237115_((String)"option.explosionoverhaul.showScanProgressHUD"), ((Boolean)Config.COMMON.scan.showScanProgressHUD.get()).booleanValue()).setDefaultValue(true).setTooltip(new Component[]{Component.m_237115_((String)"tooltip.explosionoverhaul.showScanProgressHUD")}).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.BooleanValue)Config.COMMON.scan.showScanProgressHUD).set(arg_0)).build());
        return builder.build();
    }

    private static Component[] generateCraterTable(double multiplier) {
        int[] powerLevels;
        ArrayList<MutableComponent> lines = new ArrayList<MutableComponent>();
        lines.add(Component.m_237115_((String)"tooltip.explosionoverhaul.craterSizeMultiplier.title"));
        lines.add(Component.m_237113_((String)""));
        lines.add(Component.m_237113_((String)"\u00a7bPower \u00a78| \u00a7aApprox. Diameter"));
        lines.add(Component.m_237113_((String)"\u00a77--------------------------"));
        for (int power : powerLevels = new int[]{4, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100}) {
            float baseRadius = CraterDeformer.calculateRadius(power);
            float diameter = (float)((double)baseRadius * multiplier * 2.0);
            String formattedLine = String.format("\u00a7f%-12d\u00a78| \u00a7a~%.1f blocks", power, Float.valueOf(diameter));
            lines.add(Component.m_237113_((String)formattedLine));
        }
        lines.add(Component.m_237113_((String)"\u00a77--------------------------"));
        lines.add(Component.m_237115_((String)"tooltip.explosionoverhaul.craterSizeMultiplier.footer"));
        lines.add(Component.m_237113_((String)""));
        lines.add(Component.m_237115_((String)"tooltip.explosionoverhaul.craterShapeInfo"));
        return lines.toArray(new Component[0]);
    }
}

