/*
 * Decompiled with CFR 0.152.
 */
package com.vinlanx.explosionoverhaul.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.vinlanx.explosionoverhaul.Config;
import com.vinlanx.explosionoverhaul.PlasmaParticleOptions;
import com.vinlanx.explosionoverhaul.SmokeParticleOptions;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class PlasmaParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;
    private final float initialQuadSize;

    protected PlasmaParticle(ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed, PlasmaParticleOptions options, SpriteSet pSpriteSet) {
        super(pLevel, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed);
        this.sprites = pSpriteSet;
        this.f_172258_ = 0.96f;
        this.f_107226_ = 0.2f;
        this.f_107215_ = pXSpeed;
        this.f_107216_ = pYSpeed;
        this.f_107217_ = pZSpeed;
        float power = options.getPower();
        float powerFraction = Mth.m_14036_((float)(power / 100.0f), (float)0.0f, (float)1.0f);
        this.f_107663_ = this.initialQuadSize = Mth.m_14179_((float)powerFraction, (float)0.4f, (float)2.5f);
        this.f_107225_ = 200 + this.f_107223_.m_188503_(40) - 20;
        this.f_107227_ = 0.8f;
        this.f_107228_ = 0.8f;
        this.f_107229_ = 0.8f;
        this.m_108335_(pSpriteSet);
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public int m_6355_(float pPartialTick) {
        return 240;
    }

    public void m_5744_(VertexConsumer pBuffer, Camera pRenderInfo, float pPartialTicks) {
        RenderSystem.disableDepthTest();
        Vec3 vec3 = pRenderInfo.m_90583_();
        float f = (float)(Mth.m_14139_((double)pPartialTicks, (double)this.f_107209_, (double)this.f_107212_) - vec3.m_7096_());
        float f1 = (float)(Mth.m_14139_((double)pPartialTicks, (double)this.f_107210_, (double)this.f_107213_) - vec3.m_7098_());
        float f2 = (float)(Mth.m_14139_((double)pPartialTicks, (double)this.f_107211_, (double)this.f_107214_) - vec3.m_7094_());
        Quaternionf quaternion = new Quaternionf((Quaternionfc)pRenderInfo.m_253121_());
        if (this.f_107231_ != 0.0f) {
            float f3 = Mth.m_14179_((float)pPartialTicks, (float)this.f_107204_, (float)this.f_107231_);
            quaternion.rotateZ(f3);
        }
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float f4 = this.m_5902_(pPartialTicks);
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.rotate((Quaternionfc)quaternion);
            vector3f.mul(f4);
            vector3f.add(f, f1, f2);
        }
        float f7 = this.m_5970_();
        float f8 = this.m_5952_();
        float f5 = this.m_5951_();
        float f6 = this.m_5950_();
        int j = this.m_6355_(pPartialTicks);
        pBuffer.m_5483_((double)avector3f[0].x(), (double)avector3f[0].y(), (double)avector3f[0].z()).m_7421_(f8, f6).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        pBuffer.m_5483_((double)avector3f[1].x(), (double)avector3f[1].y(), (double)avector3f[1].z()).m_7421_(f8, f5).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        pBuffer.m_5483_((double)avector3f[2].x(), (double)avector3f[2].y(), (double)avector3f[2].z()).m_7421_(f7, f5).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        pBuffer.m_5483_((double)avector3f[3].x(), (double)avector3f[3].y(), (double)avector3f[3].z()).m_7421_(f7, f6).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        RenderSystem.enableDepthTest();
    }

    public void m_5989_() {
        super.m_5989_();
        this.m_108339_(this.sprites);
        if (!this.f_107220_) {
            float lifeProgress = (float)this.f_107224_ / (float)this.f_107225_;
            float flicker = 1.0f - this.f_107223_.m_188501_() * 0.3f;
            this.f_107230_ = Mth.m_14036_((float)(flicker * (1.0f - lifeProgress * lifeProgress)), (float)0.0f, (float)1.0f);
            this.f_107663_ = this.initialQuadSize * (0.9f + this.f_107223_.m_188501_() * 0.2f);
            if (((Boolean)Config.CLIENT.enablePlasmaSmokeTrail.get()).booleanValue() && this.f_107224_ > 2 && (double)this.f_107223_.m_188501_() < (Double)Config.CLIENT.plasmaSmokeFrequency.get()) {
                int smokeCount = (Integer)Config.CLIENT.plasmaSmokeCount.get();
                for (int i = 0; i < smokeCount; ++i) {
                    this.f_107208_.m_7106_((ParticleOptions)new SmokeParticleOptions(0.5f, 200, 0.6f, 0.6f, 0.6f, 0.4f, false, null), this.f_107212_, this.f_107213_, this.f_107214_, (this.f_107223_.m_188500_() - 0.5) * 0.03, (this.f_107223_.m_188500_() - 0.5) * 0.03, (this.f_107223_.m_188500_() - 0.5) * 0.03);
                }
            }
        }
    }

    public static class Provider
    implements ParticleProvider<PlasmaParticleOptions> {
        private final SpriteSet sprites;

        public Provider(SpriteSet pSprites) {
            this.sprites = pSprites;
        }

        public Particle createParticle(PlasmaParticleOptions pType, ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            return new PlasmaParticle(pLevel, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed, pType, this.sprites);
        }
    }
}

