/*
 * Decompiled with CFR 0.152.
 */
package com.vinlanx.explosionoverhaul.client;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class ShockwaveEffect {
    private final ClientLevel level;
    private final Vec3 position;
    private final float power;
    private final Random random = new Random();
    private int age = 0;
    private final int maxAge;
    private final float maxRadius;
    private final int particlesPerTick;
    private final float shellThickness;
    private boolean finished = false;

    public ShockwaveEffect(Vec3 position, float power) {
        this.level = Minecraft.m_91087_().f_91073_;
        this.position = position;
        this.power = power;
        float powerFraction = Mth.m_184655_((float)this.power, (float)5.0f, (float)100.0f);
        this.maxAge = (int)Mth.m_14179_((float)powerFraction, (float)4.0f, (float)7.0f);
        float fireballPowerFraction = Mth.m_14036_((float)power, (float)1.0f, (float)100.0f) / 100.0f;
        float fireballRadius = Mth.m_14179_((float)fireballPowerFraction, (float)3.0f, (float)40.0f);
        float normalizedPowerSqrt = Mth.m_184655_((float)((float)Math.sqrt(power)), (float)((float)Math.sqrt(5.0)), (float)((float)Math.sqrt(100.0)));
        float shockwaveMultiplier = Mth.m_14179_((float)normalizedPowerSqrt, (float)2.0f, (float)8.0f);
        this.maxRadius = fireballRadius * shockwaveMultiplier * 3.0f;
        this.particlesPerTick = (int)Mth.m_14179_((float)powerFraction, (float)70.0f, (float)400.0f);
        this.shellThickness = Mth.m_14179_((float)powerFraction, (float)0.5f, (float)4.0f);
    }

    public void tick() {
        if (this.finished || this.level == null) {
            return;
        }
        ++this.age;
        if (this.age > this.maxAge) {
            this.finished = true;
            return;
        }
        float progress = (float)this.age / (float)this.maxAge;
        float easedProgress = Mth.m_14031_((float)(progress * (float)Math.PI / 2.0f));
        float currentRadius = this.maxRadius * easedProgress;
        for (int i = 0; i < this.particlesPerTick; ++i) {
            double u = this.random.nextDouble();
            double v = this.random.nextDouble();
            double theta = Math.PI * 2 * u;
            double phi = Math.acos(2.0 * v - 1.0);
            float radiusOffset = (this.random.nextFloat() - 0.5f) * this.shellThickness;
            float finalRadius = currentRadius + radiusOffset;
            if (finalRadius < 0.0f) {
                finalRadius = 0.0f;
            }
            Vec3 particlePos = this.position.m_82520_((double)finalRadius * Math.sin(phi) * Math.cos(theta), (double)finalRadius * Math.sin(phi) * Math.sin(theta), (double)finalRadius * Math.cos(phi));
            this.level.m_6493_((ParticleOptions)ParticleTypes.f_123813_, true, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 0.0, 0.0, 0.0);
        }
    }

    public boolean isFinished() {
        return this.finished;
    }
}

