/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.critterarmory.init;

import java.util.EnumMap;
import java.util.Map;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorMaterials;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.item.equipment.EquipmentAsset;
import net.minecraft.world.item.equipment.EquipmentAssets;

public class ModMaterials {

    public static interface MobArmor {
        public static final Map.Entry<ArmorMaterial, String> IRON = MobArmor.copy(ArmorMaterials.IRON);
        public static final Map.Entry<ArmorMaterial, String> GOLD = MobArmor.copy(ArmorMaterials.GOLD, "golden");
        public static final Map.Entry<ArmorMaterial, String> DIAMOND = MobArmor.copy(ArmorMaterials.DIAMOND);
        public static final Map.Entry<ArmorMaterial, String> NETHERITE = MobArmor.copy(ArmorMaterials.NETHERITE);

        private static EnumMap<ArmorType, Integer> createMap(int[] values) {
            EnumMap<ArmorType, Integer> enumMap = new EnumMap<ArmorType, Integer>(ArmorType.class);
            for (int i = 0; i < values.length; ++i) {
                enumMap.put(ArmorType.values()[i], values[i]);
            }
            return enumMap;
        }

        private static ResourceKey<EquipmentAsset> createAsset(String name) {
            return ResourceKey.create((ResourceKey)EquipmentAssets.ROOT_ID, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"critterarmory", (String)name));
        }

        private static Map.Entry<ArmorMaterial, String> copy(ArmorMaterial material) {
            return MobArmor.register(new ArmorMaterial(material.durability(), material.defense(), material.enchantmentValue(), material.equipSound(), material.toughness(), material.knockbackResistance(), material.repairIngredient(), MobArmor.createAsset(material.assetId().location().getPath())));
        }

        private static Map.Entry<ArmorMaterial, String> copy(ArmorMaterial material, String name) {
            return MobArmor.register(MobArmor.copy(material).getKey(), name);
        }

        private static Map.Entry<ArmorMaterial, String> register(ArmorMaterial material) {
            return MobArmor.register(material, material.assetId().location().getPath());
        }

        private static Map.Entry<ArmorMaterial, String> register(ArmorMaterial material, String name) {
            return Map.entry(material, name);
        }
    }
}

