/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.critterarmory.layer;

import com.jahirtrap.critterarmory.init.ModModelLayers;
import com.jahirtrap.critterarmory.util.CommonUtils;
import com.jahirtrap.critterarmory.util.RenderStates;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.CatModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.CatRenderState;
import net.minecraft.client.renderer.entity.state.FelineRenderState;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.EquipmentAsset;
import net.minecraft.world.item.equipment.Equippable;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CatArmorLayer
extends RenderLayer<CatRenderState, CatModel> {
    private final CatModel adultModel;
    private final CatModel babyModel;

    public CatArmorLayer(RenderLayerParent<CatRenderState, CatModel> layerParent, EntityModelSet modelSet) {
        super(layerParent);
        this.adultModel = new CatModel(modelSet.bakeLayer(ModModelLayers.CAT_ARMOR));
        this.babyModel = new CatModel(modelSet.bakeLayer(ModModelLayers.CAT_BABY_ARMOR));
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int i, CatRenderState renderState, float f, float g) {
        if (renderState instanceof RenderStates.Cat) {
            RenderStates.Cat armorRenderState = (RenderStates.Cat)renderState;
            ItemStack stack = armorRenderState.bodyArmorItem;
            Equippable equippable = (Equippable)stack.get(DataComponents.EQUIPPABLE);
            if (equippable != null && equippable.assetId().isPresent()) {
                CatModel model = armorRenderState.isBaby ? this.babyModel : this.adultModel;
                model.setupAnim((FelineRenderState)armorRenderState);
                CommonUtils.renderArmor((ResourceKey<EquipmentAsset>)((ResourceKey)equippable.assetId().get()), (Model)model, stack, poseStack, bufferSource, i);
            }
        }
    }
}

