/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.critterarmory.layer;

import com.jahirtrap.critterarmory.init.ModModelLayers;
import com.jahirtrap.critterarmory.util.CommonUtils;
import com.jahirtrap.critterarmory.util.RenderStates;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.CowModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.entity.state.MushroomCowRenderState;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.EquipmentAsset;
import net.minecraft.world.item.equipment.Equippable;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MushroomCowArmorLayer
extends RenderLayer<MushroomCowRenderState, CowModel> {
    private final CowModel adultModel;
    private final CowModel babyModel;

    public MushroomCowArmorLayer(RenderLayerParent<MushroomCowRenderState, CowModel> layerParent, EntityModelSet modelSet) {
        super(layerParent);
        this.adultModel = new CowModel(modelSet.bakeLayer(ModModelLayers.COW_ARMOR));
        this.babyModel = new CowModel(modelSet.bakeLayer(ModModelLayers.COW_BABY_ARMOR));
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int i, MushroomCowRenderState renderState, float f, float g) {
        if (renderState instanceof RenderStates.MushroomCow) {
            RenderStates.MushroomCow armorRenderState = (RenderStates.MushroomCow)renderState;
            ItemStack stack = armorRenderState.bodyArmorItem;
            Equippable equippable = (Equippable)stack.get(DataComponents.EQUIPPABLE);
            if (equippable != null && equippable.assetId().isPresent()) {
                CowModel model = armorRenderState.isBaby ? this.babyModel : this.adultModel;
                model.setupAnim((LivingEntityRenderState)armorRenderState);
                CommonUtils.renderArmor((ResourceKey<EquipmentAsset>)((ResourceKey)equippable.assetId().get()), (Model)model, stack, poseStack, bufferSource, i);
            }
        }
    }
}

