/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.critterarmory.layer;

import com.jahirtrap.critterarmory.init.ModModelLayers;
import com.jahirtrap.critterarmory.util.CommonUtils;
import com.jahirtrap.critterarmory.util.RenderStates;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.SheepModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.SheepRenderState;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.EquipmentAsset;
import net.minecraft.world.item.equipment.Equippable;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SheepArmorLayer
extends RenderLayer<SheepRenderState, SheepModel> {
    private final SheepModel adultModel;
    private final SheepModel babyModel;

    public SheepArmorLayer(RenderLayerParent<SheepRenderState, SheepModel> layerParent, EntityModelSet modelSet) {
        super(layerParent);
        this.adultModel = new SheepModel(modelSet.bakeLayer(ModModelLayers.SHEEP_ARMOR));
        this.babyModel = new SheepModel(modelSet.bakeLayer(ModModelLayers.SHEEP_BABY_ARMOR));
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int i, SheepRenderState renderState, float f, float g) {
        if (renderState instanceof RenderStates.Sheep) {
            RenderStates.Sheep armorRenderState = (RenderStates.Sheep)renderState;
            ItemStack stack = armorRenderState.bodyArmorItem;
            Equippable equippable = (Equippable)stack.get(DataComponents.EQUIPPABLE);
            if (equippable != null && equippable.assetId().isPresent()) {
                SheepModel model = armorRenderState.isBaby ? this.babyModel : this.adultModel;
                model.setupAnim((SheepRenderState)armorRenderState);
                CommonUtils.renderArmor((ResourceKey<EquipmentAsset>)((ResourceKey)equippable.assetId().get()), (Model)model, stack, poseStack, bufferSource, i);
            }
        }
    }
}

