/*
 * Decompiled with CFR 0.152.
 */
package com.jahirtrap.critterarmory.util;

import com.jahirtrap.critterarmory.init.ModConfig;
import com.jahirtrap.critterarmory.init.ModContent;
import com.jahirtrap.critterarmory.init.ModTags;
import com.jahirtrap.critterarmory.item.BaseAnimalArmorItem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.EquipmentAsset;

public class CommonUtils {
    private static final Map<TagKey<Item>, String> entityArmorMap = new HashMap<TagKey<Item>, String>();

    public static void addArmorType(TagKey<Item> key, String value) {
        entityArmorMap.put(key, value);
    }

    public static String getArmorType(ItemStack stack) {
        return entityArmorMap.entrySet().stream().filter(entry -> stack.is((TagKey)entry.getKey())).map(Map.Entry::getValue).findFirst().orElse("");
    }

    public static void renderArmor(ResourceKey<EquipmentAsset> resourceKey, Model model, ItemStack stack, PoseStack poseStack, MultiBufferSource bufferSource, int i) {
        if (!ModConfig.renderArmors || !ModConfig.renderCatArmors && stack.is(ModTags.Items.CAT_ARMOR) || !ModConfig.renderChickenArmors && stack.is(ModTags.Items.CHICKEN_ARMOR) || !ModConfig.renderCowArmors && stack.is(ModTags.Items.COW_ARMOR) || !ModConfig.renderPigArmors && stack.is(ModTags.Items.PIG_ARMOR) || !ModConfig.renderSheepArmors && stack.is(ModTags.Items.SHEEP_ARMOR)) {
            return;
        }
        String type = CommonUtils.getArmorType(stack);
        if (!type.isBlank()) {
            VertexConsumer consumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)resourceKey.location().withPath(path -> "textures/entity/equipment/" + type + "/" + path + ".png")));
            model.renderToBuffer(poseStack, consumer, i, OverlayTexture.NO_OVERLAY);
        }
    }

    public static boolean feedEntity(Player player, InteractionHand hand, Animal entity) {
        if (!entity.level().isClientSide()) {
            ItemStack stack = player.getItemInHand(hand);
            if (stack.is(ModContent.BALANCED_FEED) && entity.getHealth() < entity.getMaxHealth()) {
                entity.usePlayerItem(player, hand, stack);
                entity.heal((float)ModConfig.healAmount);
                return true;
            }
            if (stack.is(ModContent.VITALITY_FEED)) {
                int healthLimit = ModConfig.healthIncreaseLimit;
                if (entity.getMaxHealth() < (float)healthLimit || entity.getHealth() < entity.getMaxHealth()) {
                    entity.usePlayerItem(player, hand, stack);
                    if (entity.getMaxHealth() < (float)healthLimit) {
                        entity.getAttribute(Attributes.MAX_HEALTH).setBaseValue((double)Math.min(entity.getMaxHealth() + (float)ModConfig.healthIncreaseAmount, (float)healthLimit));
                        entity.playSound(SoundEvents.PLAYER_LEVELUP);
                    }
                    entity.setHealth(entity.getMaxHealth());
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean canWearArmor(LivingEntity entity) {
        return Arrays.stream(BaseAnimalArmorItem.BodyType.values()).flatMap(bodyType -> bodyType.allowedEntities.stream()).anyMatch(holder -> holder.value() == entity.getType());
    }

    public static boolean canFeed(LivingEntity entity) {
        return CommonUtils.canWearArmor(entity);
    }

    static {
        CommonUtils.addArmorType(ModTags.Items.CAT_ARMOR, "cat_body");
        CommonUtils.addArmorType(ModTags.Items.CHICKEN_ARMOR, "chicken_body");
        CommonUtils.addArmorType(ModTags.Items.COW_ARMOR, "cow_body");
        CommonUtils.addArmorType(ModTags.Items.PIG_ARMOR, "pig_body");
        CommonUtils.addArmorType(ModTags.Items.SHEEP_ARMOR, "sheep_body");
    }
}

