/*
 * Decompiled with CFR 0.152.
 */
package org.hendrix.betterspringtolife.entity;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.function.IntFunction;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1266;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1331;
import net.minecraft.class_1347;
import net.minecraft.class_1348;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1391;
import net.minecraft.class_1395;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_1432;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2397;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_3730;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5534;
import net.minecraft.class_5819;
import net.minecraft.class_7;
import net.minecraft.class_7995;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9331;
import net.minecraft.class_9473;
import org.hendrix.betterspringtolife.core.BSTLDataComponentTypes;
import org.hendrix.betterspringtolife.core.BSTLTags;
import org.jetbrains.annotations.Nullable;

public final class ButterflyEntity
extends class_1314
implements class_1432 {
    private static final class_2940<Integer> VARIANT = class_2945.method_12791(ButterflyEntity.class, (class_2941)class_2943.field_13327);
    public float flapProgress;
    public float lastFlapProgress;
    public float maxWingDeviation;
    public float lastMaxWingDeviation;
    private float flapSpeed = 1.0f;
    private float currentFlapSpeed = 1.0f;

    public ButterflyEntity(class_1299<? extends class_1314> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6207 = new class_1331((class_1308)this, 10, false);
        this.method_5941(class_7.field_9, -1.0f);
        this.method_5941(class_7.field_3, -1.0f);
        this.method_5941(class_7.field_21516, -1.0f);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1391((class_1314)this, 1.25, itemStack -> itemStack.method_31573(class_3489.field_15543), false));
        this.field_6201.method_6277(2, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(3, (class_1352)new FlyOntoTreeGoal(this, 1.0));
        this.field_6201.method_6277(4, (class_1352)new class_1348((class_1308)this, 1.0, 3.0f, 7.0f));
    }

    public float method_6144(class_2338 pos, class_4538 world) {
        return world.method_8320(pos).method_26215() ? 10.0f : 0.0f;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(VARIANT, (Object)Variant.DEFAULT.index);
    }

    public void method_5652(class_11372 nbt) {
        super.method_5652(nbt);
        nbt.method_71468("Variant", Variant.INDEX_CODEC, (Object)this.getVariant());
    }

    public void method_5749(class_11368 nbt) {
        super.method_5749(nbt);
        this.setVariant(nbt.method_71426("Variant", Variant.INDEX_CODEC).orElse(Variant.DEFAULT));
    }

    public Variant getVariant() {
        return Variant.byIndex((Integer)this.field_6011.method_12789(VARIANT));
    }

    private void setVariant(Variant variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant.index);
    }

    protected void method_66649(class_9473 from) {
        this.method_66650(from, BSTLDataComponentTypes.BUTTERFLY_VARIANT);
        super.method_66649(from);
    }

    protected <T> boolean method_66654(class_9331<T> type, T value) {
        if (BSTLDataComponentTypes.BUTTERFLY_VARIANT.equals(type)) {
            this.setVariant((Variant)((Object)ButterflyEntity.method_66651(BSTLDataComponentTypes.BUTTERFLY_VARIANT, value)));
            return true;
        }
        return super.method_66654(type, value);
    }

    public static class_5132.class_5133 createButterflyAttributes() {
        return class_1429.method_61457().method_26868(class_5134.field_23716, 1.0).method_26868(class_5134.field_23720, (double)0.4f).method_26868(class_5134.field_23719, (double)0.2f).method_26868(class_5134.field_23721, 1.0);
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        this.setVariant((Variant)((Object)class_156.method_27173((Object[])Variant.values(), (class_5819)world.method_8409())));
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    protected class_1408 method_5965(class_1937 world) {
        class_1407 birdNavigation = new class_1407((class_1308)this, world);
        birdNavigation.method_70687(false);
        birdNavigation.method_6354(true);
        return birdNavigation;
    }

    public void method_6007() {
        super.method_6007();
        this.flapWings();
    }

    private void flapWings() {
        this.lastFlapProgress = this.flapProgress;
        this.lastMaxWingDeviation = this.maxWingDeviation;
        this.maxWingDeviation += (float)(!this.method_24828() && !this.method_5765() ? 4 : -1) * 0.3f;
        this.maxWingDeviation = class_3532.method_15363((float)this.maxWingDeviation, (float)0.0f, (float)1.0f);
        if (!this.method_24828() && this.flapSpeed < 1.0f) {
            this.flapSpeed = 1.0f;
        }
        this.flapSpeed *= 0.5f;
        class_243 velocity = this.method_18798();
        if (!this.method_24828() && velocity.field_1351 < 0.0) {
            this.method_18799(velocity.method_18805(1.0, 0.6, 1.0));
        }
        this.flapProgress += this.flapSpeed * 2.0f;
    }

    protected void method_5623(double heightDifference, boolean onGround, class_2680 state, class_2338 landedPosition) {
    }

    protected boolean method_5776() {
        return this.field_28627 > this.currentFlapSpeed;
    }

    protected void method_5801() {
        this.currentFlapSpeed = this.field_28627 + this.maxWingDeviation / 2.0f;
    }

    public boolean method_5810() {
        return true;
    }

    protected void method_6087(class_1297 entity) {
        if (!(entity instanceof class_1657)) {
            super.method_6087(entity);
        }
    }

    public boolean method_6581() {
        return !this.method_24828();
    }

    public static boolean canSpawn(class_1299<ButterflyEntity> type, class_1936 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return world.method_8320(pos.method_10074()).method_26164(BSTLTags.BlockTags.BUTTERFLIES_SPAWNABLE_ON) && world.method_22335(pos, 0) > 8;
    }

    static class FlyOntoTreeGoal
    extends class_1395 {
        public FlyOntoTreeGoal(class_1314 pathAwareEntity, double speed) {
            super(pathAwareEntity, speed);
        }

        @Nullable
        protected class_243 method_6302() {
            class_243 target = null;
            if (this.field_6566.method_5799()) {
                target = class_5534.method_31527((class_1314)this.field_6566, (int)15, (int)15);
            }
            if (this.field_6566.method_59922().method_43057() >= this.field_6626) {
                target = this.locateTree();
            }
            return target == null ? super.method_6302() : target;
        }

        @Nullable
        private class_243 locateTree() {
            class_2338 blockPos = this.field_6566.method_24515();
            class_2338.class_2339 mutable = new class_2338.class_2339();
            class_2338.class_2339 mutable2 = new class_2338.class_2339();
            for (class_2338 pos : class_2338.method_10094((int)class_3532.method_15357((double)(this.field_6566.method_23317() - 3.0)), (int)class_3532.method_15357((double)(this.field_6566.method_23318() - 6.0)), (int)class_3532.method_15357((double)(this.field_6566.method_23321() - 3.0)), (int)class_3532.method_15357((double)(this.field_6566.method_23317() + 3.0)), (int)class_3532.method_15357((double)(this.field_6566.method_23318() + 6.0)), (int)class_3532.method_15357((double)(this.field_6566.method_23321() + 3.0)))) {
                class_2680 blockState;
                if (blockPos.equals((Object)pos) || !((blockState = this.field_6566.method_73183().method_8320((class_2338)mutable2.method_25505((class_2382)pos, class_2350.field_11033))).method_26204() instanceof class_2397) && !blockState.method_26164(class_3481.field_15475) || !this.field_6566.method_73183().method_22347(pos) || !this.field_6566.method_73183().method_22347((class_2338)mutable.method_25505((class_2382)pos, class_2350.field_11036))) continue;
                return class_243.method_24955((class_2382)pos);
            }
            return null;
        }
    }

    public static enum Variant implements class_3542
    {
        RED(0, "red"),
        BLUE(1, "blue"),
        ORANGE(2, "orange"),
        PURPLE(3, "purple"),
        WHITE(4, "white");

        public static final Variant DEFAULT;
        private static final IntFunction<Variant> INDEX_MAPPER;
        public static final Codec<Variant> CODEC;
        public static final Codec<Variant> INDEX_CODEC;
        public static final class_9139<ByteBuf, Variant> PACKET_CODEC;
        final int index;
        private final String name;

        private Variant(int index, String name) {
            this.index = index;
            this.name = name;
        }

        public int getIndex() {
            return this.index;
        }

        public static Variant byIndex(int index) {
            return INDEX_MAPPER.apply(index);
        }

        public String method_15434() {
            return this.name;
        }

        static {
            DEFAULT = RED;
            INDEX_MAPPER = class_7995.method_47914(Variant::getIndex, (Object[])Variant.values(), (class_7995.class_7996)class_7995.class_7996.field_41666);
            CODEC = class_3542.method_28140(Variant::values);
            INDEX_CODEC = Codec.INT.xmap(INDEX_MAPPER::apply, Variant::getIndex);
            PACKET_CODEC = class_9135.method_56375(INDEX_MAPPER, Variant::getIndex);
        }
    }
}

