/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.client.renderer;

import com.github.mechalopa.hmag.client.ModModelLayers;
import com.github.mechalopa.hmag.client.model.BansheeModel;
import com.github.mechalopa.hmag.client.renderer.AbstractGirlRenderer;
import com.github.mechalopa.hmag.client.renderer.layers.BansheeLayer;
import com.github.mechalopa.hmag.client.util.ModClientUtils;
import com.github.mechalopa.hmag.world.entity.BansheeEntity;
import com.github.mechalopa.hmag.world.entity.CommonOrUncommonVariant;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BansheeRenderer
extends AbstractGirlRenderer<BansheeEntity, BansheeModel<BansheeEntity>> {
    private static final Map<CommonOrUncommonVariant, ResourceLocation> TEXTURES = (Map)Util.m_137469_((Object)Maps.newEnumMap(CommonOrUncommonVariant.class), p -> {
        p.put(CommonOrUncommonVariant.COMMON, ModClientUtils.getHMaGEntityTexture("banshee/banshee_0"));
        p.put(CommonOrUncommonVariant.UNCOMMON, ModClientUtils.getHMaGEntityTexture("banshee/banshee_1"));
    });

    public BansheeRenderer(EntityRendererProvider.Context context) {
        super(context, new BansheeModel(context.m_174023_(ModModelLayers.BANSHEE)), 0.375f);
        this.m_115326_(new BansheeLayer((RenderLayerParent<BansheeEntity, BansheeModel<BansheeEntity>>)this, context.m_174027_()));
    }

    protected void scale(BansheeEntity entity, PoseStack poseStack, float partialTickTime) {
        super.m_7546_((LivingEntity)entity, poseStack, partialTickTime);
        float f = (float)entity.f_19797_ + partialTickTime;
        poseStack.m_252880_(0.0f, -0.06f + Mth.m_14031_((float)(f * 0.06f)) * 0.04f, 0.0f);
    }

    protected void setupRotations(BansheeEntity entity, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTicks) {
        super.m_7523_((LivingEntity)entity, poseStack, ageInTicks, rotationYaw, partialTicks);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(-6.0f));
    }

    protected int getBlockLightLevel(BansheeEntity entity, BlockPos pos) {
        return 15;
    }

    public ResourceLocation getTextureLocation(BansheeEntity entity) {
        return TEXTURES.getOrDefault((Object)entity.getVariant(), TEXTURES.get((Object)CommonOrUncommonVariant.COMMON));
    }
}

