/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.client.renderer;

import com.github.mechalopa.hmag.client.ModModelLayers;
import com.github.mechalopa.hmag.client.model.GhostModel;
import com.github.mechalopa.hmag.client.renderer.layers.GhostClothingLayer;
import com.github.mechalopa.hmag.client.util.ModClientUtils;
import com.github.mechalopa.hmag.world.entity.GhostEntity;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GhostRenderer
extends HumanoidMobRenderer<GhostEntity, GhostModel<GhostEntity>> {
    private static final Map<GhostEntity.Variant, ResourceLocation> TEXTURES = (Map)Util.m_137469_((Object)Maps.newEnumMap(GhostEntity.Variant.class), p -> {
        p.put(GhostEntity.Variant.VARIANT_0, ModClientUtils.getHMaGEntityTexture("ghost/ghost_0"));
        p.put(GhostEntity.Variant.VARIANT_1, ModClientUtils.getHMaGEntityTexture("ghost/ghost_1"));
        p.put(GhostEntity.Variant.VARIANT_2, ModClientUtils.getHMaGEntityTexture("ghost/ghost_2"));
        p.put(GhostEntity.Variant.VARIANT_3, ModClientUtils.getHMaGEntityTexture("ghost/ghost_3"));
        p.put(GhostEntity.Variant.VARIANT_4, ModClientUtils.getHMaGEntityTexture("ghost/ghost_4"));
    });

    public GhostRenderer(EntityRendererProvider.Context context) {
        this(context, ModModelLayers.GHOST, ModModelLayers.GHOST_INNER_ARMOR, ModModelLayers.GHOST_OUTER_ARMOR);
    }

    public GhostRenderer(EntityRendererProvider.Context context, ModelLayerLocation location, ModelLayerLocation location1, ModelLayerLocation location2) {
        this(context, new GhostModel<GhostEntity>(context.m_174023_(location)), new GhostModel<GhostEntity>(context.m_174023_(location1)), new GhostModel<GhostEntity>(context.m_174023_(location2)));
    }

    public GhostRenderer(EntityRendererProvider.Context context, GhostModel<GhostEntity> model, GhostModel<GhostEntity> model1, GhostModel<GhostEntity> model2) {
        super(context, model, 0.375f);
        this.m_115326_((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, model1, model2, context.m_266367_()));
        this.m_115326_(this.getLayer(context));
    }

    protected int getBlockLightLevel(GhostEntity entity, BlockPos pos) {
        return 15;
    }

    public ResourceLocation getTextureLocation(GhostEntity entity) {
        return TEXTURES.getOrDefault((Object)entity.getVariant(), TEXTURES.get((Object)GhostEntity.Variant.VARIANT_0));
    }

    public GhostClothingLayer getLayer(EntityRendererProvider.Context context) {
        return new GhostClothingLayer((RenderLayerParent<GhostEntity, GhostModel<GhostEntity>>)this, context.m_174027_());
    }
}

