/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.client.renderer;

import com.github.mechalopa.hmag.client.ModModelLayers;
import com.github.mechalopa.hmag.client.model.ModShieldModel;
import com.github.mechalopa.hmag.client.util.ModClientUtils;
import com.github.mechalopa.hmag.registry.ModItems;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModBlockEntityWithoutLevelRenderer
extends BlockEntityWithoutLevelRenderer {
    private static final ResourceLocation ANCIENT_SHIELD_TEXTURE = ModClientUtils.getHMaGEntityTexture("shield/ancient_shield");
    private static final ResourceLocation FORTRESS_SHIELD_TEXTURE = ModClientUtils.getHMaGEntityTexture("shield/fortress_shield");
    private ModShieldModel ancientShieldModel;
    private ModShieldModel fortressShieldModel;

    public ModBlockEntityWithoutLevelRenderer(BlockEntityRenderDispatcher renderDispatcher, EntityModelSet modelSet) {
        super(renderDispatcher, modelSet);
        this.ancientShieldModel = new ModShieldModel(modelSet.m_171103_(ModModelLayers.ANCIENT_SHIELD));
        this.fortressShieldModel = new ModShieldModel(modelSet.m_171103_(ModModelLayers.FORTRESS_SHIELD));
    }

    public void m_108829_(ItemStack stack, ItemDisplayContext type, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        Item item = stack.m_41720_();
        if (item == ModItems.ANCIENT_SHIELD.get()) {
            ModBlockEntityWithoutLevelRenderer.drawShieldModel(stack, type, poseStack, buffer, packedLight, packedOverlay, ANCIENT_SHIELD_TEXTURE, this.ancientShieldModel);
        } else if (item == ModItems.FORTRESS_SHIELD.get()) {
            ModBlockEntityWithoutLevelRenderer.drawShieldModel(stack, type, poseStack, buffer, packedLight, packedOverlay, FORTRESS_SHIELD_TEXTURE, this.fortressShieldModel);
        }
    }

    private static void drawShieldModel(ItemStack stack, ItemDisplayContext type, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay, ResourceLocation resource, ModShieldModel model) {
        poseStack.m_85836_();
        poseStack.m_85841_(1.0f, -1.0f, -1.0f);
        VertexConsumer vertexconsumer = ItemRenderer.m_115222_((MultiBufferSource)buffer, (RenderType)model.m_103119_(resource), (boolean)false, (boolean)stack.m_41790_());
        model.m_7695_(poseStack, vertexconsumer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }
}

