/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.client.renderer.layers;

import com.github.mechalopa.hmag.client.ModModelLayers;
import com.github.mechalopa.hmag.client.model.MeltyMonsterModel;
import com.github.mechalopa.hmag.client.util.ModClientUtils;
import com.github.mechalopa.hmag.world.entity.MeltyMonsterEntity;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MeltyMonsterMagmaLayer
extends RenderLayer<MeltyMonsterEntity, MeltyMonsterModel<MeltyMonsterEntity>> {
    private static final ResourceLocation TEXTURE = ModClientUtils.getHMaGEntityTexture("melty_monster/melty_monster_overlay");
    private final MeltyMonsterModel<MeltyMonsterEntity> layerModel;

    public MeltyMonsterMagmaLayer(RenderLayerParent<MeltyMonsterEntity, MeltyMonsterModel<MeltyMonsterEntity>> renderLayerParent, EntityModelSet modelSet) {
        super(renderLayerParent);
        this.layerModel = new MeltyMonsterModel(modelSet.m_171103_(ModModelLayers.MELTY_MONSTER_OUTER_LAYER));
        this.layerModel.setLayer(true);
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, MeltyMonsterEntity livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean flag;
        Minecraft minecraft = Minecraft.m_91087_();
        boolean bl = flag = minecraft.m_91314_((Entity)livingEntity) && livingEntity.m_20145_();
        if (!livingEntity.m_20145_() || flag) {
            float f = (float)livingEntity.f_19797_ + partialTicks;
            ((MeltyMonsterModel)this.m_117386_()).m_102872_(this.layerModel);
            this.layerModel.m_6839_((LivingEntity)livingEntity, limbSwing, limbSwingAmount, partialTicks);
            this.layerModel.setupAnim(livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            ResourceLocation resourcelocation = this.getLayerTexture(livingEntity);
            VertexConsumer vertexconsumer = flag ? buffer.m_6299_(RenderType.m_110491_((ResourceLocation)resourcelocation)) : buffer.m_6299_(MeltyMonsterMagmaLayer.getMeltyMonsterOverlay(resourcelocation, 0.0f, f * -0.001f));
            this.layerModel.m_7695_(poseStack, vertexconsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public ResourceLocation getLayerTexture(MeltyMonsterEntity entity) {
        return TEXTURE;
    }

    public static RenderType getMeltyMonsterOverlay(ResourceLocation location, float xOffs, float yOffs) {
        RenderStateShard.TransparencyStateShard transparencyState = new RenderStateShard.TransparencyStateShard("translucent_transparency", () -> {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        }, () -> {
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
        });
        RenderType.CompositeState renderTypeState = RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(GameRenderer::m_172703_)).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(location, false, false)).m_110683_((RenderStateShard.TexturingStateShard)new RenderStateShard.OffsetTexturingStateShard(xOffs, yOffs)).m_110685_(transparencyState).m_110661_(new RenderStateShard.CullStateShard(false)).m_110671_(new RenderStateShard.LightmapStateShard(true)).m_110677_(new RenderStateShard.OverlayStateShard(true)).m_110691_(false);
        return RenderType.m_173215_((String)"melty_monster_overlay", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)renderTypeState);
    }
}

