/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.util;

import com.github.mechalopa.hmag.ModConfigs;
import com.github.mechalopa.hmag.util.ModUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;

public class ModSpawnRules {
    public static boolean checkMonsterSpawnCanSeeSkyRules(EntityType<? extends Monster> type, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return Monster.m_219013_(type, (ServerLevelAccessor)levelAccessor, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random) && (spawnType == MobSpawnType.SPAWNER || levelAccessor.m_45527_(pos));
    }

    public static boolean checkMonsterSpawnCanNotSeeSkyRules(EntityType<? extends Monster> type, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return Monster.m_219013_(type, (ServerLevelAccessor)levelAccessor, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random) && (spawnType == MobSpawnType.SPAWNER || !levelAccessor.m_45527_(pos));
    }

    public static boolean checkSurfaceMonsterSpawnRules(EntityType<? extends Monster> type, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return Monster.m_219013_(type, (ServerLevelAccessor)levelAccessor, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random) && (spawnType == MobSpawnType.SPAWNER || pos.m_123342_() >= ModConfigs.cachedServer.SURFACE_MOB_SPAWN_MIN_HEIGHT);
    }

    public static boolean checkMobSpawnInLightRules(EntityType<? extends Mob> type, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return levelAccessor.m_46791_() != Difficulty.PEACEFUL && ModUtils.isDarkEnoughToSpawn(levelAccessor, pos, random) && Mob.m_217057_(type, (LevelAccessor)levelAccessor, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }
}

