/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.world.entity;

import com.github.mechalopa.hmag.util.ModUtils;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public abstract class AbstractFlyingMonsterEntity
extends Monster {
    protected static final EntityDataAccessor<Byte> ATTACK_PHASE = SynchedEntityData.m_135353_(AbstractFlyingMonsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private BlockPos boundOrigin;

    public AbstractFlyingMonsterEntity(EntityType<? extends AbstractFlyingMonsterEntity> type, Level level) {
        super(type, level);
        this.f_21342_ = new FlyingMonsterMoveControl(this);
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_20242_(true);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACK_PHASE, (Object)0);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (!this.m_9236_().m_5776_() && !this.m_21525_() && source.m_7639_() instanceof LivingEntity && this.isCharging() && this.m_217043_().m_188503_(3) == 0) {
            this.setAttackPhase(1);
        }
        return super.m_6469_(source, amount);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        compound.m_128405_("AttackPhase", this.getAttackPhase());
        if (compound.m_128441_("BoundX")) {
            this.boundOrigin = new BlockPos(compound.m_128451_("BoundX"), compound.m_128451_("BoundY"), compound.m_128451_("BoundZ"));
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        this.setAttackPhase(compound.m_128451_("AttackPhase"));
        if (this.boundOrigin != null) {
            compound.m_128405_("BoundX", this.boundOrigin.m_123341_());
            compound.m_128405_("BoundY", this.boundOrigin.m_123342_());
            compound.m_128405_("BoundZ", this.boundOrigin.m_123343_());
        }
    }

    @Nonnull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Nullable
    public BlockPos getBoundOrigin() {
        return this.boundOrigin;
    }

    public void setBoundOrigin(@Nullable BlockPos boundOriginPos) {
        this.boundOrigin = boundOriginPos;
    }

    public int getAttackPhase() {
        return ((Byte)this.f_19804_.m_135370_(ATTACK_PHASE)).byteValue();
    }

    public void setAttackPhase(int value) {
        int i = value;
        if (i < 0 || i >= 3) {
            i = 0;
        }
        this.f_19804_.m_135381_(ATTACK_PHASE, (Object)((byte)(i & 0xFF)));
    }

    public boolean isCharging() {
        return this.getAttackPhase() == 2;
    }

    protected class FlyingMonsterMoveControl
    extends MoveControl {
        public FlyingMonsterMoveControl(AbstractFlyingMonsterEntity mob) {
            super((Mob)mob);
        }

        public void m_8126_() {
            AbstractFlyingMonsterEntity flyingentity = AbstractFlyingMonsterEntity.this;
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                Vec3 vec3 = new Vec3(this.f_24975_ - flyingentity.m_20185_(), this.f_24976_ - flyingentity.m_20186_(), this.f_24977_ - flyingentity.m_20189_());
                double d0 = vec3.m_82553_();
                if (d0 < flyingentity.m_20191_().m_82309_() || !ModUtils.canReach((LivingEntity)flyingentity, vec3.m_82541_(), Mth.m_14165_((double)d0))) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                    flyingentity.m_20256_(flyingentity.m_20184_().m_82490_(0.5));
                } else {
                    float f = (float)flyingentity.m_21133_(Attributes.f_22279_);
                    flyingentity.m_20256_(flyingentity.m_20184_().m_82549_(vec3.m_82490_((double)((float)this.f_24978_ * f) * 0.2 / d0)));
                    if (flyingentity.m_5448_() == null) {
                        Vec3 vec31 = flyingentity.m_20184_();
                        flyingentity.m_146922_(-((float)Mth.m_14136_((double)vec31.f_82479_, (double)vec31.f_82481_)) * 57.295776f);
                        flyingentity.f_20883_ = flyingentity.m_146908_();
                    } else {
                        double d2 = flyingentity.m_5448_().m_20185_() - flyingentity.m_20185_();
                        double d1 = flyingentity.m_5448_().m_20189_() - flyingentity.m_20189_();
                        flyingentity.m_146922_(-((float)Mth.m_14136_((double)d2, (double)d1)) * 57.295776f);
                        flyingentity.f_20883_ = flyingentity.m_146908_();
                    }
                }
            }
        }
    }

    protected class MoveRandomGoal
    extends Goal {
        private final double moveSpeed;
        private final int chance;
        private final int width;
        private final int height;

        public MoveRandomGoal() {
            this(0.25);
        }

        public MoveRandomGoal(double moveSpeed) {
            this(moveSpeed, 6, 3, 2);
        }

        public MoveRandomGoal(double moveSpeed, int chance, int width, int height) {
            this.moveSpeed = moveSpeed;
            this.chance = chance;
            this.width = width;
            this.height = height;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return !AbstractFlyingMonsterEntity.this.m_21566_().m_24995_() && AbstractFlyingMonsterEntity.this.m_217043_().m_188503_(MoveRandomGoal.m_186073_((int)this.chance)) == 0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            if (AbstractFlyingMonsterEntity.this.m_5448_() == null || !AbstractFlyingMonsterEntity.this.m_5448_().m_6084_()) {
                AbstractFlyingMonsterEntity.this.setAttackPhase(0);
            }
        }

        public void m_8037_() {
            AbstractFlyingMonsterEntity flyingentity = AbstractFlyingMonsterEntity.this;
            BlockPos blockpos = flyingentity.getBoundOrigin();
            if (blockpos == null) {
                blockpos = flyingentity.m_20183_();
            }
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos1 = blockpos.m_7918_(flyingentity.m_217043_().m_188503_(this.width * 2 + 1) - this.width, flyingentity.m_217043_().m_188503_(this.height * 2 + 1) - this.height, flyingentity.m_217043_().m_188503_(this.width * 2 + 1) - this.width);
                if (!flyingentity.m_9236_().m_46859_(blockpos1)) continue;
                flyingentity.f_21342_.m_6849_((double)blockpos1.m_123341_() + 0.5, (double)blockpos1.m_123342_() + 0.5, (double)blockpos1.m_123343_() + 0.5, this.moveSpeed);
                if (flyingentity.m_5448_() != null) break;
                flyingentity.m_21563_().m_24950_((double)blockpos1.m_123341_() + 0.5, (double)blockpos1.m_123342_() + 0.5, (double)blockpos1.m_123343_() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }

    protected class ChargeAttackGoal
    extends Goal {
        private final double moveSpeed;
        private final float attackRadius;
        private final int chance;
        protected int attackTime;

        public ChargeAttackGoal() {
            this(0.3, 2.0f);
        }

        public ChargeAttackGoal(double moveSpeed, float maxAttackDistance) {
            this(moveSpeed, maxAttackDistance, 4);
        }

        public ChargeAttackGoal(double moveSpeed, float maxAttackDistance, int chance) {
            this.moveSpeed = moveSpeed;
            this.attackRadius = maxAttackDistance;
            this.chance = chance;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (AbstractFlyingMonsterEntity.this.m_5448_() != null && AbstractFlyingMonsterEntity.this.m_5448_().m_6084_() && !AbstractFlyingMonsterEntity.this.m_21566_().m_24995_() && AbstractFlyingMonsterEntity.this.m_217043_().m_188503_(ChargeAttackGoal.m_186073_((int)this.chance)) == 0) {
                return AbstractFlyingMonsterEntity.this.m_20280_((Entity)AbstractFlyingMonsterEntity.this.m_5448_()) > (double)this.attackRadius;
            }
            return false;
        }

        public boolean m_8045_() {
            return AbstractFlyingMonsterEntity.this.m_21566_().m_24995_() && AbstractFlyingMonsterEntity.this.isCharging() && AbstractFlyingMonsterEntity.this.m_5448_() != null && AbstractFlyingMonsterEntity.this.m_5448_().m_6084_();
        }

        public void m_8056_() {
            LivingEntity livingentity = AbstractFlyingMonsterEntity.this.m_5448_();
            if (AbstractFlyingMonsterEntity.this.m_142582_((Entity)livingentity) || AbstractFlyingMonsterEntity.this.getAttackPhase() != 0) {
                Vec3 vec3 = livingentity.m_146892_();
                AbstractFlyingMonsterEntity.this.f_21342_.m_6849_(vec3.f_82479_, vec3.f_82480_ - 0.75, vec3.f_82481_, this.moveSpeed);
                AbstractFlyingMonsterEntity.this.setAttackPhase(2);
            }
        }

        public void m_8041_() {
            AbstractFlyingMonsterEntity.this.setAttackPhase(AbstractFlyingMonsterEntity.this.m_5448_() != null && AbstractFlyingMonsterEntity.this.m_5448_().m_6084_() ? 1 : 0);
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            AbstractFlyingMonsterEntity attacker = AbstractFlyingMonsterEntity.this;
            LivingEntity target = attacker.m_5448_();
            if (target != null) {
                this.attackTime = Math.max(this.attackTime - 1, 0);
                attacker.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                double d0 = attacker.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
                double d1 = this.getAttackReachSqr(target);
                if (d0 <= d1 && this.attackTime <= 0) {
                    this.attackTime = 20;
                    attacker.m_6674_(InteractionHand.MAIN_HAND);
                    attacker.m_7327_((Entity)target);
                    attacker.setAttackPhase(1);
                } else if (attacker.m_142582_((Entity)target)) {
                    if (d0 < (double)(this.attackRadius + 15.0f)) {
                        Vec3 vec3 = target.m_146892_();
                        attacker.f_21342_.m_6849_(vec3.f_82479_, vec3.f_82480_ - 0.75, vec3.f_82481_, this.moveSpeed);
                    }
                } else if (attacker.m_217043_().m_188503_(this.m_183277_(16)) == 0) {
                    attacker.setAttackPhase(0);
                }
            } else {
                attacker.setAttackPhase(0);
            }
        }

        protected double getAttackReachSqr(LivingEntity attackTarget) {
            return AbstractFlyingMonsterEntity.this.m_20205_() * 2.0f * AbstractFlyingMonsterEntity.this.m_20205_() * 2.0f + attackTarget.m_20205_();
        }
    }
}

