/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.world.entity;

import com.github.mechalopa.hmag.ModConfigs;
import com.github.mechalopa.hmag.registry.ModSoundEvents;
import com.github.mechalopa.hmag.util.ModTags;
import com.github.mechalopa.hmag.world.entity.ai.goal.MeleeAttackGoal2;
import com.github.mechalopa.hmag.world.entity.ai.goal.RangedAttackGoal2;
import com.github.mechalopa.hmag.world.entity.projectile.PoisonSeedEntity;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkHooks;

public class AlrauneEntity
extends Monster
implements RangedAttackMob {
    public AlrauneEntity(EntityType<? extends AlrauneEntity> type, Level level) {
        super(type, level);
        this.f_21364_ = 15;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal2((PathfinderMob)this, 1.5, false, -1.0f, 3.0f));
        this.f_21345_.m_25352_(4, (Goal)new RangedAttackGoal2(this, 1.0, 40, 60, 9.0f, 4.0f, false));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        if (ModConfigs.cachedServer.ALRAUNE_ATTACK_VILLAGERS) {
            this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        }
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22279_, 0.12).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22284_, 5.0).m_22268_(Attributes.f_22278_, 0.98);
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.m_6084_() && ModConfigs.cachedServer.ALRAUNE_REGEN && this.m_20071_() && !this.m_21023_(MobEffects.f_19605_)) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 200, 2));
        }
    }

    public boolean m_7327_(Entity entity) {
        if (super.m_7327_(entity)) {
            if (entity instanceof LivingEntity) {
                int i = 0;
                if (this.m_9236_().m_46791_() == Difficulty.NORMAL) {
                    i = 5;
                } else if (this.m_9236_().m_46791_() == Difficulty.HARD) {
                    i = 10;
                }
                if (i > 0) {
                    ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19614_, i * 20, 1));
                    ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19613_, i * 20, 1));
                    ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19597_, i * 20, 2));
                }
            }
            return true;
        }
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_269533_(ModTags.DamageTypeTags.ALRAUNE_VULNERABLE_TO)) {
            amount *= 2.0f;
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_7301_(MobEffectInstance potioneffect) {
        if (ModTags.checkTagContains(potioneffect.m_19544_(), ModTags.MobEffectTags.ALRAUNE_IMMUNE_TO)) {
            MobEffectEvent.Applicable event = new MobEffectEvent.Applicable((LivingEntity)this, potioneffect);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event.getResult() == Event.Result.ALLOW;
        }
        return super.m_7301_(potioneffect);
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        int c = this.m_217043_().m_188503_(3) + 1;
        for (int i = 0; i < c; ++i) {
            PoisonSeedEntity shot = new PoisonSeedEntity(this.m_9236_(), (LivingEntity)this);
            double d0 = target.m_20188_() - (double)1.1f;
            double d1 = target.m_20185_() - this.m_20185_();
            double d2 = d0 - shot.m_20186_();
            double d3 = target.m_20189_() - this.m_20189_();
            double d4 = Math.sqrt(d1 * d1 + d3 * d3) * 0.15;
            shot.m_6686_(d1, d2 + d4, d3, 1.5f, 10.0f);
            shot.setDamage(4.0f);
            this.m_9236_().m_7967_((Entity)shot);
        }
        this.m_5496_(SoundEvents.f_12098_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.m_6674_(InteractionHand.MAIN_HAND);
    }

    public int m_5792_() {
        return 2;
    }

    public double m_6049_() {
        return -0.45;
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return 1.74f;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSoundEvents.GIRL_MOB_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ModSoundEvents.GIRL_MOB_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.GIRL_MOB_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState block) {
        this.m_5496_(SoundEvents.f_11875_, 0.15f, 1.0f);
    }

    @Nonnull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

