/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.world.entity;

import com.github.mechalopa.hmag.ModConfigs;
import com.github.mechalopa.hmag.util.ModTags;
import com.github.mechalopa.hmag.world.entity.IBeamAttackMob;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.network.NetworkHooks;

public class EnderExecutorEntity
extends EnderMan
implements IBeamAttackMob {
    private static final EntityDataAccessor<Integer> ATTACKING_TIME = SynchedEntityData.m_135353_(EnderExecutorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ATTACK_TARGET = SynchedEntityData.m_135353_(EnderExecutorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private LivingEntity targetedEntity;
    private int clientAttackTime;

    public EnderExecutorEntity(EntityType<? extends EnderExecutorEntity> type, Level level) {
        super(type, level);
        this.f_21364_ = 25;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACK_TARGET, (Object)0);
        this.f_19804_.m_135372_(ATTACKING_TIME, (Object)-20);
    }

    public static AttributeSupplier.Builder m_32541_() {
        return EnderMan.m_32541_().m_22268_(Attributes.f_22276_, 120.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22284_, 4.0).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 1.0);
    }

    public void m_8107_() {
        if (!this.m_9236_().m_5776_()) {
            if (this.m_6084_() && !this.m_21525_() && this.m_9236_().m_46791_().m_19028_() > 1 && ModConfigs.cachedServer.ENDER_EXECUTOR_BEAM_ATTACK) {
                LivingEntity target = this.m_5448_();
                if (target != null && target.m_6084_()) {
                    double d0 = this.m_20280_((Entity)target);
                    if (this.m_142582_((Entity)target) && d0 > 1.0 && d0 <= 576.0) {
                        int i = this.getAttackingTime();
                        if (++i == 0) {
                            this.setAttackingTime(i);
                            this.setActiveAttackTarget(target.m_19879_());
                        } else if (i >= this.getAttackDuration()) {
                            if (this.getActiveAttackTarget() != null && this.attackEntityWithBeamAttack(this.getActiveAttackTarget(), 6.0f) && this.f_19796_.m_188503_(10) == 0) {
                                this.m_32529_();
                            }
                            this.setAttackingTime(-(10 + this.f_19796_.m_188503_(6)));
                            this.setActiveAttackTarget(0);
                        } else {
                            this.setAttackingTime(i);
                        }
                    } else {
                        this.setAttackingTime(-20);
                        this.setActiveAttackTarget(0);
                    }
                } else {
                    this.setAttackingTime(-20);
                }
            }
        } else if (this.m_6084_() && this.hasActiveAttackTarget()) {
            LivingEntity target;
            if (this.clientAttackTime < this.getAttackDuration()) {
                ++this.clientAttackTime;
            }
            if ((target = this.getActiveAttackTarget()) != null) {
                this.m_21563_().m_24960_((Entity)target, 90.0f, 90.0f);
                this.m_21563_().m_8128_();
            }
        } else {
            this.clientAttackTime = 0;
        }
        super.m_8107_();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        float f = amount;
        if (ModConfigs.cachedServer.ENDER_EXECUTOR_REDUCE_DAMAGE && (source.m_7639_() == null || !source.m_19390_()) && !source.m_269533_(ModTags.DamageTypeTags.BYPASSES_ENDER_EXECUTOR_DAMAGE_REDUCING) && f > 10.0f) {
            if (this.m_9236_().m_46791_() == Difficulty.NORMAL) {
                f = 10.0f + (f - 10.0f) * 0.25f;
            } else if (this.m_9236_().m_46791_() == Difficulty.HARD) {
                f = 10.0f + (f - 10.0f) * 0.1f;
            }
        }
        return super.m_6469_(source, f);
    }

    public void m_6710_(@Nullable LivingEntity livingEntity) {
        if (livingEntity == null) {
            this.setActiveAttackTarget(0);
        }
        super.m_6710_(livingEntity);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        SpawnGroupData spawngroupdata = super.m_6518_(levelAccessor, difficulty, spawnType, spawnData, dataTag);
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42425_));
        return spawngroupdata;
    }

    public int m_5792_() {
        return 1;
    }

    public int getAttackingTime() {
        return (Integer)this.f_19804_.m_135370_(ATTACKING_TIME);
    }

    private void setAttackingTime(int value) {
        this.f_19804_.m_135381_(ATTACKING_TIME, (Object)value);
    }

    public boolean m_20984_(double x, double y, double z, boolean flag) {
        if (super.m_20984_(x, y, z, flag)) {
            if (this.hasActiveAttackTarget()) {
                this.setActiveAttackTarget(0);
            }
            return true;
        }
        return false;
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (ATTACK_TARGET.equals(key)) {
            this.clientAttackTime = 0;
            this.targetedEntity = null;
        }
    }

    @Override
    public int getAttackDuration() {
        return 40;
    }

    @Override
    public boolean attackEntityWithBeamAttack(LivingEntity target, float damage) {
        if (!this.m_20067_()) {
            this.m_9236_().m_6263_((Player)null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_11887_, this.m_5720_(), 1.0f, this.f_19796_.m_188501_() * 0.2f + 0.9f);
        }
        float f = damage;
        if (this.m_9236_().m_46791_() == Difficulty.HARD) {
            f += 2.0f;
        }
        return target.m_6469_(this.m_269291_().m_269104_((Entity)this, (Entity)this), f);
    }

    @Override
    public void setActiveAttackTarget(int entityId) {
        this.f_19804_.m_135381_(ATTACK_TARGET, (Object)entityId);
    }

    @Override
    public boolean hasActiveAttackTarget() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_TARGET) != 0;
    }

    @Override
    @Nullable
    public LivingEntity getActiveAttackTarget() {
        if (!this.hasActiveAttackTarget()) {
            return null;
        }
        if (this.m_9236_().f_46443_) {
            if (this.targetedEntity != null) {
                return this.targetedEntity;
            }
            Entity entity = this.m_9236_().m_6815_(((Integer)this.f_19804_.m_135370_(ATTACK_TARGET)).intValue());
            if (entity instanceof LivingEntity) {
                this.targetedEntity = (LivingEntity)entity;
                return this.targetedEntity;
            }
            return null;
        }
        return this.m_5448_();
    }

    @Override
    public float getAttackAnimationScale(float f) {
        return ((float)this.clientAttackTime + f) / (float)this.getAttackDuration();
    }

    @Override
    public float getClientSideAttackTime() {
        return this.clientAttackTime;
    }

    @Nonnull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

