/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.world.entity;

import com.github.mechalopa.hmag.ModConfigs;
import com.github.mechalopa.hmag.registry.ModSoundEvents;
import com.github.mechalopa.hmag.util.ModTags;
import com.github.mechalopa.hmag.util.ModUtils;
import com.github.mechalopa.hmag.world.entity.CommonOrUncommonVariant;
import com.github.mechalopa.hmag.world.entity.ai.goal.LeapAtTargetGoal2;
import com.github.mechalopa.hmag.world.entity.ai.goal.MeleeAttackGoal2;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

public class JiangshiEntity
extends Monster
implements VariantHolder<CommonOrUncommonVariant> {
    private static final UUID SPEED_MODIFIER_BY_DAMAGE_UUID = UUID.fromString("A25E5B12-7881-3AE6-D9F5-418CB7D9E02E");
    private static final EntityDataAccessor<Integer> DATA_SPEED_BONUS = SynchedEntityData.m_135353_(JiangshiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_VARIANT_ID = SynchedEntityData.m_135353_(JiangshiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final int SPEED_BONUS_MAX = 7;
    private int animationTick;
    private int animationTickO;

    public JiangshiEntity(EntityType<? extends JiangshiEntity> type, Level level) {
        super(type, level);
        this.f_21364_ = 12;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_SPEED_BONUS, (Object)0);
        this.f_19804_.m_135372_(DATA_VARIANT_ID, (Object)CommonOrUncommonVariant.COMMON.getId());
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new LeapGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal2((PathfinderMob)this, 1.0, false).useRaiseArm());
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(120));
        if (ModConfigs.cachedServer.JIANGSHI_ATTACK_VILLAGERS) {
            this.f_21345_.m_25352_(4, (Goal)new MoveThroughVillageGoal((PathfinderMob)this, 1.0, true, 4, () -> false));
            this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        }
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        if (ModConfigs.cachedServer.JIANGSHI_ATTACK_BABY_TURTLES) {
            this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Turtle.class, 10, true, false, Turtle.f_30122_));
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22279_, 0.19).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22282_, 0.5).m_22268_(Attributes.f_22284_, 4.0).m_22268_(Attributes.f_22278_, 0.5).m_22268_(Attributes.f_22277_, 24.0);
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public void m_8119_() {
        if (this.m_9236_().m_5776_()) {
            this.animationTickO = this.animationTick;
        }
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            if (!(this.m_20096_() || this.m_20072_() || this.m_20159_())) {
                if (this.animationTick < 10) {
                    this.animationTick = Math.min(this.animationTick + 1, 10);
                }
            } else if (this.animationTick > 0) {
                this.animationTick = Math.max(this.animationTick - 5, 0);
            }
        }
    }

    public void m_8107_() {
        if (this.m_9236_().m_5776_()) {
            if (this.f_19797_ % Math.max(8 - this.getSpeedBonus(), 1) == 0) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123745_, this.m_20208_(0.75), this.m_20187_() - 0.25, this.m_20262_(0.75), 0.0, 0.0, 0.0);
            }
        } else if (!(!this.m_6060_() && this.m_5448_() != null && this.m_5448_().m_6084_() && this.m_142582_((Entity)this.m_5448_()) && this.m_20280_((Entity)this.m_5448_()) <= 64.0 || this.getSpeedBonus() <= 0 || this.f_19797_ % 20 != 0 || this.m_217043_().m_188503_(4) != 0)) {
            this.setSpeedBonus(this.getSpeedBonus() - 1);
        }
        ModUtils.burnInDay((LivingEntity)this, this.m_217043_(), this.m_21527_());
        super.m_8107_();
    }

    public boolean m_7327_(Entity entity) {
        if (super.m_7327_(entity)) {
            ModUtils.catchFire((LivingEntity)this, entity, this.m_217043_());
            if (entity instanceof LivingEntity) {
                int i = 0;
                if (this.m_9236_().m_46791_() == Difficulty.NORMAL) {
                    i = 7;
                } else if (this.m_9236_().m_46791_() == Difficulty.HARD) {
                    i = 15;
                }
                if (i > 0) {
                    ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19614_, i * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_269533_(ModTags.DamageTypeTags.JIANGSHI_RESISTANT_TO)) {
            amount *= 0.5f;
        }
        if (!super.m_6469_(source, amount)) {
            return false;
        }
        if (this.m_21525_() || source.m_269533_(DamageTypeTags.f_268718_) || source.m_269533_(DamageTypeTags.f_268745_) || amount <= 0.0f || source.m_7639_() == null || !(source.m_7639_() instanceof LivingEntity)) {
            return true;
        }
        this.setSpeedBonus(this.getSpeedBonus() + 1);
        return true;
    }

    public void m_8038_(ServerLevel serverLevel, LightningBolt lightningBolt) {
        super.m_8038_(serverLevel, lightningBolt);
        if (!this.m_21525_()) {
            this.setSpeedBonus(0);
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        spawnData = super.m_6518_(levelAccessor, difficulty, spawnType, spawnData, dataTag);
        RandomSource randomsource = levelAccessor.m_213780_();
        this.setVariant(CommonOrUncommonVariant.getSpawnVariant(randomsource, ModConfigs.cachedServer.JIANGSHI_ANOTHER_VARIANT_SPAWN_CHANCE));
        if (this.m_6844_(EquipmentSlot.HEAD).m_41619_()) {
            LocalDate localdate = LocalDate.now();
            int i = localdate.get(ChronoField.DAY_OF_MONTH);
            int j = localdate.get(ChronoField.MONTH_OF_YEAR);
            if (j == 10 && i == 31 && randomsource.m_188501_() < 0.25f) {
                this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)(randomsource.m_188501_() < 0.1f ? Blocks.f_50144_ : Blocks.f_50143_)));
                this.f_21348_[EquipmentSlot.HEAD.m_20749_()] = 0.0f;
            }
        }
        return spawnData;
    }

    public int getSpeedBonus() {
        return (Integer)this.f_19804_.m_135370_(DATA_SPEED_BONUS);
    }

    private void setSpeedBonus(int value) {
        if ((value = Mth.m_14045_((int)value, (int)0, (int)7)) != this.getSpeedBonus()) {
            if (!this.m_9236_().m_5776_()) {
                this.m_21051_(Attributes.f_22279_).m_22120_(SPEED_MODIFIER_BY_DAMAGE_UUID);
                if (value > 0) {
                    this.m_21051_(Attributes.f_22279_).m_22125_(new AttributeModifier(SPEED_MODIFIER_BY_DAMAGE_UUID, "Speed bonus by damage", 0.6 * ((double)value / 7.0), AttributeModifier.Operation.MULTIPLY_TOTAL));
                }
            }
            this.f_19804_.m_135381_(DATA_SPEED_BONUS, (Object)value);
        }
    }

    public CommonOrUncommonVariant getVariant() {
        return CommonOrUncommonVariant.byId((Integer)this.f_19804_.m_135370_(DATA_VARIANT_ID));
    }

    public void setVariant(CommonOrUncommonVariant variant) {
        this.f_19804_.m_135381_(DATA_VARIANT_ID, (Object)variant.getId());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setSpeedBonus(compound.m_128451_("SpeedBonus"));
        this.setVariant(CommonOrUncommonVariant.byId(compound.m_128451_("Variant")));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("SpeedBonus", this.getSpeedBonus());
        compound.m_128405_("Variant", this.getVariant().getId());
    }

    public int m_5792_() {
        return 3;
    }

    public double m_6049_() {
        return -0.45;
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return 1.74f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getAnimationScale(float f) {
        return Mth.m_14179_((float)f, (float)((float)this.animationTickO / 10.0f), (float)((float)this.animationTick / 10.0f));
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSoundEvents.JIANGSHI_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ModSoundEvents.JIANGSHI_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.JIANGSHI_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState block) {
        this.m_5496_(SoundEvents.f_12047_, 0.15f, 1.0f);
    }

    @Nonnull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private class LeapGoal
    extends LeapAtTargetGoal2 {
        private final JiangshiEntity mob;

        public LeapGoal(JiangshiEntity mob) {
            super((Mob)mob, 0.4f, 0.2f, 8.0f, 12);
            this.mob = mob;
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_() && this.mob.m_142582_((Entity)this.mob.m_5448_());
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            this.mob.m_5496_((SoundEvent)ModSoundEvents.JIANGSHI_JUMP.get(), 0.8f, 1.0f);
        }

        @Override
        public float getMaxAttackDistance() {
            return super.getMaxAttackDistance() - 3.0f * ((float)this.mob.getSpeedBonus() / 7.0f);
        }

        @Override
        public double getXZD() {
            return super.getXZD() + 0.3 * ((double)this.mob.getSpeedBonus() / 7.0);
        }
    }
}

