/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.world.entity;

import com.github.mechalopa.hmag.ModConfigs;
import com.github.mechalopa.hmag.registry.ModParticleTypes;
import com.github.mechalopa.hmag.registry.ModSoundEvents;
import com.github.mechalopa.hmag.util.ModTags;
import com.github.mechalopa.hmag.util.ModUtils;
import com.github.mechalopa.hmag.world.entity.IBeamAttackMob;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkHooks;

public class MonolithEntity
extends FlyingMob
implements Enemy,
IBeamAttackMob {
    private static final EntityDataAccessor<Byte> ATTACK_PHASE = SynchedEntityData.m_135353_(MonolithEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> ATTACK_TARGET = SynchedEntityData.m_135353_(MonolithEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private LivingEntity targetedEntity;
    private int clientAttackTime;
    private int eyeCloseTimer = 0;

    public MonolithEntity(EntityType<? extends MonolithEntity> type, Level worldIn) {
        super(type, worldIn);
        this.f_21364_ = 15;
        this.f_21342_ = new MonolithMoveControl(this);
    }

    protected BodyRotationControl m_7560_() {
        return new MonolithBodyRotationControl((Mob)this);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new RandomFlyGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new RoarAttackGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new BeamAttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new LookTargetGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new LookAroundGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, true, false, (Predicate)new TargetPredicate(this)));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACK_TARGET, (Object)0);
        this.f_19804_.m_135372_(ATTACK_PHASE, (Object)0);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22279_, 0.16).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22284_, 8.0).m_22268_(Attributes.f_22278_, 0.75).m_22268_(Attributes.f_22277_, 32.0);
    }

    public void m_8107_() {
        if (!this.m_9236_().m_5776_()) {
            if (this.m_6084_()) {
                AttackPhase phase = this.getAttackPhase();
                if (phase == AttackPhase.BEAM_END || phase == AttackPhase.ROAR_END) {
                    ++this.eyeCloseTimer;
                    if (this.eyeCloseTimer >= 10) {
                        this.setAttackPhase(AttackPhase.WAIT);
                        this.eyeCloseTimer = 0;
                    }
                } else {
                    this.eyeCloseTimer = 0;
                }
            }
        } else if (this.m_6084_()) {
            if (this.hasActiveAttackTarget()) {
                LivingEntity target;
                if (this.clientAttackTime < this.getAttackDuration()) {
                    ++this.clientAttackTime;
                }
                if ((target = this.getActiveAttackTarget()) != null) {
                    this.m_21563_().m_24960_((Entity)target, 90.0f, 90.0f);
                    this.m_21563_().m_8128_();
                }
            } else {
                this.clientAttackTime = 0;
            }
            if (this.getAttackPhase().isBeamAttack()) {
                double d0 = this.m_20208_(1.5);
                double d1 = this.m_20187_() - 0.25;
                double d2 = this.m_20262_(1.5);
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123789_, d0, d1, d2, (d0 - this.m_20185_()) * -0.025, (d1 - (this.m_20227_(0.5) - 0.25)) * -0.025, (d2 - this.m_20189_()) * -0.025);
            } else if (this.getAttackPhase().isRoarAttack()) {
                for (int i = 0; i < 8; ++i) {
                    double d0 = this.m_20208_(1.5);
                    double d1 = this.m_20187_() - 0.25;
                    double d2 = this.m_20262_(1.5);
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0, d1, d2, (d0 - this.m_20185_()) * 0.2, (d1 - (this.m_20227_(0.5) - 0.25)) * 0.2, (d2 - this.m_20189_()) * 0.2);
                }
            } else if (this.f_19797_ % 12 == 0) {
                this.m_9236_().m_7106_((ParticleOptions)ModParticleTypes.ENCHANTMENT_RUNE.get(), this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), (this.m_217043_().m_188500_() - 0.5) * 2.0, this.m_217043_().m_188500_() - 0.25, (this.m_217043_().m_188500_() - 0.5) * 2.0);
            }
        } else {
            this.clientAttackTime = 0;
        }
        super.m_8107_();
    }

    public AttackPhase getAttackPhase() {
        return AttackPhase.byId(((Byte)this.f_19804_.m_135370_(ATTACK_PHASE)).byteValue());
    }

    private void setAttackPhase(AttackPhase phase) {
        this.f_19804_.m_135381_(ATTACK_PHASE, (Object)((byte)(phase.getId() & 0xFF)));
    }

    protected boolean m_8028_() {
        return true;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        ItemStack stack;
        if (source.m_269533_(ModTags.DamageTypeTags.MONOLITH_RESISTANT_TO)) {
            amount *= 0.5f;
        } else if (!source.m_269014_() && source.m_7639_() != null && source.m_7639_() instanceof LivingEntity && !(stack = ((LivingEntity)source.m_7639_()).m_21205_()).m_41619_() && stack.m_41720_() != null && stack.m_41720_().m_8096_(Blocks.f_50069_.m_49966_())) {
            amount *= 2.0f;
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_7301_(MobEffectInstance potioneffect) {
        if (ModTags.checkTagContains(potioneffect.m_19544_(), ModTags.MobEffectTags.MONOLITH_IMMUNE_TO)) {
            MobEffectEvent.Applicable event = new MobEffectEvent.Applicable((LivingEntity)this, potioneffect);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event.getResult() == Event.Result.ALLOW;
        }
        return super.m_7301_(potioneffect);
    }

    public boolean m_6040_() {
        return true;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType spawnType, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, spawnType, spawnDataIn, dataTag);
        if (spawnType == MobSpawnType.NATURAL) {
            Vec3 vec3 = this.m_20184_();
            this.m_20256_(new Vec3(vec3.f_82479_, 0.05, vec3.f_82481_));
        }
        return spawnDataIn;
    }

    public void m_6710_(@Nullable LivingEntity livingEntity) {
        if (livingEntity == null) {
            this.setActiveAttackTarget(0);
        }
        super.m_6710_(livingEntity);
    }

    public float m_213856_() {
        return Mth.m_14036_((float)(super.m_213856_() + 0.8f), (float)0.0f, (float)1.0f);
    }

    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    protected SoundEvent m_7515_() {
        return null;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)ModSoundEvents.DOLL_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.DOLL_DEATH.get();
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 1.0f;
    }

    public static boolean checkMonolithSpawnRules(EntityType<MonolithEntity> type, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource randomIn) {
        if (levelAccessor.m_46791_() != Difficulty.PEACEFUL && MonolithEntity.m_217057_(type, (LevelAccessor)levelAccessor, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)randomIn)) {
            ServerLevel serverlevel;
            if (ModUtils.isDarkEnoughToSpawn(levelAccessor, pos, randomIn)) {
                return true;
            }
            ServerLevel level = levelAccessor.m_6018_();
            if (level instanceof ServerLevel && (serverlevel = level).m_215010_().m_220491_(pos, ModTags.StructureTags.MONOLITHS_SPAWN_IN).m_73603_()) {
                return true;
            }
        }
        return false;
    }

    public int m_5792_() {
        return 3;
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (ATTACK_TARGET.equals(key)) {
            this.clientAttackTime = 0;
            this.targetedEntity = null;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 15) {
            for (int i = 0; i < 32; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20208_(1.0), this.m_20187_() - 0.25, this.m_20262_(1.0), this.m_217043_().m_188583_() * 0.2, this.m_217043_().m_188583_() * 0.2, this.m_217043_().m_188583_() * 0.2);
            }
        } else {
            super.m_7822_(id);
        }
    }

    @Override
    public int getAttackDuration() {
        return 60;
    }

    @Override
    public boolean attackEntityWithBeamAttack(LivingEntity target, float damage) {
        if (!this.m_20067_()) {
            this.m_9236_().m_6263_((Player)null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_11887_, this.m_5720_(), 1.0f, this.m_217043_().m_188501_() * 0.2f + 0.9f);
        }
        float f = damage;
        int i = 0;
        if (this.m_9236_().m_46791_() == Difficulty.NORMAL) {
            i = 5;
        } else if (this.m_9236_().m_46791_() == Difficulty.HARD) {
            f += 2.0f;
            i = 10;
        }
        boolean flag = target.m_6469_(this.m_269291_().m_269104_((Entity)this, (Entity)this), f);
        boolean flag1 = target.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_));
        if (flag || flag1) {
            if (i > 0) {
                int j = this.m_217043_().m_188503_(3);
                target.m_7292_(new MobEffectInstance(j == 2 ? MobEffects.f_19613_ : (j == 1 ? MobEffects.f_19597_ : MobEffects.f_19599_), i * 20, 0));
            }
            return true;
        }
        return false;
    }

    @Override
    public void setActiveAttackTarget(int entityId) {
        this.f_19804_.m_135381_(ATTACK_TARGET, (Object)entityId);
    }

    @Override
    public boolean hasActiveAttackTarget() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_TARGET) != 0;
    }

    @Override
    @Nullable
    public LivingEntity getActiveAttackTarget() {
        if (!this.hasActiveAttackTarget()) {
            return null;
        }
        if (this.m_9236_().f_46443_) {
            if (this.targetedEntity != null) {
                return this.targetedEntity;
            }
            Entity entity = this.m_9236_().m_6815_(((Integer)this.f_19804_.m_135370_(ATTACK_TARGET)).intValue());
            if (entity instanceof LivingEntity) {
                this.targetedEntity = (LivingEntity)entity;
                return this.targetedEntity;
            }
            return null;
        }
        return this.m_5448_();
    }

    @Override
    public float getAttackAnimationScale(float f) {
        return ((float)this.clientAttackTime + f) / (float)this.getAttackDuration();
    }

    @Override
    public float getClientSideAttackTime() {
        return this.m_9236_().m_46467_() % 24000L;
    }

    @Nonnull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected class MonolithMoveControl
    extends MoveControl {
        private final MonolithEntity parent;

        public MonolithMoveControl(MonolithEntity mob) {
            super((Mob)mob);
            this.parent = mob;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                Vec3 vec3 = new Vec3(this.f_24975_ - this.parent.m_20185_(), this.f_24976_ - this.parent.m_20186_(), this.f_24977_ - this.parent.m_20189_());
                double d0 = vec3.m_82553_();
                if (d0 < this.parent.m_20191_().m_82309_() || !ModUtils.canReach((LivingEntity)this.parent, vec3.m_82541_(), Mth.m_14165_((double)d0))) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                    this.parent.m_20256_(this.parent.m_20184_().m_82490_(0.5));
                } else {
                    float f = (float)this.parent.m_21133_(Attributes.f_22279_);
                    this.parent.m_20256_(this.parent.m_20184_().m_82549_(vec3.m_82490_((double)((float)this.f_24978_ * f) * 0.2 / d0)));
                }
            }
        }
    }

    protected class MonolithBodyRotationControl
    extends BodyRotationControl {
        public MonolithBodyRotationControl(Mob mob) {
            super(mob);
        }

        public void m_8121_() {
            MonolithEntity.this.f_20885_ = MonolithEntity.this.f_20883_;
            MonolithEntity.this.f_20883_ = MonolithEntity.this.m_146908_();
        }
    }

    private static class RandomFlyGoal
    extends Goal {
        private final MonolithEntity parent;

        public RandomFlyGoal(MonolithEntity mob) {
            this.parent = mob;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return !this.parent.m_21566_().m_24995_() && this.parent.getAttackPhase().isWait() && this.parent.m_217043_().m_188501_() < 0.01f;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            RandomSource random = this.parent.m_217043_();
            double d0 = this.parent.m_20185_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 3.0f);
            double d1 = this.parent.m_20186_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 3.0f);
            double d2 = this.parent.m_20189_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 3.0f);
            this.parent.m_21566_().m_6849_(d0, d1, d2, 0.15);
        }
    }

    private static class RoarAttackGoal
    extends Goal {
        private final MonolithEntity parent;
        private int tickCounter;

        public RoarAttackGoal(MonolithEntity mob) {
            this.parent = mob;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (this.parent.m_5448_() != null && this.parent.m_5448_().m_6084_() && this.parent.getAttackPhase().isWait() && this.parent.getAttackPhase() != AttackPhase.ROAR_END) {
                double d0 = ModConfigs.cachedServer.MONOLITH_ROAR_ATTACK_DISTANCE;
                return this.parent.m_20280_((Entity)this.parent.m_5448_()) <= d0 * d0;
            }
            return false;
        }

        public boolean m_8045_() {
            if (this.parent.m_5448_() != null && this.parent.m_5448_().m_6084_() && this.parent.getAttackPhase().isRoarAttack()) {
                return this.parent.m_20280_((Entity)this.parent.m_5448_()) < 4096.0;
            }
            return false;
        }

        public void m_8056_() {
            this.tickCounter = -5;
            this.parent.setAttackPhase(AttackPhase.ROAR_CHARGE);
        }

        public void m_8041_() {
            this.parent.setAttackPhase(AttackPhase.ROAR_END);
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity target = this.parent.m_5448_();
            if (target == null || !this.parent.m_142582_((Entity)target)) {
                this.parent.setAttackPhase(AttackPhase.ROAR_END);
                this.parent.m_6710_(null);
            } else {
                ++this.tickCounter;
                if (this.tickCounter == 0) {
                    this.parent.m_5496_(SoundEvents.f_11862_, 1.0f, 1.0f);
                    this.parent.setAttackPhase(AttackPhase.ROAR_ATTACK);
                } else if (this.tickCounter >= 15) {
                    for (LivingEntity livingentity : this.parent.m_9236_().m_6443_(LivingEntity.class, this.parent.m_20191_().m_82400_(ModConfigs.cachedServer.MONOLITH_ROAR_ATTACK_RANGE), (Predicate)new RoarTargetPredicate())) {
                        if (livingentity instanceof Player && (((Player)livingentity).m_7500_() || ((Player)livingentity).m_5833_())) continue;
                        float f = 6.0f;
                        int i = 0;
                        if (this.parent.m_9236_().m_46791_() == Difficulty.NORMAL) {
                            i = 7;
                        } else if (this.parent.m_9236_().m_46791_() == Difficulty.HARD) {
                            f += 3.0f;
                            i = 12;
                        }
                        if (i > 0) {
                            livingentity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, i * 10, 0));
                            livingentity.m_7292_(new MobEffectInstance(MobEffects.f_19599_, i * 20, 1));
                            livingentity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, i * 20, 1));
                            livingentity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, i * 20, 1));
                        }
                        livingentity.m_147240_(1.5, this.parent.m_20185_() - livingentity.m_20185_(), this.parent.m_20189_() - livingentity.m_20189_());
                        livingentity.m_6469_(this.parent.m_269291_().m_269104_((Entity)this.parent, (Entity)this.parent), f);
                    }
                    this.parent.m_5496_(SoundEvents.f_12417_, 1.0f, (this.parent.m_217043_().m_188501_() - this.parent.m_217043_().m_188501_()) * 0.2f + 1.0f);
                    this.parent.m_9236_().m_7605_((Entity)this.parent, (byte)15);
                    this.parent.m_146850_(GameEvent.f_223709_);
                    Vec3 vec3 = this.parent.m_20184_();
                    Vec3 vec31 = new Vec3(target.m_20185_() - this.parent.m_20185_(), 0.0, target.m_20189_() - this.parent.m_20189_()).m_82541_().m_82490_(0.25);
                    this.parent.m_20334_(vec3.f_82479_ / 2.0 - vec31.f_82479_, vec3.f_82480_, vec3.f_82481_ / 2.0 - vec31.f_82481_);
                    this.parent.setAttackPhase(AttackPhase.ROAR_END);
                }
            }
        }
    }

    private static class BeamAttackGoal
    extends Goal {
        private final MonolithEntity parent;
        private int tickCounter;

        public BeamAttackGoal(MonolithEntity mob) {
            this.parent = mob;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return this.parent.m_5448_() != null && this.parent.m_5448_().m_6084_() && this.parent.getAttackPhase().isWait();
        }

        public boolean m_8045_() {
            if (this.parent.m_5448_() != null && this.parent.m_5448_().m_6084_()) {
                double d0 = this.parent.m_20280_((Entity)this.parent.m_5448_());
                double d1 = Math.max(ModConfigs.cachedServer.MONOLITH_ROAR_ATTACK_DISTANCE - 1.0, 0.0);
                double d2 = ModConfigs.cachedServer.MONOLITH_BEAM_ATTACK_DISTANCE;
                return d0 > d1 * d1 && d0 <= d2 * d2;
            }
            return false;
        }

        public void m_8056_() {
            this.tickCounter = -20;
            this.parent.setAttackPhase(AttackPhase.BEAM_CHARGE);
        }

        public void m_8041_() {
            this.parent.setActiveAttackTarget(0);
            this.parent.m_6710_(null);
            this.parent.setAttackPhase(AttackPhase.BEAM_END);
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity target = this.parent.m_5448_();
            if (target == null || !this.parent.m_142582_((Entity)target)) {
                this.parent.setAttackPhase(AttackPhase.BEAM_END);
                this.parent.m_6710_(null);
            } else {
                ++this.tickCounter;
                if (this.tickCounter >= -5 && this.tickCounter < 0 && this.parent.getAttackPhase() != AttackPhase.BEAM_CHARGE2) {
                    this.parent.setAttackPhase(AttackPhase.BEAM_CHARGE2);
                } else if (this.tickCounter == 0) {
                    this.parent.setAttackPhase(AttackPhase.BEAM_ATTACK);
                    this.parent.m_5496_(SoundEvents.f_11862_, 1.0f, 1.0f);
                    this.parent.setActiveAttackTarget(target.m_19879_());
                    if (this.parent.m_217043_().m_188501_() < 0.4f) {
                        Vec3 vec3 = target.m_20299_(1.0f);
                        this.parent.m_21566_().m_6849_(vec3.f_82479_ + (double)((this.parent.m_217043_().m_188501_() * 2.0f - 1.0f) * 3.0f), vec3.f_82480_ - (double)(0.5f + this.parent.m_217043_().m_188501_()), vec3.f_82481_ + (double)((this.parent.m_217043_().m_188501_() * 2.0f - 1.0f) * 3.0f), 0.2);
                    }
                } else if (this.tickCounter >= this.parent.getAttackDuration()) {
                    if (this.parent.getActiveAttackTarget() != null) {
                        this.parent.attackEntityWithBeamAttack(this.parent.getActiveAttackTarget(), 5.0f);
                    }
                    this.parent.setAttackPhase(AttackPhase.BEAM_END);
                    this.parent.m_6710_(null);
                }
            }
        }
    }

    private static class LookTargetGoal
    extends Goal {
        private final MonolithEntity parent;

        public LookTargetGoal(MonolithEntity mob) {
            this.parent = mob;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity target = this.parent.m_5448_();
            return target != null && target.m_20280_((Entity)this.parent) < 4096.0;
        }

        public boolean m_8045_() {
            return this.m_8036_();
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity target = this.parent.m_5448_();
            if (target != null && target.m_20280_((Entity)this.parent) < 4096.0) {
                double d0 = target.m_20185_() - this.parent.m_20185_();
                double d1 = target.m_20189_() - this.parent.m_20189_();
                this.parent.m_146922_(-((float)Mth.m_14136_((double)d0, (double)d1)) * 57.295776f);
                this.parent.f_20883_ = this.parent.m_146908_();
            }
        }
    }

    private static class LookAroundGoal
    extends Goal {
        private final MonolithEntity parent;
        private double lookX;
        private double lookZ;
        private int idleTime;

        public LookAroundGoal(MonolithEntity mob) {
            this.parent = mob;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.parent.m_217043_().m_188501_() < 0.008f;
        }

        public boolean m_8045_() {
            return this.idleTime >= 0;
        }

        public void m_8056_() {
            double d0 = Math.PI * 2 * this.parent.m_217043_().m_188500_();
            this.lookX = Math.cos(d0);
            this.lookZ = Math.sin(d0);
            this.idleTime = 20 + this.parent.m_217043_().m_188503_(20);
        }

        public void m_8037_() {
            --this.idleTime;
            this.parent.m_146922_(-((float)Mth.m_14136_((double)this.lookX, (double)this.lookZ)) * 57.295776f);
            this.parent.f_20883_ = this.parent.m_146908_();
        }
    }

    private static class TargetPredicate
    implements Predicate<LivingEntity> {
        private final MonolithEntity parent;

        public TargetPredicate(MonolithEntity mob) {
            this.parent = mob;
        }

        @Override
        public boolean test(@Nullable LivingEntity livingEntityIn) {
            if (this.parent.m_21188_() != null && this.parent.m_21188_().equals((Object)livingEntityIn) && (livingEntityIn.m_6095_() != EntityType.f_20532_ || !this.parent.m_9236_().m_46469_().m_46207_(GameRules.f_46127_))) {
                double d0 = ModConfigs.cachedServer.MONOLITH_TARGET_DISTANCE;
                return livingEntityIn.m_20280_((Entity)this.parent) <= d0 * d0;
            }
            if (livingEntityIn.m_6095_().m_204039_(ModTags.EntityTypeTags.MONOLITH_TARGET_BLACKLIST)) {
                return false;
            }
            if (livingEntityIn instanceof Player || livingEntityIn instanceof AbstractGolem && ModConfigs.cachedServer.MONOLITH_ATTACK_GOLEMS || livingEntityIn instanceof AbstractVillager && ModConfigs.cachedServer.MONOLITH_ATTACK_VILLAGERS || livingEntityIn.m_6336_() == MobType.f_21643_ && ModConfigs.cachedServer.MONOLITH_ATTACK_ILLAGERS) {
                double d0 = ModConfigs.cachedServer.MONOLITH_TARGET_DISTANCE;
                return livingEntityIn.m_20280_((Entity)this.parent) <= d0 * d0;
            }
            return false;
        }
    }

    public static enum AttackPhase {
        WAIT(0, false, false),
        BEAM_CHARGE(1, true, false),
        BEAM_CHARGE2(2, true, false),
        BEAM_ATTACK(3, true, false),
        BEAM_END(4, false, false),
        ROAR_CHARGE(5, false, true),
        ROAR_ATTACK(6, false, true),
        ROAR_END(7, false, false);

        private final int id;
        private final boolean isBeam;
        private final boolean isRoar;
        private static final AttackPhase[] BY_ID;

        private AttackPhase(int idIn, boolean isBeamIn, boolean isRoarIn) {
            this.id = idIn;
            this.isBeam = isBeamIn;
            this.isRoar = isRoarIn;
        }

        public int getId() {
            return this.id;
        }

        public boolean isWait() {
            return !this.isBeamAttack() && !this.isRoarAttack();
        }

        public boolean isBeamAttack() {
            return this.isBeam;
        }

        public boolean isRoarAttack() {
            return this.isRoar;
        }

        public static AttackPhase byId(int idIn) {
            if (idIn < 0 || idIn >= BY_ID.length) {
                idIn = 0;
            }
            return BY_ID[idIn];
        }

        static {
            BY_ID = (AttackPhase[])Arrays.stream(AttackPhase.values()).sorted(Comparator.comparingInt(AttackPhase::getId)).toArray(AttackPhase[]::new);
        }
    }

    private static class RoarTargetPredicate
    implements Predicate<LivingEntity> {
        private RoarTargetPredicate() {
        }

        @Override
        public boolean test(@Nullable LivingEntity livingEntityIn) {
            return livingEntityIn.m_6084_() && !livingEntityIn.m_6095_().m_204039_(ModTags.EntityTypeTags.MONOLITH_ROAR_IMMUNE);
        }
    }
}

