/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.world.entity;

import com.github.mechalopa.hmag.util.ModTags;
import com.github.mechalopa.hmag.world.entity.GhostEntity;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;

public class WitherGhostEntity
extends GhostEntity {
    public WitherGhostEntity(EntityType<? extends WitherGhostEntity> type, Level level) {
        super((EntityType<? extends GhostEntity>)type, level);
        this.m_21441_(BlockPathTypes.LAVA, 8.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return GhostEntity.createAttributes();
    }

    @Override
    protected boolean shouldBurnInDay() {
        return false;
    }

    @Override
    public boolean m_7327_(Entity entity) {
        if (!super.m_7327_(entity)) {
            return false;
        }
        if (entity instanceof LivingEntity) {
            ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19615_, 200));
        }
        return true;
    }

    @Override
    protected void m_213945_(RandomSource rand, DifficultyInstance difficulty) {
        float f = rand.m_188501_();
        float f2 = this.m_9236_().m_46791_() == Difficulty.HARD ? 0.05f : 0.01f;
        if (f < f2) {
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42425_));
        } else {
            LocalDate localdate = LocalDate.now();
            int i = localdate.get(ChronoField.DAY_OF_MONTH);
            int j = localdate.get(ChronoField.MONTH_OF_YEAR);
            if (j == 4 && i == 1 && rand.m_188501_() < 0.5f) {
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42429_));
            }
        }
    }

    public boolean m_7301_(MobEffectInstance potioneffect) {
        if (ModTags.checkTagContains(potioneffect.m_19544_(), ModTags.MobEffectTags.WITHER_GHOST_IMMUNE_TO)) {
            MobEffectEvent.Applicable event = new MobEffectEvent.Applicable((LivingEntity)this, potioneffect);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event.getResult() == Event.Result.ALLOW;
        }
        return super.m_7301_(potioneffect);
    }
}

