/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.world.entity.projectile;

import com.github.mechalopa.hmag.registry.ModEntityTypes;
import com.github.mechalopa.hmag.util.ModTags;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.PlayMessages;

public class InkSpitEntity
extends Projectile {
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(InkSpitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);

    public InkSpitEntity(EntityType<? extends InkSpitEntity> entity, Level level) {
        super(entity, level);
    }

    public InkSpitEntity(EntityType<? extends InkSpitEntity> entity, double x, double y, double z, Level level) {
        this(entity, level);
        this.m_6034_(x, y, z);
    }

    public InkSpitEntity(EntityType<? extends InkSpitEntity> entity, LivingEntity thrower, Level level) {
        this(entity, thrower.m_20185_(), thrower.m_20188_() - (double)0.1f, thrower.m_20189_(), level);
        this.m_5602_((Entity)thrower);
    }

    public InkSpitEntity(Level level, LivingEntity thrower) {
        this((EntityType<? extends InkSpitEntity>)((EntityType)ModEntityTypes.INK_SPIT.get()), thrower, level);
    }

    public InkSpitEntity(Level level, double x, double y, double z) {
        this((EntityType<? extends InkSpitEntity>)((EntityType)ModEntityTypes.INK_SPIT.get()), x, y, z, level);
    }

    public InkSpitEntity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType<? extends InkSpitEntity>)((EntityType)ModEntityTypes.INK_SPIT.get()), level);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(3.0f));
    }

    public void m_8119_() {
        super.m_8119_();
        HitResult hitresult = ProjectileUtil.m_278158_((Entity)this, x$0 -> this.m_5603_((Entity)x$0));
        if (hitresult.m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
            this.m_6532_(hitresult);
        }
        this.m_20101_();
        Vec3 vec3 = this.m_20184_();
        double d0 = this.m_20185_() + vec3.f_82479_;
        double d1 = this.m_20186_() + vec3.f_82480_;
        double d2 = this.m_20189_() + vec3.f_82481_;
        this.m_37283_();
        float f = this.m_20069_() ? 0.95f : 0.99f;
        this.m_20256_(vec3.m_82490_((double)f));
        if (!this.m_20068_()) {
            Vec3 vec31 = this.m_20184_();
            this.m_20334_(vec31.f_82479_, vec31.f_82480_ - (double)this.getGravity(), vec31.f_82481_);
        }
        this.m_6034_(d0, d1, d2);
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        if (!this.m_9236_().m_5776_()) {
            boolean flag;
            Entity entity = this.m_19749_();
            LivingEntity livingEntity = entity != null && entity instanceof LivingEntity ? (LivingEntity)entity : null;
            Entity entity1 = result.m_82443_();
            if (!entity1.m_6095_().m_204039_(ModTags.EntityTypeTags.INK_SPIT_IMMUNE) && (flag = entity1.m_6469_(this.m_269291_().m_269299_((Entity)this, livingEntity), this.getDamage())) && entity1 instanceof LivingEntity) {
                int i = 2;
                if (this.m_9236_().m_46791_() == Difficulty.NORMAL) {
                    i = 5;
                } else if (this.m_9236_().m_46791_() == Difficulty.HARD) {
                    i = 10;
                }
                if (i > 0) {
                    ((LivingEntity)entity1).m_7292_(new MobEffectInstance(MobEffects.f_19610_, 20 * i, 0));
                }
            }
        }
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
        if (!this.m_9236_().m_5776_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)3);
            this.m_146870_();
        }
    }

    protected float getGravity() {
        return 0.03f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 3) {
            for (int i = 0; i < 30; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123765_, this.m_20185_(), this.m_20186_(), this.m_20189_(), ((double)this.f_19796_.m_188501_() - 0.5) * 1.2, ((double)this.f_19796_.m_188501_() - 0.5) * 1.2, ((double)this.f_19796_.m_188501_() - 1.2) * 0.08);
            }
        }
    }

    public void setDamage(float amount) {
        this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(amount));
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue();
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128350_("Damage", this.getDamage());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setDamage(compound.m_128457_("Damage"));
    }

    public void m_141965_(ClientboundAddEntityPacket packet) {
        super.m_141965_(packet);
        double d0 = packet.m_131503_();
        double d1 = packet.m_131504_();
        double d2 = packet.m_131505_();
        for (int i = 0; i < 30; ++i) {
            double d3 = 0.4 + 0.1 * ((double)i / 5.0);
            Vec3 vec3 = new Vec3(d0 * d3 * (double)(0.8f + this.f_19796_.m_188501_() * 0.4f), d1 * (double)(0.8f + this.f_19796_.m_188501_() * 0.4f), d2 * d3 * (double)(0.8f + this.f_19796_.m_188501_() * 0.4f));
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123765_, this.m_20185_(), this.m_20186_(), this.m_20189_(), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
        }
    }
}

