/*
 * Decompiled with CFR 0.152.
 */
package com.github.mechalopa.hmag.world.entity.projectile;

import com.github.mechalopa.hmag.registry.ModEntityTypes;
import com.github.mechalopa.hmag.world.entity.projectile.ModProjectileItemEntity;
import java.util.List;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PlayMessages;

public class PoisonSeedEntity
extends ModProjectileItemEntity {
    public PoisonSeedEntity(EntityType<? extends PoisonSeedEntity> type, Level level) {
        super(type, level);
    }

    public PoisonSeedEntity(Level level, LivingEntity thrower) {
        super((EntityType<? extends ModProjectileItemEntity>)((EntityType)ModEntityTypes.POISON_SEED.get()), thrower, level);
    }

    public PoisonSeedEntity(Level level, double x, double y, double z) {
        super((EntityType<? extends ModProjectileItemEntity>)((EntityType)ModEntityTypes.POISON_SEED.get()), x, y, z, level);
    }

    public PoisonSeedEntity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType<? extends PoisonSeedEntity>)((EntityType)ModEntityTypes.POISON_SEED.get()), level);
    }

    protected Item m_7881_() {
        return Items.f_42733_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 3) {
            for (int i = 0; i < 8; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, this.m_7846_()), this.m_20185_(), this.m_20186_(), this.m_20189_(), ((double)this.f_19796_.m_188501_() - 0.5) * 0.08, ((double)this.f_19796_.m_188501_() - 0.5) * 0.08, ((double)this.f_19796_.m_188501_() - 0.5) * 0.08);
            }
        }
    }

    @Override
    protected void onHitServer(HitResult result) {
        AABB aabb = this.m_20191_().m_82377_(4.0, 2.0, 4.0);
        List list = this.m_9236_().m_45976_(LivingEntity.class, aabb);
        if (!list.isEmpty()) {
            for (LivingEntity livingEntity : list) {
                double d0;
                if (!livingEntity.m_5801_() || !((d0 = this.m_20280_((Entity)livingEntity)) < 16.0)) continue;
                double d1 = 1.0 - Math.sqrt(d0) / 4.0;
                if (result.m_6662_() == HitResult.Type.ENTITY && ((EntityHitResult)result).m_82443_() == livingEntity) {
                    d1 = 1.0;
                }
                int i = 0;
                if (this.m_9236_().m_46791_() == Difficulty.NORMAL) {
                    i = 140;
                } else if (this.m_9236_().m_46791_() == Difficulty.HARD) {
                    i = 300;
                }
                if ((i = (int)(d1 * (double)i + 0.5)) <= 20) continue;
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, i, 0));
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, i, 0));
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, i, 0));
            }
        }
        this.m_9236_().m_46796_(2002, this.m_20183_(), MobEffects.f_19614_.m_19484_());
        this.m_9236_().m_7605_((Entity)this, (byte)3);
        super.onHitServer(result);
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        result.m_82443_().m_6469_(this.m_269291_().m_269390_((Entity)this, this.m_19749_()), this.getDamage());
    }
}

