/*
 * Decompiled with CFR 0.152.
 */
package net.luko.bestia.data;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.luko.bestia.Bestia;
import net.luko.bestia.config.BestiaClientConfig;
import net.luko.bestia.config.BestiaCommonConfig;
import net.luko.bestia.data.BestiaryData;
import net.luko.bestia.data.BestiaryKey;
import net.luko.bestia.data.buff.special.SpecialBuff;
import net.luko.bestia.data.buff.special.SpecialBuffRegistry;
import net.luko.bestia.network.BestiarySyncPacket;
import net.luko.bestia.network.MobLevelUpToastPacket;
import net.luko.bestia.network.ModPackets;
import net.luko.bestia.util.MobIdUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.PacketDistributor;

public class BestiaryManager {
    private final Map<ResourceLocation, Integer> killCounts = new HashMap<ResourceLocation, Integer>();
    private final Map<ResourceLocation, BestiaryData> cachedData = new HashMap<ResourceLocation, BestiaryData>();
    private final Map<ResourceLocation, Map<ResourceLocation, Integer>> spentPoints = new HashMap<ResourceLocation, Map<ResourceLocation, Integer>>();
    private String playerName;

    public void loadFromNBT(CompoundTag bestiaryTag, String playerName) {
        if (bestiaryTag.m_128441_(BestiaryKey.VERSION.get()) || bestiaryTag.m_128456_()) {
            this.loadEntriesNBT(bestiaryTag.m_128437_(BestiaryKey.ENTRIES.get(), 10));
        } else {
            this.loadEntriesNBT(this.convertFromVersion1To2(bestiaryTag).m_128437_(BestiaryKey.ENTRIES.get(), 10));
        }
        this.playerName = playerName;
    }

    private void loadEntriesNBT(ListTag entriesTag) {
        for (Tag t : entriesTag) {
            CompoundTag tag = (CompoundTag)t;
            ResourceLocation mobId = ResourceLocation.m_135820_((String)tag.m_128461_(BestiaryKey.Entry.ID.get()));
            if (mobId == null) {
                Bestia.LOGGER.warn("{} was not parsed correctly. Data for this mob will not persist.", (Object)tag.m_128461_(BestiaryKey.Entry.ID.get()));
                continue;
            }
            int kills = tag.m_128451_(BestiaryKey.Entry.KILLS.get());
            Map<ResourceLocation, Integer> loadedSpentPoints = this.loadSpecialBuffs(tag.m_128469_(BestiaryKey.Entry.SPENT_POINTS.get()));
            this.killCounts.put(mobId, kills);
            BestiaryData newData = BestiaryData.compute(kills, loadedSpentPoints);
            this.cachedData.put(mobId, newData);
            this.spentPoints.put(mobId, newData.spentPoints());
        }
    }

    private Map<ResourceLocation, Integer> loadSpecialBuffs(CompoundTag tag) {
        HashMap<ResourceLocation, Integer> buffs = new HashMap<ResourceLocation, Integer>();
        for (String key : tag.m_128431_()) {
            ResourceLocation buffId = ResourceLocation.m_135820_((String)key);
            if (buffId != null) {
                buffs.put(buffId, tag.m_128451_(key));
                continue;
            }
            Bestia.LOGGER.warn("Invalid buff ID '{}', skipping.", (Object)key);
        }
        return buffs;
    }

    private CompoundTag convertFromVersion1To2(CompoundTag oldTag) {
        Bestia.LOGGER.info("Converting old bestiary tag...");
        Bestia.LOGGER.debug("Old tag: {}", (Object)oldTag);
        CompoundTag newTag = new CompoundTag();
        ListTag entries = new ListTag();
        for (String key : oldTag.m_128431_()) {
            int kills = oldTag.m_128451_(key);
            CompoundTag entryTag = new CompoundTag();
            entryTag.m_128359_(BestiaryKey.Entry.ID.get(), key);
            entryTag.m_128405_(BestiaryKey.Entry.KILLS.get(), kills);
            entryTag.m_128365_(BestiaryKey.Entry.SPENT_POINTS.get(), (Tag)new CompoundTag());
            entries.add((Object)entryTag);
        }
        newTag.m_128365_(BestiaryKey.ENTRIES.get(), (Tag)entries);
        newTag.m_128405_(BestiaryKey.VERSION.get(), 2);
        Bestia.LOGGER.debug("New tag: {}", (Object)newTag);
        return newTag;
    }

    public void onKillWithSync(ServerPlayer player, ResourceLocation mobId) {
        this.addKillsAndSync(player, mobId, 1);
    }

    public void setLevelAndSync(ServerPlayer player, ResourceLocation mobId, int level) {
        if (level > (Integer)BestiaCommonConfig.MAX_LEVEL.get()) {
            Bestia.LOGGER.warn("Attempted to set bestiary level above max");
            return;
        }
        int newKills = BestiaryData.totalNeededForLevel(level);
        this.setKillsAndSync(player, mobId, newKills);
    }

    public void addLevelsAndSync(ServerPlayer player, ResourceLocation mobId, int levels) {
        int oldLevel;
        int n = oldLevel = this.cachedData.get(mobId) == null ? 0 : this.cachedData.get(mobId).level();
        if (oldLevel + levels > (Integer)BestiaCommonConfig.MAX_LEVEL.get()) {
            Bestia.LOGGER.warn("Attempted to adjust bestiary level above max");
            return;
        }
        int newKills = BestiaryData.totalNeededForLevel(oldLevel + levels);
        this.setKillsAndSync(player, mobId, newKills);
    }

    public void setKillsAndSync(ServerPlayer player, ResourceLocation mobId, int kills) {
        if (!MobIdUtil.validBestiaryMob(mobId, LogicalSide.SERVER)) {
            Bestia.LOGGER.warn("Attempted to modify Bestiary for invalid mob ID: {}", (Object)mobId);
            return;
        }
        BestiaryData newData = BestiaryData.compute(kills, this.spentPoints.getOrDefault(mobId, new HashMap()));
        int oldLevel = this.getData(mobId).level();
        this.killCounts.put(mobId, kills);
        this.cachedData.put(mobId, newData);
        this.spentPoints.put(mobId, newData.spentPoints());
        this.syncToPlayer(player);
        if (newData.level() != oldLevel) {
            this.sendToast(player, mobId);
        }
    }

    public void addKillsAndSync(ServerPlayer player, ResourceLocation mobId, int kills) {
        int newKills = this.killCounts.getOrDefault(mobId, 0) + kills;
        this.setKillsAndSync(player, mobId, newKills);
    }

    public void onSpendPointWithSync(ServerPlayer player, ResourceLocation mobId, ResourceLocation specialBuff) {
        if (this.getSpecialBuffLevel(SpecialBuffRegistry.get(specialBuff), mobId) >= SpecialBuffRegistry.get(specialBuff).getMaxLevel()) {
            Bestia.LOGGER.warn("Client attempted to spend buff point, but buff is maxed.");
            return;
        }
        if (this.cachedData.get(mobId).remainingPoints() <= 0) {
            Bestia.LOGGER.warn("Client attempted to spend buff point, but no points are available.");
            return;
        }
        int newPoints = this.spentPoints.computeIfAbsent(mobId, id -> new HashMap()).getOrDefault(specialBuff, 0) + 1;
        this.spentPoints.get(mobId).put(specialBuff, newPoints);
        this.cachedData.put(mobId, BestiaryData.compute(this.killCounts.get(mobId), this.spentPoints.get(mobId)));
        this.syncToPlayer(player);
    }

    public void onClearPointsWithSync(ServerPlayer player, ResourceLocation mobId) {
        Map<ResourceLocation, Integer> points = this.spentPoints.get(mobId);
        if (points != null) {
            points.clear();
        }
        if (this.cachedData.containsKey(mobId)) {
            this.cachedData.put(mobId, BestiaryData.compute(this.killCounts.get(mobId), this.spentPoints.get(mobId)));
        }
        this.syncToPlayer(player);
    }

    public int getKillCount(ResourceLocation mobId) {
        return MobIdUtil.validBestiaryMob(mobId, LogicalSide.SERVER) ? this.killCounts.getOrDefault(mobId, 0) : 0;
    }

    public BestiaryData getData(ResourceLocation mobId) {
        return MobIdUtil.validBestiaryMob(mobId, LogicalSide.SERVER) ? this.cachedData.getOrDefault(mobId, BestiaryData.compute(0, new HashMap<ResourceLocation, Integer>())) : BestiaryData.compute(0, new HashMap<ResourceLocation, Integer>());
    }

    public Map<ResourceLocation, BestiaryData> getAllData() {
        return Collections.unmodifiableMap(this.cachedData);
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        ListTag entries = new ListTag();
        for (Map.Entry<ResourceLocation, BestiaryData> entry : this.cachedData.entrySet()) {
            CompoundTag entryTag = new CompoundTag();
            entryTag.m_128359_(BestiaryKey.Entry.ID.get(), entry.getKey().toString());
            entryTag.m_128405_(BestiaryKey.Entry.KILLS.get(), entry.getValue().kills());
            CompoundTag spentPointsTag = new CompoundTag();
            for (Map.Entry<ResourceLocation, Integer> buff : entry.getValue().spentPoints().entrySet()) {
                spentPointsTag.m_128405_(buff.getKey().toString(), buff.getValue().intValue());
            }
            entryTag.m_128365_(BestiaryKey.Entry.SPENT_POINTS.get(), (Tag)spentPointsTag);
            entries.add((Object)entryTag);
        }
        tag.m_128359_(BestiaryKey.PLAYER_NAME.get(), this.playerName);
        tag.m_128365_(BestiaryKey.ENTRIES.get(), (Tag)entries);
        tag.m_128405_(BestiaryKey.VERSION.get(), 3);
        return tag;
    }

    public void syncToPlayer(ServerPlayer player) {
        ModPackets.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new BestiarySyncPacket(this.getAllData()));
    }

    public void sendToast(ServerPlayer player, ResourceLocation mobId) {
        if (((Boolean)BestiaClientConfig.SHOW_LEVEL_UP_TOASTS.get()).booleanValue()) {
            ModPackets.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new MobLevelUpToastPacket(mobId));
        }
    }

    public int getSpecialBuffLevel(SpecialBuff<?> buff, ResourceLocation mobId) {
        return (Boolean)BestiaCommonConfig.ENABLE_SPECIAL_BUFFS.get() != false && MobIdUtil.validBestiaryMob(mobId, LogicalSide.SERVER) ? ((Map)this.spentPoints.getOrDefault(mobId, new HashMap())).getOrDefault(buff.getId(), 0) : 0;
    }

    public <T> T getSpecialBuffValue(SpecialBuff<T> buff, ResourceLocation mobId) {
        return buff.computeValue(this.getSpecialBuffLevel(buff, mobId));
    }

    public String getPlayerName() {
        return this.playerName;
    }
}

