/*
 * Decompiled with CFR 0.152.
 */
package net.luko.bestia.data.leaderboard;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.luko.bestia.Bestia;
import net.luko.bestia.config.BestiaCommonConfig;
import net.luko.bestia.data.BestiaryKey;
import net.luko.bestia.data.BestiaryManager;
import net.luko.bestia.data.PlayerBestiaryStore;
import net.luko.bestia.data.leaderboard.LeaderboardEntry;
import net.luko.bestia.server.BestiaryOfflineCache;
import net.luko.bestia.util.MobIdUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.GameProfileCache;
import net.minecraftforge.fml.LogicalSide;

public class LeaderboardManager {
    public static List<LeaderboardEntry> getLeaderboard(ResourceLocation mobId, MinecraftServer server) {
        if (!MobIdUtil.validBestiaryMob(mobId, LogicalSide.SERVER)) {
            Bestia.LOGGER.error("Player requested leaderboard data for invalid mob");
            return null;
        }
        ArrayList<LeaderboardEntry> leaderboard = new ArrayList<LeaderboardEntry>();
        LeaderboardManager.addOnlinePlayers(leaderboard, mobId);
        LeaderboardManager.addOfflinePlayers(leaderboard, mobId, server);
        return leaderboard;
    }

    private static void addOnlinePlayers(List<LeaderboardEntry> leaderboard, ResourceLocation mobId) {
        for (BestiaryManager manager : PlayerBestiaryStore.getAll().values()) {
            String name = manager.getPlayerName();
            int level = manager.getData(mobId).level();
            if (level < (Integer)BestiaCommonConfig.MIN_LEADERBOARD_LEVEL.get()) continue;
            leaderboard.add(new LeaderboardEntry(name, level));
        }
    }

    private static void addOfflinePlayers(List<LeaderboardEntry> leaderboard, ResourceLocation mobId, MinecraftServer server) {
        Map<UUID, CompoundTag> offlineTags = BestiaryOfflineCache.getAll();
        for (Map.Entry<UUID, CompoundTag> entry : offlineTags.entrySet()) {
            UUID uuid = entry.getKey();
            CompoundTag tag = entry.getValue();
            BestiaryManager tempManager = new BestiaryManager();
            tempManager.loadFromNBT(tag, null);
            int level = tempManager.getData(mobId).level();
            if (level < (Integer)BestiaCommonConfig.MIN_LEADERBOARD_LEVEL.get()) continue;
            String name = tag.m_128441_(BestiaryKey.PLAYER_NAME.get()) ? tag.m_128461_(BestiaryKey.PLAYER_NAME.get()) : LeaderboardManager.getNameWithoutTag(uuid, server);
            leaderboard.add(new LeaderboardEntry(name, level));
        }
    }

    public static String getNameWithoutTag(UUID uuid, MinecraftServer server) {
        Optional optionalGameProfile;
        ServerPlayer onlinePlayer = server.m_6846_().m_11259_(uuid);
        if (onlinePlayer != null) {
            return onlinePlayer.m_7755_().getString();
        }
        GameProfileCache gameProfileCache = server.m_129927_();
        if (gameProfileCache != null && (optionalGameProfile = gameProfileCache.m_11002_(uuid)).isPresent()) {
            return ((GameProfile)optionalGameProfile.get()).getName();
        }
        Bestia.LOGGER.warn("Could not find name for player: {}, this is either a bug or this player played before mod version 3.0 and has not logged in for a while.", (Object)uuid);
        return uuid.toString();
    }
}

