/*
 * Decompiled with CFR 0.152.
 */
package net.luko.bestia.network;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.luko.bestia.data.leaderboard.LeaderboardEntry;
import net.luko.bestia.screen.BestiaryScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;

public class LeaderboardPacket {
    private final ResourceLocation mobId;
    private final List<LeaderboardEntry> leaderboard;

    public LeaderboardPacket(ResourceLocation mobId, List<LeaderboardEntry> leaderboard) {
        this.mobId = mobId;
        this.leaderboard = leaderboard;
    }

    public static void encode(LeaderboardPacket packet, FriendlyByteBuf buf) {
        buf.m_130085_(packet.mobId);
        buf.writeInt(packet.leaderboard.size());
        for (LeaderboardEntry entry : packet.leaderboard) {
            buf.m_130070_(entry.name());
            buf.writeInt(entry.level());
        }
    }

    public static LeaderboardPacket decode(FriendlyByteBuf buf) {
        ResourceLocation mobId = buf.m_130281_();
        int size = buf.readInt();
        ArrayList<LeaderboardEntry> leaderboard = new ArrayList<LeaderboardEntry>();
        for (int i = 0; i < size; ++i) {
            String name = buf.m_130277_();
            int level = buf.readInt();
            leaderboard.add(new LeaderboardEntry(name, level));
        }
        return new LeaderboardPacket(mobId, leaderboard);
    }

    public static void handle(LeaderboardPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            Screen patt1813$temp = Minecraft.m_91087_().f_91080_;
            if (patt1813$temp instanceof BestiaryScreen) {
                BestiaryScreen screen = (BestiaryScreen)patt1813$temp;
                screen.openLeaderboardScreenComponent(packet.mobId, packet.leaderboard);
            }
        });
        context.setPacketHandled(true);
    }
}

