/*
 * Decompiled with CFR 0.152.
 */
package net.luko.bestia.network;

import java.util.function.Supplier;
import net.luko.bestia.client.ClientBestiaryData;
import net.luko.bestia.data.BestiaryData;
import net.luko.bestia.screen.MobLevelUpToast;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkEvent;

public class MobLevelUpToastPacket {
    private final ResourceLocation mobId;

    public MobLevelUpToastPacket(ResourceLocation mobId) {
        this.mobId = mobId;
    }

    public static void encode(MobLevelUpToastPacket msg, FriendlyByteBuf buf) {
        buf.m_130085_(msg.mobId);
    }

    public static MobLevelUpToastPacket decode(FriendlyByteBuf buf) {
        return new MobLevelUpToastPacket(buf.m_130281_());
    }

    public static void handle(MobLevelUpToastPacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (FMLEnvironment.dist == Dist.CLIENT) {
                ClientHandler.handle(msg);
            }
        });
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class ClientHandler {
        private ClientHandler() {
        }

        static void handle(MobLevelUpToastPacket msg) {
            BestiaryData data = ClientBestiaryData.getFor(msg.mobId);
            Minecraft mc = Minecraft.m_91087_();
            mc.m_91300_().m_94922_((Toast)new MobLevelUpToast(msg.mobId, data));
            mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12275_, (float)1.0f));
        }
    }
}

