/*
 * Decompiled with CFR 0.152.
 */
package net.luko.bestia.network;

import java.util.function.Supplier;
import net.luko.bestia.data.BestiaryManager;
import net.luko.bestia.data.PlayerBestiaryStore;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class SpendPointPacket {
    private final ResourceLocation mobId;
    private final ResourceLocation buffId;

    public SpendPointPacket(ResourceLocation mobId, ResourceLocation buffId) {
        this.mobId = mobId;
        this.buffId = buffId;
    }

    public static void encode(SpendPointPacket packet, FriendlyByteBuf buf) {
        buf.m_130085_(packet.mobId);
        buf.m_130085_(packet.buffId);
    }

    public static SpendPointPacket decode(FriendlyByteBuf buf) {
        ResourceLocation mobId = buf.m_130281_();
        ResourceLocation buffId = buf.m_130281_();
        return new SpendPointPacket(mobId, buffId);
    }

    public static void handle(SpendPointPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                BestiaryManager manager = PlayerBestiaryStore.get(player);
                manager.onSpendPointWithSync(player, packet.mobId, packet.buffId);
            }
        });
        context.setPacketHandled(true);
    }
}

