/*
 * Decompiled with CFR 0.152.
 */
package net.luko.bestia.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.luko.bestia.config.BestiaClientConfig;
import net.luko.bestia.data.BestiaryData;
import net.luko.bestia.screen.side.BestiaryEntryScreenComponent;
import net.luko.bestia.util.ResourceUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.resources.ResourceLocation;

public class MobLevelUpToast
implements Toast {
    private static final ResourceLocation BACKGROUND_TEXTURE = ResourceUtil.fromNamespaceAndPath("bestia", "textures/gui/bestiary/side_panel.png");
    private static final int BACKGROUND_TEXTURE_BORDER_SIZE = 9;
    protected static final int BACKGROUND_TEXTURE_WIDTH = 240;
    protected static final int BACKGROUND_TEXTURE_HEIGHT = 294;
    private static final Font FONT = Minecraft.m_91087_().f_91062_;
    private static final String LEVEL_UP_TEXT = "Level up!";
    private static final int PADDING = 3;
    private static final int TOP_PADDING = 6;
    private static final float LEVEL_UP_SCALE = 1.5f;
    private static final float LINE_HEIGHT;
    private final BestiaryEntryScreenComponent entry;
    private final float toastScale;

    public MobLevelUpToast(ResourceLocation mobId, BestiaryData data) {
        this.entry = new BestiaryEntryScreenComponent(mobId, data, null, false);
        this.toastScale = ((Double)BestiaClientConfig.LEVEL_UP_TOAST_SCALE.get()).floatValue();
    }

    public int m_7828_() {
        return (int)this.scaledWidth();
    }

    public int m_94899_() {
        return Math.min((int)this.scaledHeight(), 160);
    }

    public int unscaledWidth() {
        return 236;
    }

    public int unscaledHeight() {
        return 27 + (int)LINE_HEIGHT + 69;
    }

    public float scaledWidth() {
        return (float)this.unscaledWidth() * this.toastScale;
    }

    public float scaledHeight() {
        return (float)this.unscaledHeight() * this.toastScale;
    }

    public Toast.Visibility m_7172_(GuiGraphics guiGraphics, ToastComponent toastComponent, long timeSinceLastVisible) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_85841_(this.toastScale, this.toastScale, 1.0f);
        this.blitPanel(guiGraphics, 0, 0, this.unscaledWidth(), this.unscaledHeight());
        poseStack.m_85836_();
        poseStack.m_252880_((float)this.unscaledWidth() / 2.0f - (float)FONT.m_92895_(LEVEL_UP_TEXT) / 2.0f * 1.5f, 15.0f, 0.0f);
        poseStack.m_85841_(1.5f, 1.5f, 1.0f);
        guiGraphics.m_280488_(FONT, LEVEL_UP_TEXT, 0, 0, 0xFFFFFF);
        poseStack.m_85849_();
        this.entry.render(guiGraphics, 12, (int)(15.0f + LINE_HEIGHT));
        poseStack.m_85849_();
        return timeSinceLastVisible >= 5000L ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
    }

    protected void blitPanel(GuiGraphics guiGraphics, int x, int y, int width, int height) {
        guiGraphics.m_280163_(BACKGROUND_TEXTURE, x, y, 0.0f, 0.0f, 9, 9, 240, 294);
        guiGraphics.blitRepeating(BACKGROUND_TEXTURE, x + 9, y, width - 18, 9, 9, 0, 222, 9, 240, 294);
        guiGraphics.m_280163_(BACKGROUND_TEXTURE, x + width - 9, y, 231.0f, 0.0f, 9, 9, 240, 294);
        guiGraphics.blitRepeating(BACKGROUND_TEXTURE, x, y + 9, 9, height - 18, 0, 9, 9, 276, 240, 294);
        guiGraphics.blitRepeating(BACKGROUND_TEXTURE, x + 9, y + 9, width - 18, height - 18, 9, 9, 222, 276, 240, 294);
        guiGraphics.blitRepeating(BACKGROUND_TEXTURE, x + width - 9, y + 9, 9, height - 18, 231, 9, 9, 276, 240, 294);
        guiGraphics.m_280163_(BACKGROUND_TEXTURE, x, y + height - 9, 0.0f, 285.0f, 9, 9, 240, 294);
        guiGraphics.blitRepeating(BACKGROUND_TEXTURE, x + 9, y + height - 9, width - 18, 9, 9, 285, 222, 9, 240, 294);
        guiGraphics.m_280163_(BACKGROUND_TEXTURE, x + width - 9, y + height - 9, 231.0f, 285.0f, 9, 9, 240, 294);
    }

    static {
        Objects.requireNonNull(FONT);
        LINE_HEIGHT = 9.0f * 1.5f;
    }
}

