/*
 * Decompiled with CFR 0.152.
 */
package net.luko.bestia.screen.side;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.luko.bestia.client.ClientConfigStore;
import net.luko.bestia.config.BestiaClientConfig;
import net.luko.bestia.data.BestiaryData;
import net.luko.bestia.data.buff.special.SpecialBuffRegistry;
import net.luko.bestia.screen.BestiaryScreen;
import net.luko.bestia.screen.BestiaryTooltip;
import net.luko.bestia.util.ResourceUtil;
import net.luko.bestia.util.RomanUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

public class BestiaryEntryScreenComponent {
    private static final int COMPONENT_TEXTURE_HEIGHT = 48;
    private static final int TITLE_TEXTURE_HEIGHT = 12;
    private static final int TITLE_TEXTURE_WIDTH = 20;
    private static final int TITLE_TEXTURE_LEFT_WIDTH = 1;
    private static final int TITLE_TEXTURE_MIDDLE_WIDTH = 18;
    private static final int TITLE_TEXTURE_RIGHT_WIDTH = 1;
    private static final int LEVEL_BAR_HEIGHT = 8;
    private static final int LEVEL_BAR_WIDTH = 212;
    private static final int LEVEL_BAR_PADDING = 1;
    public static final int ENTRY_HEIGHT = 69;
    public static final int ENTRY_WIDTH = 212;
    private static final ResourceLocation COMPONENT_TEXTURE_DARK = ResourceUtil.fromNamespaceAndPath("bestia", "textures/gui/bestiary/component_dark.png");
    private static final ResourceLocation COMPONENT_TEXTURE_LIGHT = ResourceUtil.fromNamespaceAndPath("bestia", "textures/gui/bestiary/component_light.png");
    private static final ResourceLocation TITLE_TEXTURE_DARK = ResourceUtil.fromNamespaceAndPath("bestia", "textures/gui/bestiary/title_dark.png");
    private static final ResourceLocation TITLE_TEXTURE_LIGHT = ResourceUtil.fromNamespaceAndPath("bestia", "textures/gui/bestiary/title_light.png");
    private static final ResourceLocation LEVEL_COMPLETED_DARK = ResourceUtil.fromNamespaceAndPath("bestia", "textures/gui/bestiary/level_completed_dark.png");
    private static final ResourceLocation LEVEL_COMPLETED_LIGHT = ResourceUtil.fromNamespaceAndPath("bestia", "textures/gui/bestiary/level_completed_light.png");
    private static final ResourceLocation LEVEL_BACKGROUND_DARK = ResourceUtil.fromNamespaceAndPath("bestia", "textures/gui/bestiary/level_background_dark.png");
    private static final ResourceLocation LEVEL_BACKGROUND_LIGHT = ResourceUtil.fromNamespaceAndPath("bestia", "textures/gui/bestiary/level_background_light.png");
    private final ResourceLocation mobId;
    private final BestiaryData data;
    private final EntityType<?> entityType;
    @Nullable
    private final BestiaryScreen parentScreen;
    private final boolean focused;
    private Set<BestiaryTooltip> tooltips = new HashSet<BestiaryTooltip>();
    private static final Font FONT = Minecraft.m_91087_().f_91062_;
    public boolean mouseIsHovering = false;
    private final int xPadding = 3;
    private final int verticalPadding = 5;

    public BestiaryEntryScreenComponent(ResourceLocation mobId, BestiaryData data, @Nullable BestiaryScreen parentScreen, boolean focused) {
        this.mobId = mobId;
        this.data = data;
        this.entityType = (EntityType)BuiltInRegistries.f_256780_.m_7745_(mobId);
        this.parentScreen = parentScreen;
        this.focused = focused;
    }

    public ResourceLocation getMobId() {
        return this.mobId;
    }

    public String getDisplayName() {
        return this.entityType != null ? this.entityType.m_20676_().getString() : this.mobId.toString();
    }

    public void checkMouse(int x, int y, int mouseX, int mouseY) {
        if (mouseX >= x + 2 && mouseX < x + 2 + this.getTitleBlitWidth(this.getDisplayName()) && mouseY >= y && mouseY < y + 12) {
            this.mouseIsHovering = true;
            return;
        }
        if (mouseX >= x && mouseX < x + 212 && mouseY >= y + 12 && mouseY < y + 69) {
            this.mouseIsHovering = true;
            return;
        }
        this.mouseIsHovering = false;
    }

    public void render(GuiGraphics guiGraphics, int x, int y) {
        this.tooltips.clear();
        int rightTitleX = this.drawTitle(guiGraphics, x + 2, y, this.getDisplayName());
        this.drawKills(guiGraphics, x + 212 - 2, y, String.format("%d kill%s", this.data.kills(), this.data.kills() == 1 ? "" : "s"));
        this.drawComponent(guiGraphics, x, y + 12);
        this.drawLevelBar(guiGraphics, x + 106, y + 69 - 8);
        this.drawLevelText(guiGraphics, x, y);
        if (this.entityType != null) {
            this.drawMobIcon(guiGraphics, x + 8, y + 12 + 12, this.entityType);
        }
        this.drawContent(guiGraphics, x + 48, 116, y + 12 + 5, 38);
        if (!this.focused && ((Boolean)BestiaClientConfig.SHOW_NOTIFICATION_BADGES.get()).booleanValue() && ClientConfigStore.INSTANCE.enableSpecialBuffs) {
            this.drawNotificationBadge(guiGraphics, rightTitleX - 4, y - 4);
        }
        this.tooltips.add(new BestiaryTooltip(x, x + 212, y + 69 - 8, y + 69, List.of(Component.m_237113_((String)(this.data.level() >= ClientConfigStore.INSTANCE.maxLevel ? "MAX LEVEL!" : String.format("%.1f%% (%d/%d kills)", Float.valueOf((1.0f - (float)this.data.remainingKills() / (float)this.data.neededForNextLevel()) * 100.0f), this.data.neededForNextLevel() - this.data.remainingKills(), this.data.neededForNextLevel()))))));
        this.mouseIsHovering = false;
    }

    private void drawContent(GuiGraphics guiGraphics, int x, int width, int y, int height) {
        String fullDamageText = String.format("x%.2f damage dealt", Float.valueOf(this.data.mobBuff().damageFactor()));
        String fullResistanceText = String.format("x%.3f damage taken", Float.valueOf(this.data.mobBuff().resistanceFactor()));
        if (!this.focused && ClientConfigStore.INSTANCE.enableSpecialBuffs) {
            int resistanceTextWidth;
            int resistanceWidth;
            ResourceLocation damageTexture = ResourceUtil.fromNamespaceAndPath("bestia", "textures/gui/bestiary/buff/damage.png");
            ResourceLocation resistanceTexture = ResourceUtil.fromNamespaceAndPath("bestia", "textures/gui/bestiary/buff/resistance.png");
            String damageText = String.format("x%.2f", Float.valueOf(this.data.mobBuff().damageFactor()));
            String resistanceText = String.format("x%.3f", Float.valueOf(this.data.mobBuff().resistanceFactor()));
            int iconSize = 12;
            int damageTextWidth = FONT.m_92895_(damageText);
            int damageWidth = iconSize + 3 + damageTextWidth;
            int totalAllowedPadding = width - damageWidth - (resistanceWidth = iconSize + 3 + (resistanceTextWidth = FONT.m_92895_(resistanceText)));
            int leftPad = totalAllowedPadding % 3 == 2 ? totalAllowedPadding / 3 + 1 : totalAllowedPadding / 3;
            int midPad = totalAllowedPadding % 3 == 1 ? totalAllowedPadding / 3 + 1 : totalAllowedPadding / 3;
            int nextX = x + leftPad;
            guiGraphics.m_280411_(damageTexture, nextX, y + 5, iconSize, iconSize, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
            this.tooltips.add(new BestiaryTooltip(nextX, nextX + iconSize, y + 5, y + 5 + iconSize, List.of(Component.m_237113_((String)fullDamageText))));
            guiGraphics.m_280488_(FONT, damageText, nextX += iconSize + 3, y + 5 + 2, 0xFFFFFF);
            guiGraphics.m_280411_(resistanceTexture, nextX += damageTextWidth + midPad, y + 5, iconSize, iconSize, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
            this.tooltips.add(new BestiaryTooltip(nextX, nextX + iconSize, y + 5, y + 5 + iconSize, List.of(Component.m_237113_((String)fullResistanceText))));
            guiGraphics.m_280488_(FONT, resistanceText, nextX += iconSize + 3, y + 5 + 2, 0xFFFFFF);
            if (this.data.totalPoints() == this.data.remainingPoints()) {
                String sbText = "No special buffs.";
                int sbTextWidth = FONT.m_92895_(sbText);
                int sbTextX = x + width / 2 - sbTextWidth / 2;
                Objects.requireNonNull(FONT);
                guiGraphics.m_280488_(FONT, sbText, sbTextX, y + height - 5 - 9 - 2, 0xAAAAAA);
            } else {
                this.drawIconsAndRoman(guiGraphics, x, width, y + height - 5 - iconSize);
            }
        } else {
            guiGraphics.m_280488_(FONT, fullDamageText, x + 3, y + 5 + 2, 0xAAAAAA);
            Objects.requireNonNull(FONT);
            guiGraphics.m_280488_(FONT, fullResistanceText, x + 3, y + height - 5 - 9 - 2, 0xAAAAAA);
        }
    }

    private void drawIconsAndRoman(GuiGraphics guiGraphics, int x, int width, int y) {
        LinkedHashMap applicableSpecialBuffs = new LinkedHashMap(this.data.spentPoints().entrySet().stream().filter(entry -> SpecialBuffRegistry.get((ResourceLocation)entry.getKey()) != null).filter(entry -> (Integer)entry.getValue() > 0).sorted((a, b) -> (Integer)b.getValue() - (Integer)a.getValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a, LinkedHashMap::new)));
        ArrayList<RenderableSpecialBuff> toBlit = new ArrayList<RenderableSpecialBuff>();
        int totalToBlitWidth = 0;
        int additionalBuffs = 0;
        Object additionalBuffsText = "";
        for (Map.Entry entry2 : applicableSpecialBuffs.entrySet()) {
            RenderableSpecialBuff ir = new RenderableSpecialBuff((ResourceLocation)entry2.getKey(), (Integer)entry2.getValue());
            if ((totalToBlitWidth += ir.width() + 3) >= width) {
                int buffsLeftOver = applicableSpecialBuffs.size() - toBlit.size();
                if (buffsLeftOver <= 0 || toBlit.isEmpty()) break;
                RenderableSpecialBuff last = (RenderableSpecialBuff)toBlit.get(toBlit.size() - 1);
                totalToBlitWidth -= last.width();
                toBlit.remove(toBlit.size() - 1);
                additionalBuffs = buffsLeftOver + 1;
                additionalBuffsText = "+" + additionalBuffs;
                while (totalToBlitWidth >= width - FONT.m_92895_((String)additionalBuffsText)) {
                    last = (RenderableSpecialBuff)toBlit.get(toBlit.size() - 1);
                    totalToBlitWidth -= last.width();
                    toBlit.remove(toBlit.size() - 1);
                    additionalBuffsText = "+" + ++additionalBuffs;
                }
                break;
            }
            toBlit.add(ir);
        }
        int totalWidth = FONT.m_92895_((String)additionalBuffsText);
        for (RenderableSpecialBuff ir : toBlit) {
            totalWidth += ir.width() + 3;
        }
        int nextX = x + width / 2 - totalWidth / 2;
        for (RenderableSpecialBuff ir : toBlit) {
            nextX = ir.blitAndAddTooltip(guiGraphics, nextX, y, this.tooltips) + 3;
        }
        if (additionalBuffs > 0) {
            guiGraphics.m_280488_(FONT, (String)additionalBuffsText, nextX, y + 2, 0xAAAAAA);
        }
    }

    public Set<BestiaryTooltip> getTooltips() {
        return this.tooltips;
    }

    private int getTitleBlitWidth(String name) {
        return 7 + FONT.m_92895_(name) + 1;
    }

    private int drawTitle(GuiGraphics guiGraphics, int x, int y, String name) {
        int textWidth = FONT.m_92895_(name);
        ResourceLocation backgroundTexture = this.mouseIsHovering ? TITLE_TEXTURE_LIGHT : TITLE_TEXTURE_DARK;
        guiGraphics.m_280163_(backgroundTexture, x, y, 0.0f, 0.0f, 1, 12, 20, 12);
        int middleXEnd = x + 1 + 6 + textWidth;
        for (int middleXBlit = x + 1; middleXBlit < middleXEnd; middleXBlit += 18) {
            int blitWidth = Math.min(18, middleXEnd - middleXBlit);
            guiGraphics.m_280163_(backgroundTexture, middleXBlit, y, 1.0f, 0.0f, blitWidth, 12, 20, 12);
        }
        guiGraphics.m_280163_(backgroundTexture, middleXEnd, y, 19.0f, 0.0f, 1, 12, 20, 12);
        guiGraphics.m_280488_(FONT, name, x + 1 + 3, y + 3, 0xFFFFFF);
        return middleXEnd + 1;
    }

    private void drawKills(GuiGraphics guiGraphics, int maxX, int y, String kills) {
        int textWidth = FONT.m_92895_(kills);
        ResourceLocation titleTexture = this.mouseIsHovering ? TITLE_TEXTURE_LIGHT : TITLE_TEXTURE_DARK;
        int x = maxX - 6 - 1 - 1 - textWidth;
        guiGraphics.m_280163_(titleTexture, x, y, 0.0f, 0.0f, 1, 12, 20, 12);
        int middleXEnd = x + 1 + 6 + textWidth;
        for (int middleXBlit = x + 1; middleXBlit < middleXEnd; middleXBlit += 18) {
            int blitWidth = Math.min(18, middleXEnd - middleXBlit);
            guiGraphics.m_280163_(titleTexture, middleXBlit, y, 1.0f, 0.0f, blitWidth, 12, 20, 12);
        }
        guiGraphics.m_280163_(titleTexture, middleXEnd, y, 19.0f, 0.0f, 1, 12, 20, 12);
        guiGraphics.m_280488_(FONT, kills, x + 1 + 3, y + 3, 0xFFFFFF);
    }

    private void drawComponent(GuiGraphics guiGraphics, int x, int y) {
        ResourceLocation texture = this.mouseIsHovering ? COMPONENT_TEXTURE_LIGHT : COMPONENT_TEXTURE_DARK;
        guiGraphics.m_280163_(texture, x, y, 0.0f, 0.0f, 212, 48, 212, 48);
    }

    private void drawLevelBar(GuiGraphics guiGraphics, int middleX, int y) {
        ResourceLocation completedTexture = this.mouseIsHovering ? LEVEL_COMPLETED_LIGHT : LEVEL_COMPLETED_DARK;
        ResourceLocation backgroundTexture = this.mouseIsHovering ? LEVEL_BACKGROUND_LIGHT : LEVEL_BACKGROUND_DARK;
        int x = middleX - 106;
        int needed = this.data.neededForNextLevel();
        int split = needed == 0 ? 212 : Math.round(212.0f * (float)(needed - this.data.remainingKills()) / (float)needed);
        guiGraphics.m_280163_(completedTexture, x, y, 0.0f, 0.0f, split, 8, 212, 8);
        guiGraphics.m_280163_(backgroundTexture, x + split, y, (float)split, 0.0f, 212 - split, 8, 212, 8);
    }

    private void drawLevelText(GuiGraphics guiGraphics, int x, int y) {
        String levelText = String.format("%d", this.data.level());
        int levelWidth = FONT.m_92895_(levelText);
        float levelScale = Math.min(2.5f, 34.0f / (float)levelWidth);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85841_(levelScale, levelScale, 1.0f);
        float centerX = (float)(x + 212) - 23.0f;
        float levelTextX = centerX / levelScale - (float)levelWidth / 2.0f;
        float levelTextY = ((float)y + 20.0f) / levelScale + 12.0f / (float)Math.pow(levelScale, 1.5);
        guiGraphics.drawString(FONT, levelText, levelTextX, levelTextY, -1, false);
        guiGraphics.m_280168_().m_85849_();
    }

    private void drawNotificationBadge(GuiGraphics guiGraphics, int x, int y) {
        int unspentPoints = this.data.remainingPoints();
        if (unspentPoints > 0) {
            ResourceLocation WIDGETS = ResourceUtil.fromNamespaceAndPath("bestia", "textures/gui/bestiary/badges.png");
            int widgetX = switch (unspentPoints) {
                case 1 -> 0;
                case 2 -> 11;
                case 3 -> 22;
                case 4 -> 33;
                case 5 -> 44;
                default -> 55;
            };
            int widgetY = 22;
            int widgetWidth = 11;
            int widgetHeight = 11;
            guiGraphics.m_280411_(WIDGETS, x, y, widgetWidth, widgetHeight, (float)widgetX, (float)widgetY, widgetWidth, widgetHeight, 66, 11);
            this.tooltips.add(new BestiaryTooltip(x, x + widgetWidth, y, y + widgetHeight, List.of(Component.m_237113_((String)String.format("%d unspent points", unspentPoints)))));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawMobIcon(GuiGraphics guiGraphics, int x, int y, EntityType<?> type) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        Entity entity = type.m_20615_((Level)mc.f_91073_);
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            float poseXRot = (float)Math.toRadians(10.0);
            Quaternionf pose = new Quaternionf().rotateY((float)Math.toRadians(165.0)).rotateZ((float)Math.toRadians(182.0)).rotateX(poseXRot);
            Quaternionf camera = new Quaternionf();
            if (living instanceof Mob) {
                Mob mob = (Mob)living;
                mob.m_21557_(true);
            }
            living.f_19797_ = 0;
            living.f_20883_ = 0.0f;
            living.m_146922_(0.0f);
            living.m_146926_(0.0f);
            living.f_20885_ = 0.0f;
            living.f_20886_ = 0.0f;
            if (this.mouseIsHovering) {
                RenderSystem.enableBlend();
                RenderSystem.setShaderColor((float)1.2f, (float)1.2f, (float)1.2f, (float)1.0f);
            }
            try {
                InventoryScreen.m_280432_((GuiGraphics)guiGraphics, (int)(x + 16), (int)(y + 32 + this.computeEntityYOffset(living, poseXRot)), (int)this.computeEntityScale(living), (Quaternionf)pose, (Quaternionf)camera, (LivingEntity)living);
            }
            finally {
                if (this.mouseIsHovering) {
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    RenderSystem.disableBlend();
                }
            }
        }
    }

    private int computeEntityScale(LivingEntity entity) {
        float size = (entity.m_20206_() + entity.m_20205_()) / 2.0f;
        float min = 14.0f;
        float max = 28.0f;
        float steepness = 8.0f;
        float midpoint = 1.2f;
        float logistic = 1.0f / (1.0f + (float)Math.exp(-steepness * (size - midpoint)));
        float scale = (min + (max - min) * logistic) / size;
        return Math.round(scale);
    }

    private int computeEntityYOffset(LivingEntity entity, float pitchRadians) {
        float flatness = entity.m_20205_() / entity.m_20206_();
        float sinPitch = (float)Math.sin(pitchRadians);
        float factor = 20.0f;
        return -Math.round(factor * flatness * sinPitch);
    }

    public int kills() {
        return this.data.kills();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.mouseIsHovering && button == 0) {
            if (this.parentScreen != null) {
                this.parentScreen.openFocusedEntryScreenComponent(this.mobId, this.data);
            }
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            return true;
        }
        return false;
    }

    private record RenderableSpecialBuff(ResourceLocation buff, Integer level) {
        private static int ICON_SIZE = 12;
        private static float ROMAN_SCALE = 0.6f;

        private String roman() {
            return RomanUtil.toRoman(this.level);
        }

        private ResourceLocation icon() {
            return ResourceUtil.fromNamespaceAndPath(this.buff().m_135827_(), "textures/gui/bestiary/buff/" + this.buff().m_135815_() + ".png");
        }

        private int width() {
            return ICON_SIZE + (int)Math.ceil((float)FONT.m_92895_(this.roman()) * ROMAN_SCALE);
        }

        private int blitAndAddTooltip(GuiGraphics guiGraphics, int x, int y, Set<BestiaryTooltip> tooltips) {
            guiGraphics.m_280411_(this.icon(), x, y, ICON_SIZE, ICON_SIZE, 0.0f, 0.0f, ICON_SIZE, ICON_SIZE, ICON_SIZE, ICON_SIZE);
            tooltips.add(new BestiaryTooltip(x, x + ICON_SIZE, y, y + ICON_SIZE, List.of(Component.m_237113_((String)String.format("%s %s", Component.m_237115_((String)("buff.special." + this.buff.m_135827_() + "." + this.buff.m_135815_())).getString(), this.roman())))));
            PoseStack poseStack = guiGraphics.m_280168_();
            poseStack.m_85836_();
            poseStack.m_85841_(ROMAN_SCALE, ROMAN_SCALE, 1.0f);
            poseStack.m_252880_((float)(x + ICON_SIZE) / ROMAN_SCALE, (float)y / ROMAN_SCALE, 0.0f);
            String roman = this.roman();
            int romanWidth = FONT.m_92895_(roman);
            guiGraphics.m_280488_(FONT, roman, -romanWidth / 2, 0, 0xFFFFFF);
            poseStack.m_85849_();
            return x + this.width();
        }
    }
}

