/*
 * Decompiled with CFR 0.152.
 */
package net.luko.bestia.screen.side;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.luko.bestia.client.ClientBestiaryData;
import net.luko.bestia.client.ClientConfigStore;
import net.luko.bestia.data.leaderboard.LeaderboardEntry;
import net.luko.bestia.screen.BestiaryScreen;
import net.luko.bestia.screen.side.BestiarySideScreenComponent;
import net.luko.bestia.screen.widget.CustomButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.registries.ForgeRegistries;

public class BestiaryLeaderboardScreenComponent
extends BestiarySideScreenComponent {
    protected final ResourceLocation mobId;
    protected final List<LeaderboardEntry> leaderboard;
    protected final List<LeaderboardEntryDisplay> leaderboardDisplay;
    protected CustomButton backButton;
    protected static final float TEXT_SCALE = 1.5f;
    protected static final float TITLE_SCALE = 3.0f;
    protected static final float TITLE_PADDING = 10.0f;
    protected static final String RANK_FORMAT = "%d. ";
    protected static final String LEVEL_FORMAT = " - Level %d";
    protected static final String NO_ENTRIES = "Leaderboard is empty!";
    protected static final String NO_MINIMUM = "No minimum level.";
    protected static final String MINIMUM = "Level %d needed to qualify!";

    public BestiaryLeaderboardScreenComponent(int x, int y, int width, BestiaryScreen parentScreen, ResourceLocation mobId, List<LeaderboardEntry> leaderboard) {
        super(x, y, width, parentScreen);
        this.mobId = mobId;
        this.leaderboard = this.sortLeaderboard(leaderboard);
        this.leaderboardDisplay = this.cacheDisplay();
        this.finalizeLayout();
    }

    private List<LeaderboardEntry> sortLeaderboard(List<LeaderboardEntry> leaderboard) {
        return leaderboard.stream().sorted(Comparator.comparingInt(LeaderboardEntry::level).reversed()).toList();
    }

    private List<LeaderboardEntryDisplay> cacheDisplay() {
        ArrayList<LeaderboardEntryDisplay> leaderboardDisplay = new ArrayList<LeaderboardEntryDisplay>();
        for (int i = 0; i < this.leaderboard.size(); ++i) {
            LeaderboardEntry entry = this.leaderboard.get(i);
            LeaderboardEntryDisplay display = new LeaderboardEntryDisplay(i + 1, entry);
            leaderboardDisplay.add(display);
        }
        return leaderboardDisplay;
    }

    public static int getNeededWidth() {
        int maxRank = 999;
        String maxPlayerName = "WWWWWWWWWWWWWWWW";
        int maxLevel = ClientConfigStore.INSTANCE.maxLevel;
        Font font = Minecraft.m_91087_().f_91062_;
        int maxRankWidth = (int)(1.5f * (float)font.m_92895_(String.format(RANK_FORMAT, maxRank)));
        int maxPlayerNameWidth = (int)(1.5f * (float)font.m_92895_(maxPlayerName));
        int maxLevelWidth = (int)(1.5f * (float)font.m_92895_(String.format(LEVEL_FORMAT, maxLevel)));
        return maxRankWidth + maxPlayerNameWidth + maxLevelWidth;
    }

    public static int getEntryHeightUnscaled() {
        Objects.requireNonNull(FONT);
        return 9 + 4;
    }

    public static int getTitleHeight() {
        Objects.requireNonNull(FONT);
        return (int)(3.0f * 9.0f + 10.0f);
    }

    public static int getEntryHeightScaled() {
        Objects.requireNonNull(FONT);
        return (int)(1.5f * (float)(9 + 4));
    }

    @Override
    public int getNeededHeight() {
        return (int)((float)BestiaryLeaderboardScreenComponent.getTitleHeight() + (this.leaderboard.isEmpty() ? (float)(BestiaryLeaderboardScreenComponent.getEntryHeightScaled() + 8) : 10.0f + (float)(this.leaderboard.size() * BestiaryLeaderboardScreenComponent.getEntryHeightScaled()))) + BestiaryLeaderboardScreenComponent.getEntryHeightScaled();
    }

    @Override
    public void finalizeLayout() {
        super.finalizeLayout();
        this.backButton = new CustomButton(this.x, this.y, 12, 12, (Component)Component.m_237113_((String)"<"), btn -> this.parentScreen.openFocusedEntryScreenComponent(this.mobId, ClientBestiaryData.getFor(this.mobId)));
    }

    @Override
    public void moveX(int x) {
        super.moveX(x);
        this.backButton.m_252865_(x);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.render(guiGraphics, mouseX, mouseY);
        this.backButton.m_88315_(guiGraphics, mouseX, mouseY, 0.0f);
    }

    @Override
    public void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        PoseStack poseStack = guiGraphics.m_280168_();
        float nextY = (float)(this.y + 9) + 10.0f;
        float minX = this.x + 9 + 4;
        float maxX = this.x + 9 + 4 + this.availableWidth;
        nextY = this.drawTitle(guiGraphics, minX, maxX, nextY);
        nextY += 10.0f;
        if (this.leaderboard.isEmpty()) {
            nextY = this.drawNoEntriesText(guiGraphics, minX, maxX, nextY);
        } else {
            poseStack.m_85836_();
            poseStack.m_85841_(1.5f, 1.5f, 1.0f);
            for (LeaderboardEntryDisplay display : this.leaderboardDisplay) {
                poseStack.m_85836_();
                poseStack.m_252880_(this.scaled(minX, 1.5f), this.scaled(nextY, 1.5f), 0.0f);
                nextY += (float)display.render(guiGraphics, 0, 0, this.availableWidth);
                poseStack.m_85849_();
            }
            poseStack.m_85849_();
        }
        nextY += 4.0f;
        nextY = this.drawFootnote(guiGraphics, minX, maxX, nextY);
    }

    private float drawTitle(GuiGraphics guiGraphics, float minX, float maxX, float y) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_85841_(3.0f, 3.0f, 1.0f);
        float nextY = y;
        EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(this.mobId);
        String title = entityType != null ? entityType.m_20676_().getString() : this.mobId.toString();
        float titleWidth = (float)FONT.m_92895_(title) * 3.0f;
        float titleX = minX + (maxX - minX) / 2.0f - titleWidth / 2.0f;
        poseStack.m_85836_();
        poseStack.m_252880_(this.scaled(titleX, 3.0f), this.scaled(nextY, 3.0f), 0.0f);
        guiGraphics.m_280488_(FONT, title, 0, 0, 0xFFFFFF);
        Objects.requireNonNull(FONT);
        poseStack.m_85849_();
        poseStack.m_85849_();
        return nextY += 9.0f * 3.0f + 4.0f;
    }

    private float drawNoEntriesText(GuiGraphics guiGraphics, float minX, float maxX, float y) {
        float nextY = y;
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_85841_(1.5f, 1.5f, 1.0f);
        float textWidth = (float)FONT.m_92895_(NO_ENTRIES) * 1.5f;
        float textX = minX + (maxX - minX) / 2.0f - textWidth / 2.0f;
        poseStack.m_252880_(this.scaled(textX, 1.5f), this.scaled(nextY, 1.5f), 0.0f);
        guiGraphics.m_280488_(FONT, NO_ENTRIES, 0, 0, 0xFFFFFF);
        Objects.requireNonNull(FONT);
        poseStack.m_85849_();
        return nextY += 1.5f * 9.0f + 4.0f;
    }

    private float drawFootnote(GuiGraphics guiGraphics, float minX, float maxX, float y) {
        float nextY = y;
        int minLevel = ClientConfigStore.INSTANCE.minLeaderboardLevel;
        String footnote = minLevel == 0 ? NO_MINIMUM : String.format(MINIMUM, minLevel);
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_85841_(1.5f, 1.5f, 1.0f);
        float textWidth = (float)FONT.m_92895_(footnote) * 1.5f;
        float textX = minX + (maxX - minX) / 2.0f - textWidth / 2.0f;
        poseStack.m_252880_(this.scaled(textX, 1.5f), this.scaled(nextY, 1.5f), 0.0f);
        guiGraphics.m_280488_(FONT, footnote, 0, 0, 0xAAAAAA);
        Objects.requireNonNull(FONT);
        poseStack.m_85849_();
        return nextY += 1.5f * 9.0f;
    }

    private float scaled(float coordinate, float scale) {
        return coordinate / scale;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.backButton.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    protected record LeaderboardEntryDisplay(int rank, LeaderboardEntry entry) {
        public Component entryText(int maxWidth) {
            String rankText = String.format(BestiaryLeaderboardScreenComponent.RANK_FORMAT, this.rank);
            Object playerText = this.entry.name();
            String levelText = String.format(BestiaryLeaderboardScreenComponent.LEVEL_FORMAT, this.entry.level());
            int rankTextWidth = (int)(1.5f * (float)BestiarySideScreenComponent.FONT.m_92895_(rankText));
            int playerTextWidth = (int)(1.5f * (float)BestiarySideScreenComponent.FONT.m_92895_((String)playerText));
            int levelTextWidth = (int)(1.5f * (float)BestiarySideScreenComponent.FONT.m_92895_(levelText));
            int nameMaxWidth = maxWidth;
            nameMaxWidth -= rankTextWidth;
            boolean shaved = false;
            if (playerTextWidth > (nameMaxWidth -= levelTextWidth)) {
                shaved = true;
                while (playerTextWidth > nameMaxWidth) {
                    playerText = ((String)playerText).substring(0, ((String)playerText).length() - 1);
                    playerTextWidth = (int)(1.5f * (float)BestiarySideScreenComponent.FONT.m_92895_((String)playerText));
                }
            }
            if (shaved) {
                playerText = (((String)playerText).length() < 3 ? "" : ((String)playerText).substring(0, ((String)playerText).length() - 3)) + "...";
            }
            return Component.m_237113_((String)(rankText + (String)playerText + levelText));
        }

        public int render(GuiGraphics guiGraphics, int x, int y, int maxWidth) {
            guiGraphics.m_280430_(BestiarySideScreenComponent.FONT, this.entryText(maxWidth), x, y, 0xFFFFFF);
            return BestiaryLeaderboardScreenComponent.getEntryHeightScaled();
        }
    }
}

