/*
 * Decompiled with CFR 0.152.
 */
package net.luko.bestia.screen.side;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashSet;
import java.util.Set;
import net.luko.bestia.screen.BestiaryScreen;
import net.luko.bestia.screen.BestiaryTooltip;
import net.luko.bestia.screen.widget.CustomButton;
import net.luko.bestia.screen.widget.ScrollBarWidget;
import net.luko.bestia.util.ResourceUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public abstract class BestiarySideScreenComponent {
    protected int x;
    protected int y;
    protected final int width;
    protected int height;
    protected CustomButton closeButton;
    protected ScrollBarWidget scrollBar;
    protected final BestiaryScreen parentScreen;
    protected final int availableWidth;
    protected static final int BORDER_SIZE = 9;
    protected static final int TEXTURE_WIDTH = 240;
    protected static final int TEXTURE_HEIGHT = 294;
    protected static final int OUTSIDE_BORDER_SIZE = 3;
    protected static final int BUTTON_SIZE = 12;
    public static final int PADDING = 4;
    protected static final Font FONT = Minecraft.m_91087_().f_91062_;
    protected float scrollAmount = 0.0f;
    protected Set<BestiaryTooltip> tooltips = new HashSet<BestiaryTooltip>();
    protected static final ResourceLocation TEXTURE = ResourceUtil.fromNamespaceAndPath("bestia", "textures/gui/bestiary/side_panel.png");

    public BestiarySideScreenComponent(int x, int y, int width, BestiaryScreen parentScreen) {
        this.x = x;
        this.y = y;
        this.parentScreen = parentScreen;
        this.width = width;
        this.availableWidth = this.width - 8 - 18;
    }

    public int getScrollBarThumbHeight() {
        return (int)((float)this.getVisibleHeight() / (float)this.getNeededHeight() * (float)this.getScrollBarTrackHeight());
    }

    public int getScrollBarTrackHeight() {
        return this.height - 12 - 3;
    }

    public void finalizeLayout() {
        this.height = Math.min(26 + this.getNeededHeight(), this.parentScreen.f_96544_ - 8);
        if (this.parentScreen.f_96544_ < this.height + 2 * this.y) {
            this.y = (this.parentScreen.f_96544_ - this.height) / 2;
        }
        this.closeButton = new CustomButton(this.x + this.width - 12, this.y, 12, 12, (Component)Component.m_237113_((String)"X"), btn -> this.parentScreen.clearSideScreenComponent());
        this.scrollBar = new ScrollBarWidget(this.x + this.width - 9 + 1, this.y + 12, 4, this.getScrollBarTrackHeight(), (Component)Component.m_237113_((String)"Scroll"), this.getScrollBarThumbHeight(), normalized -> {
            this.scrollAmount = normalized.floatValue() * (float)this.getMaxScroll();
        });
        this.scrollBar.f_93624_ = this.getMaxScroll() > 0;
    }

    public abstract int getNeededHeight();

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.tooltips.clear();
        this.blitPanel(guiGraphics);
        this.closeButton.m_88315_(guiGraphics, mouseX, mouseY, 0.0f);
        this.scrollBar.f_93624_ = this.getMaxScroll() > 0;
        this.scrollBar.m_88315_(guiGraphics, mouseX, mouseY, 0.0f);
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, (float)((int)(-this.scrollAmount)), 0.0f);
        Minecraft mc = Minecraft.m_91087_();
        int scissorX = this.x + 9;
        int scissorY = this.y + 3;
        int scissorWidth = this.width;
        int scissorHeight = this.height - 6;
        float scaleFactor = (float)mc.m_91268_().m_85443_() / (float)mc.m_91268_().m_85445_();
        int windowHeight = Minecraft.m_91087_().m_91268_().m_85442_();
        RenderSystem.enableScissor((int)((int)((float)scissorX * scaleFactor)), (int)((int)((float)windowHeight - (float)(scissorY + scissorHeight) * scaleFactor) - 1), (int)((int)((float)scissorWidth * scaleFactor)), (int)((int)((float)scissorHeight * scaleFactor) + 2));
        this.renderContent(guiGraphics, mouseX, mouseY);
        poseStack.m_85849_();
        this.renderContentButtons(guiGraphics, mouseX, mouseY);
        RenderSystem.disableScissor();
    }

    public abstract void renderContent(GuiGraphics var1, int var2, int var3);

    public void renderContentButtons(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    public Set<BestiaryTooltip> getTooltips() {
        return this.tooltips;
    }

    public void moveX(int x) {
        this.x = x;
        if (this.closeButton != null) {
            this.closeButton.m_252865_(this.x + this.width - 12);
        }
        if (this.scrollBar != null) {
            this.scrollBar.m_252865_(this.x + this.width - 9 + 1);
        }
    }

    protected void blitPanel(GuiGraphics guiGraphics) {
        guiGraphics.m_280163_(TEXTURE, this.x, this.y, 0.0f, 0.0f, 9, 9, 240, 294);
        guiGraphics.blitRepeating(TEXTURE, this.x + 9, this.y, this.width - 9 - 9, 9, 9, 0, 222, 9, 240, 294);
        guiGraphics.m_280163_(TEXTURE, this.x + this.width - 9, this.y, 231.0f, 0.0f, 9, 9, 240, 294);
        guiGraphics.blitRepeating(TEXTURE, this.x, this.y + 9, 9, this.height - 9 - 9, 0, 9, 9, 276, 240, 294);
        guiGraphics.blitRepeating(TEXTURE, this.x + 9, this.y + 9, this.width - 9 - 9, this.height - 9 - 9, 9, 9, 222, 276, 240, 294);
        guiGraphics.blitRepeating(TEXTURE, this.x + this.width - 9, this.y + 9, 9, this.height - 9 - 9, 231, 9, 9, 276, 240, 294);
        guiGraphics.m_280163_(TEXTURE, this.x, this.y + this.height - 9, 0.0f, 285.0f, 9, 9, 240, 294);
        guiGraphics.blitRepeating(TEXTURE, this.x + 9, this.y + this.height - 9, this.width - 9 - 9, 9, 9, 285, 222, 9, 240, 294);
        guiGraphics.m_280163_(TEXTURE, this.x + this.width - 9, this.y + this.height - 9, 231.0f, 285.0f, 9, 9, 240, 294);
    }

    public boolean handleContentClick(double mouseX, double mouseY, int button) {
        return false;
    }

    public boolean containsMouse(int mouseX, int mouseY) {
        return mouseX >= this.x + 3 && mouseX <= this.x + this.width - 3 && mouseY >= this.y + 3 && mouseY <= this.y + this.height - 3;
    }

    public int getVisibleHeight() {
        return this.height - 18 - 8;
    }

    public int getMaxScroll() {
        return Math.max(0, this.getNeededHeight() - this.getVisibleHeight());
    }

    public void updateScrollBar() {
        float maxScroll = this.getMaxScroll();
        if (maxScroll <= 0.0f) {
            this.scrollBar.f_93624_ = false;
            return;
        }
        this.scrollBar.setThumbHeight(this.getScrollBarThumbHeight());
        this.scrollBar.setScrollAmount(this.scrollAmount / (float)this.getMaxScroll());
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.containsMouse((int)mouseX, (int)mouseY)) {
            return false;
        }
        if (this.closeButton.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.scrollBar.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        return this.handleContentClick(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        if (this.containsMouse((int)mouseX, (int)mouseY)) {
            this.scrollAmount -= (float)delta * 20.0f;
            float maxScroll = this.getMaxScroll();
            this.scrollAmount = Mth.m_14036_((float)this.scrollAmount, (float)0.0f, (float)maxScroll);
            this.updateScrollBar();
            return true;
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        return this.scrollBar.m_6348_(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return this.scrollBar.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }
}

